/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.asymmetric.ecgost;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ECDomainParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.asymmetric.ecgost.BCECGOST3410PrivateKey;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.asymmetric.ecgost.BCECGOST3410PublicKey;
import com.zeroturnaround.bundled.org.bouncycastle.jce.provider.BouncyCastleProvider;
import com.zeroturnaround.bundled.org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import com.zeroturnaround.bundled.org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import com.zeroturnaround.bundled.org.bouncycastle.jce.spec.ECParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    ECParameterSpec a;
    ECKeyPairGenerator a;
    String a;
    ECKeyGenerationParameters a;
    int a;
    SecureRandom a;
    boolean a = false;

    public KeyPairGeneratorSpi() {
        super("ECGOST3410");
    }

    public void initialize(int n2, SecureRandom secureRandom) {
        this.a = n2;
        this.a = secureRandom;
        if (this.a == null) {
            throw new InvalidParameterException("unknown key size.");
        }
        this.a = new ECKeyGenerationParameters(new ECDomainParameters(this.a.getCurve(), this.a.getG(), this.a.getN()), secureRandom);
        this.a.init(this.a);
        this.a = true;
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof ECParameterSpec) {
            ECParameterSpec eCParameterSpec;
            this.a = eCParameterSpec = (ECParameterSpec)algorithmParameterSpec;
            this.a = new ECKeyGenerationParameters(new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN()), secureRandom);
            this.a.init(this.a);
            this.a = true;
        } else if (algorithmParameterSpec instanceof ECNamedCurveGenParameterSpec) {
            String string = ((ECNamedCurveGenParameterSpec)algorithmParameterSpec).getName();
            ECDomainParameters eCDomainParameters = ECGOST3410NamedCurves.getByName(string);
            if (eCDomainParameters == null) {
                throw new InvalidAlgorithmParameterException("unknown curve name: " + string);
            }
            this.a = new ECNamedCurveParameterSpec(string, eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed());
            this.a = new ECKeyGenerationParameters(new ECDomainParameters(this.a.getCurve(), this.a.getG(), this.a.getN()), secureRandom);
            this.a.init(this.a);
            this.a = true;
        } else if (algorithmParameterSpec == null && BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa() != null) {
            ECParameterSpec eCParameterSpec = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
            this.a = null;
            this.a = new ECKeyGenerationParameters(new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN()), secureRandom);
            this.a.init(this.a);
            this.a = true;
        } else {
            if (algorithmParameterSpec == null && BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa() == null) {
                throw new InvalidAlgorithmParameterException("null parameter passed but no implicitCA set");
            }
            throw new InvalidAlgorithmParameterException("parameter object not a ECParameterSpec: " + algorithmParameterSpec.getClass().getName());
        }
    }

    public KeyPair generateKeyPair() {
        if (!this.a) {
            throw new IllegalStateException("EC Key Pair Generator not initialised");
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.a.generateKeyPair();
        ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        if (this.a == null) {
            return new KeyPair(new BCECGOST3410PublicKey(this.a, eCPublicKeyParameters), new BCECGOST3410PrivateKey(this.a, eCPrivateKeyParameters));
        }
        ECParameterSpec eCParameterSpec = this.a;
        BCECGOST3410PublicKey bCECGOST3410PublicKey = new BCECGOST3410PublicKey(this.a, eCPublicKeyParameters, eCParameterSpec);
        return new KeyPair(bCECGOST3410PublicKey, new BCECGOST3410PrivateKey(this.a, eCPrivateKeyParameters, bCECGOST3410PublicKey, eCParameterSpec));
    }
}

