/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.asymmetric.rsa;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.AsymmetricBlockCipher;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.CipherParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.InvalidCipherTextException;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.digests.MD5Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.digests.SHA224Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.digests.SHA256Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.digests.SHA384Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.digests.SHA512Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.encodings.ISO9796d1Encoding;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.encodings.OAEPEncoding;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.engines.RSABlindedEngine;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.RSAKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.asymmetric.rsa.RSAUtil;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.asymmetric.util.BaseCipherSpi;
import com.zeroturnaround.bundled.org.bouncycastle.util.Strings;
import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class CipherSpi
extends BaseCipherSpi {
    private AsymmetricBlockCipher cipher;
    private AlgorithmParameterSpec paramSpec;
    private AlgorithmParameters engineParams;
    private boolean publicKeyOnly = false;
    private boolean privateKeyOnly = false;
    private ByteArrayOutputStream bOut = new ByteArrayOutputStream();

    public CipherSpi(AsymmetricBlockCipher asymmetricBlockCipher) {
        this.cipher = asymmetricBlockCipher;
    }

    public CipherSpi(boolean bl2, boolean bl3, AsymmetricBlockCipher asymmetricBlockCipher) {
        this.publicKeyOnly = bl2;
        this.privateKeyOnly = bl3;
        this.cipher = asymmetricBlockCipher;
    }

    protected int engineGetBlockSize() {
        try {
            return this.cipher.getInputBlockSize();
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("RSA Cipher not initialised");
        }
    }

    protected int engineGetKeySize(Key key) {
        if (key instanceof RSAPrivateKey) {
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)key;
            return rSAPrivateKey.getModulus().bitLength();
        }
        if (key instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)key;
            return rSAPublicKey.getModulus().bitLength();
        }
        throw new IllegalArgumentException("not an RSA key!");
    }

    protected int engineGetOutputSize(int n2) {
        try {
            return this.cipher.getOutputBlockSize();
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("RSA Cipher not initialised");
        }
    }

    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null && this.paramSpec != null) {
            try {
                this.engineParams = AlgorithmParameters.getInstance("OAEP", "BC");
                this.engineParams.init(this.paramSpec);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString());
            }
        }
        return this.engineParams;
    }

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        String string2 = Strings.toUpperCase(string);
        if (string2.equals("NONE") || string2.equals("ECB")) {
            return;
        }
        if (string2.equals("1")) {
            this.privateKeyOnly = true;
            this.publicKeyOnly = false;
            return;
        }
        if (string2.equals("2")) {
            this.privateKeyOnly = false;
            this.publicKeyOnly = true;
            return;
        }
        throw new NoSuchAlgorithmException("can't support mode " + string);
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        String string2 = Strings.toUpperCase(string);
        if (string2.equals("NOPADDING")) {
            this.cipher = new RSABlindedEngine();
        } else if (string2.equals("PKCS1PADDING")) {
            this.cipher = new PKCS1Encoding(new RSABlindedEngine());
        } else if (string2.equals("ISO9796-1PADDING")) {
            this.cipher = new ISO9796d1Encoding(new RSABlindedEngine());
        } else if (string2.equals("OAEPPADDING")) {
            this.cipher = new OAEPEncoding(new RSABlindedEngine());
        } else if (string2.equals("OAEPWITHSHA1ANDMGF1PADDING")) {
            this.cipher = new OAEPEncoding(new RSABlindedEngine());
        } else if (string2.equals("OAEPWITHSHA224ANDMGF1PADDING")) {
            this.cipher = new OAEPEncoding(new RSABlindedEngine(), new SHA224Digest());
        } else if (string2.equals("OAEPWITHSHA256ANDMGF1PADDING")) {
            this.cipher = new OAEPEncoding(new RSABlindedEngine(), new SHA256Digest());
        } else if (string2.equals("OAEPWITHSHA384ANDMGF1PADDING")) {
            this.cipher = new OAEPEncoding(new RSABlindedEngine(), new SHA384Digest());
        } else if (string2.equals("OAEPWITHSHA512ANDMGF1PADDING")) {
            this.cipher = new OAEPEncoding(new RSABlindedEngine(), new SHA512Digest());
        } else if (string2.equals("OAEPWITHMD5ANDMGF1PADDING")) {
            this.cipher = new OAEPEncoding(new RSABlindedEngine(), new MD5Digest());
        } else {
            throw new NoSuchPaddingException(string + " unavailable with RSA.");
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) throw new IllegalArgumentException("unknown parameter type.");
        if (key instanceof RSAPublicKey) {
            if (this.privateKeyOnly && n2 == 1) {
                throw new InvalidKeyException("mode 1 requires RSAPrivateKey");
            }
            RSAKeyParameters rSAKeyParameters = RSAUtil.a((RSAPublicKey)key);
        } else {
            if (!(key instanceof RSAPrivateKey)) throw new InvalidKeyException("unknown key type passed to RSA");
            if (this.publicKeyOnly && n2 == 1) {
                throw new InvalidKeyException("mode 2 requires RSAPublicKey");
            }
            RSAKeyParameters rSAKeyParameters = RSAUtil.a((RSAPrivateKey)key);
        }
        if (!(this.cipher instanceof RSABlindedEngine)) {
            void var5_7;
            if (secureRandom != null) {
                ParametersWithRandom parametersWithRandom = new ParametersWithRandom((CipherParameters)var5_7, secureRandom);
            } else {
                ParametersWithRandom parametersWithRandom = new ParametersWithRandom((CipherParameters)var5_7, new SecureRandom());
            }
        }
        switch (n2) {
            case 1: 
            case 3: {
                void var5_10;
                this.cipher.init(true, (CipherParameters)var5_10);
                return;
            }
            case 2: 
            case 4: {
                void var5_10;
                this.cipher.init(false, (CipherParameters)var5_10);
                return;
            }
            default: {
                throw new InvalidParameterException("unknown opmode " + n2 + " passed to RSA");
            }
        }
    }

    protected void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        if (algorithmParameters != null) {
            throw new InvalidAlgorithmParameterException("cannot recognise parameters.");
        }
        this.engineParams = algorithmParameters;
        this.engineInit(n2, key, algorithmParameterSpec, secureRandom);
    }

    protected void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(n2, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException("Eeeek! " + invalidAlgorithmParameterException.toString());
        }
    }

    protected byte[] engineUpdate(byte[] byArray, int n2, int n3) {
        this.bOut.write(byArray, n2, n3);
        if (this.cipher instanceof RSABlindedEngine ? this.bOut.size() > this.cipher.getInputBlockSize() + 1 : this.bOut.size() > this.cipher.getInputBlockSize()) {
            throw new ArrayIndexOutOfBoundsException("too much data for RSA block");
        }
        return null;
    }

    protected int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        this.bOut.write(byArray, n2, n3);
        if (this.cipher instanceof RSABlindedEngine ? this.bOut.size() > this.cipher.getInputBlockSize() + 1 : this.bOut.size() > this.cipher.getInputBlockSize()) {
            throw new ArrayIndexOutOfBoundsException("too much data for RSA block");
        }
        return 0;
    }

    protected byte[] engineDoFinal(byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        if (byArray != null) {
            this.bOut.write(byArray, n2, n3);
        }
        if (this.cipher instanceof RSABlindedEngine ? this.bOut.size() > this.cipher.getInputBlockSize() + 1 : this.bOut.size() > this.cipher.getInputBlockSize()) {
            throw new ArrayIndexOutOfBoundsException("too much data for RSA block");
        }
        try {
            byte[] byArray2 = this.bOut.toByteArray();
            this.bOut.reset();
            return this.cipher.processBlock(byArray2, 0, byArray2.length);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new BadPaddingException(invalidCipherTextException.getMessage());
        }
    }

    protected int engineDoFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray3;
        if (byArray != null) {
            this.bOut.write(byArray, n2, n3);
        }
        if (this.cipher instanceof RSABlindedEngine ? this.bOut.size() > this.cipher.getInputBlockSize() + 1 : this.bOut.size() > this.cipher.getInputBlockSize()) {
            throw new ArrayIndexOutOfBoundsException("too much data for RSA block");
        }
        try {
            byte[] byArray4 = this.bOut.toByteArray();
            this.bOut.reset();
            byArray3 = this.cipher.processBlock(byArray4, 0, byArray4.length);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new BadPaddingException(invalidCipherTextException.getMessage());
        }
        for (int i2 = 0; i2 != byArray3.length; ++i2) {
            byArray2[n4 + i2] = byArray3[i2];
        }
        return byArray3.length;
    }
}

