/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.asymmetric.rsa;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.RSAKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPrivateCrtKey;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    static final BigInteger a = BigInteger.valueOf(65537L);
    RSAKeyGenerationParameters a;
    RSAKeyPairGenerator a;

    public KeyPairGeneratorSpi(String string) {
        super(string);
    }

    public KeyPairGeneratorSpi() {
        super("RSA");
        this.a = new RSAKeyPairGenerator();
        this.a = new RSAKeyGenerationParameters(a, new SecureRandom(), 2048, 12);
        this.a.init(this.a);
    }

    public void initialize(int n2, SecureRandom secureRandom) {
        this.a = new RSAKeyGenerationParameters(a, secureRandom, n2, 12);
        this.a.init(this.a);
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof RSAKeyGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a RSAKeyGenParameterSpec");
        }
        RSAKeyGenParameterSpec rSAKeyGenParameterSpec = (RSAKeyGenParameterSpec)algorithmParameterSpec;
        this.a = new RSAKeyGenerationParameters(rSAKeyGenParameterSpec.getPublicExponent(), secureRandom, rSAKeyGenParameterSpec.getKeysize(), 12);
        this.a.init(this.a);
    }

    public KeyPair generateKeyPair() {
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.a.generateKeyPair();
        RSAKeyParameters rSAKeyParameters = (RSAKeyParameters)asymmetricCipherKeyPair.getPublic();
        RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = (RSAPrivateCrtKeyParameters)asymmetricCipherKeyPair.getPrivate();
        return new KeyPair(new BCRSAPublicKey(rSAKeyParameters), new BCRSAPrivateCrtKey(rSAPrivateCrtKeyParameters));
    }
}

