/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.digest;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.CipherParameters;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.symmetric.util.BaseSecretKeyFactory;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.symmetric.util.PBE$Util;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;

public class SHA1$BasePBKDF2WithHmacSHA1
extends BaseSecretKeyFactory {
    private int scheme;

    public SHA1$BasePBKDF2WithHmacSHA1(String string, int n2) {
        super(string, PKCSObjectIdentifiers.id_PBKDF2);
        this.scheme = n2;
    }

    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof PBEKeySpec) {
            PBEKeySpec pBEKeySpec = (PBEKeySpec)keySpec;
            if (pBEKeySpec.getSalt() == null) {
                throw new InvalidKeySpecException("missing required salt");
            }
            if (pBEKeySpec.getIterationCount() <= 0) {
                throw new InvalidKeySpecException("positive iteration count required: " + pBEKeySpec.getIterationCount());
            }
            if (pBEKeySpec.getKeyLength() <= 0) {
                throw new InvalidKeySpecException("positive key length required: " + pBEKeySpec.getKeyLength());
            }
            if (pBEKeySpec.getPassword().length == 0) {
                throw new IllegalArgumentException("password empty");
            }
            int n2 = 1;
            int n3 = pBEKeySpec.getKeyLength();
            int n4 = -1;
            CipherParameters cipherParameters = PBE$Util.makePBEMacParameters(pBEKeySpec, this.scheme, n2, n3);
            return new BCPBEKey(this.algName, this.algOid, this.scheme, n2, n3, n4, pBEKeySpec, cipherParameters);
        }
        throw new InvalidKeySpecException("Invalid KeySpec");
    }
}

