/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.keystore.bc;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.digests.SHA1Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.io.DigestInputStream;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.io.DigestOutputStream;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.keystore.bc.BcKeyStoreSpi;
import com.zeroturnaround.bundled.org.bouncycastle.util.Arrays;
import com.zeroturnaround.bundled.org.bouncycastle.util.io.Streams;
import com.zeroturnaround.bundled.org.bouncycastle.util.io.TeeOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;

public class BcKeyStoreSpi$BouncyCastleStore
extends BcKeyStoreSpi {
    public BcKeyStoreSpi$BouncyCastleStore() {
        super(1);
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException {
        this.table.clear();
        if (inputStream == null) {
            return;
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n2 = dataInputStream.readInt();
        if (n2 != 2 && n2 != 0 && n2 != 1) {
            throw new IOException("Wrong version of key store.");
        }
        byte[] byArray = new byte[dataInputStream.readInt()];
        if (byArray.length != 20) {
            throw new IOException("Key store corrupted.");
        }
        dataInputStream.readFully(byArray);
        int n3 = dataInputStream.readInt();
        if (n3 < 0 || n3 > 4096) {
            throw new IOException("Key store corrupted.");
        }
        String string = n2 == 0 ? "OldPBEWithSHAAndTwofish-CBC" : "PBEWithSHAAndTwofish-CBC";
        Cipher cipher = this.makePBECipher(string, 2, cArray, byArray, n3);
        CipherInputStream cipherInputStream = new CipherInputStream(dataInputStream, cipher);
        SHA1Digest sHA1Digest = new SHA1Digest();
        DigestInputStream digestInputStream = new DigestInputStream(cipherInputStream, sHA1Digest);
        this.loadStore(digestInputStream);
        byte[] byArray2 = new byte[sHA1Digest.getDigestSize()];
        sHA1Digest.doFinal(byArray2, 0);
        byte[] byArray3 = new byte[sHA1Digest.getDigestSize()];
        Streams.readFully(cipherInputStream, byArray3);
        if (!Arrays.constantTimeAreEqual(byArray2, byArray3)) {
            this.table.clear();
            throw new IOException("KeyStore integrity check failed.");
        }
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        byte[] byArray = new byte[20];
        int n2 = 1024 + (this.random.nextInt() & 0x3FF);
        this.random.nextBytes(byArray);
        dataOutputStream.writeInt(this.version);
        dataOutputStream.writeInt(byArray.length);
        dataOutputStream.write(byArray);
        dataOutputStream.writeInt(n2);
        Cipher cipher = this.makePBECipher("PBEWithSHAAndTwofish-CBC", 1, cArray, byArray, n2);
        CipherOutputStream cipherOutputStream = new CipherOutputStream(dataOutputStream, cipher);
        DigestOutputStream digestOutputStream = new DigestOutputStream(new SHA1Digest());
        this.saveStore(new TeeOutputStream(cipherOutputStream, digestOutputStream));
        byte[] byArray2 = digestOutputStream.getDigest();
        cipherOutputStream.write(byArray2);
        cipherOutputStream.close();
    }
}

