/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.symmetric;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1InputStream;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.misc.CAST5CBCParameters;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.symmetric.CAST5;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameters;
import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;

public class CAST5$AlgParams
extends BaseAlgorithmParameters {
    private byte[] iv;
    private int keyLength = 128;

    protected byte[] engineGetEncoded() {
        byte[] byArray = new byte[this.iv.length];
        System.arraycopy(this.iv, 0, byArray, 0, this.iv.length);
        return byArray;
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        if (this.isASN1FormatString(string)) {
            return new CAST5CBCParameters(this.engineGetEncoded(), this.keyLength).getEncoded();
        }
        if (string.equals("RAW")) {
            return this.engineGetEncoded();
        }
        return null;
    }

    protected AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (clazz == (CAST5.a == null ? (CAST5.a = CAST5.a("javax.crypto.spec.IvParameterSpec")) : CAST5.a)) {
            return new IvParameterSpec(this.iv);
        }
        throw new InvalidParameterSpecException("unknown parameter spec passed to CAST5 parameters object.");
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof IvParameterSpec)) {
            throw new InvalidParameterSpecException("IvParameterSpec required to initialise a CAST5 parameters algorithm parameters object");
        }
        this.iv = ((IvParameterSpec)algorithmParameterSpec).getIV();
    }

    protected void engineInit(byte[] byArray) throws IOException {
        this.iv = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.iv, 0, this.iv.length);
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        if (this.isASN1FormatString(string)) {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
            CAST5CBCParameters cAST5CBCParameters = CAST5CBCParameters.getInstance(aSN1InputStream.readObject());
            this.keyLength = cAST5CBCParameters.getKeyLength();
            this.iv = cAST5CBCParameters.getIV();
            return;
        }
        if (string.equals("RAW")) {
            this.engineInit(byArray);
            return;
        }
        throw new IOException("Unknown parameters format in IV parameters object");
    }

    protected String engineToString() {
        return "CAST5 Parameters";
    }
}

