/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.jce.provider;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Encodable;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERInteger;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.pkcs.DHParameter;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.asymmetric.util.PKCS12BagAttributeCarrierImpl;
import com.zeroturnaround.bundled.org.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.util.Enumeration;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;

public class JCEDHPrivateKey
implements PKCS12BagAttributeCarrier,
DHPrivateKey {
    static final long serialVersionUID = 311058815616901812L;
    BigInteger a;
    private DHParameterSpec dhSpec;
    private PrivateKeyInfo info;
    private PKCS12BagAttributeCarrier attrCarrier = new PKCS12BagAttributeCarrierImpl();

    protected JCEDHPrivateKey() {
    }

    public String getAlgorithm() {
        return "DH";
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        try {
            if (this.info != null) {
                return this.info.getEncoded("DER");
            }
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.dhKeyAgreement, (ASN1Encodable)new DHParameter(this.dhSpec.getP(), this.dhSpec.getG(), this.dhSpec.getL())), new DERInteger(this.getX()));
            return privateKeyInfo.getEncoded("DER");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public DHParameterSpec getParams() {
        return this.dhSpec;
    }

    public BigInteger getX() {
        return this.a;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.a = (BigInteger)objectInputStream.readObject();
        this.dhSpec = new DHParameterSpec((BigInteger)objectInputStream.readObject(), (BigInteger)objectInputStream.readObject(), objectInputStream.readInt());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.getX());
        objectOutputStream.writeObject(this.dhSpec.getP());
        objectOutputStream.writeObject(this.dhSpec.getG());
        objectOutputStream.writeInt(this.dhSpec.getL());
    }

    public void setBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.attrCarrier.setBagAttribute(aSN1ObjectIdentifier, aSN1Encodable);
    }

    public ASN1Encodable getBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return this.attrCarrier.getBagAttribute(aSN1ObjectIdentifier);
    }

    public Enumeration getBagAttributeKeys() {
        return this.attrCarrier.getBagAttributeKeys();
    }
}

