/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.jce.provider;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Encodable;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Null;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERNull;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERObjectIdentifier;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;

class X509SignatureUtil {
    private static final ASN1Null derNull = new DERNull();

    X509SignatureUtil() {
    }

    static void a(Signature signature, ASN1Encodable aSN1Encodable) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        if (aSN1Encodable == null || !derNull.equals(aSN1Encodable)) {
            // empty if block
        }
    }

    static String a(AlgorithmIdentifier algorithmIdentifier) {
        ASN1Encodable aSN1Encodable = algorithmIdentifier.getParameters();
        if (aSN1Encodable != null && !derNull.equals(aSN1Encodable) && algorithmIdentifier.getObjectId().equals(PKCSObjectIdentifiers.id_RSASSA_PSS)) {
            RSASSAPSSparams rSASSAPSSparams = RSASSAPSSparams.getInstance(aSN1Encodable);
            return X509SignatureUtil.getDigestAlgName(rSASSAPSSparams.getHashAlgorithm().getObjectId()) + "withRSAandMGF1";
        }
        return algorithmIdentifier.getObjectId().getId();
    }

    private static String getDigestAlgName(DERObjectIdentifier dERObjectIdentifier) {
        if (PKCSObjectIdentifiers.md5.equals(dERObjectIdentifier)) {
            return "MD5";
        }
        if (OIWObjectIdentifiers.idSHA1.equals(dERObjectIdentifier)) {
            return "SHA1";
        }
        if (NISTObjectIdentifiers.id_sha224.equals(dERObjectIdentifier)) {
            return "SHA224";
        }
        if (NISTObjectIdentifiers.id_sha256.equals(dERObjectIdentifier)) {
            return "SHA256";
        }
        if (NISTObjectIdentifiers.id_sha384.equals(dERObjectIdentifier)) {
            return "SHA384";
        }
        if (NISTObjectIdentifiers.id_sha512.equals(dERObjectIdentifier)) {
            return "SHA512";
        }
        if (TeleTrusTObjectIdentifiers.ripemd128.equals(dERObjectIdentifier)) {
            return "RIPEMD128";
        }
        if (TeleTrusTObjectIdentifiers.ripemd160.equals(dERObjectIdentifier)) {
            return "RIPEMD160";
        }
        if (TeleTrusTObjectIdentifiers.ripemd256.equals(dERObjectIdentifier)) {
            return "RIPEMD256";
        }
        if (CryptoProObjectIdentifiers.gostR3411.equals(dERObjectIdentifier)) {
            return "GOST3411";
        }
        return dERObjectIdentifier.getId();
    }
}

