/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.math.ec;

import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECCurve;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECCurve$F2m;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;

public class ECAlgorithms {
    public static ECPoint sumOfTwoMultiplies(ECPoint eCPoint, BigInteger bigInteger, ECPoint eCPoint2, BigInteger bigInteger2) {
        ECCurve$F2m eCCurve$F2m;
        ECCurve eCCurve = eCPoint.getCurve();
        if (!eCCurve.equals(eCPoint2.getCurve())) {
            throw new IllegalArgumentException("P and Q must be on same curve");
        }
        if (eCCurve instanceof ECCurve$F2m && (eCCurve$F2m = (ECCurve$F2m)eCCurve).isKoblitz()) {
            return eCPoint.multiply(bigInteger).add(eCPoint2.multiply(bigInteger2));
        }
        return ECAlgorithms.implShamirsTrick(eCPoint, bigInteger, eCPoint2, bigInteger2);
    }

    public static ECPoint shamirsTrick(ECPoint eCPoint, BigInteger bigInteger, ECPoint eCPoint2, BigInteger bigInteger2) {
        if (!eCPoint.getCurve().equals(eCPoint2.getCurve())) {
            throw new IllegalArgumentException("P and Q must be on same curve");
        }
        return ECAlgorithms.implShamirsTrick(eCPoint, bigInteger, eCPoint2, bigInteger2);
    }

    private static ECPoint implShamirsTrick(ECPoint eCPoint, BigInteger bigInteger, ECPoint eCPoint2, BigInteger bigInteger2) {
        int n2 = Math.max(bigInteger.bitLength(), bigInteger2.bitLength());
        ECPoint eCPoint3 = eCPoint.add(eCPoint2);
        ECPoint eCPoint4 = eCPoint.getCurve().getInfinity();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            eCPoint4 = eCPoint4.twice();
            if (bigInteger.testBit(i2)) {
                if (bigInteger2.testBit(i2)) {
                    eCPoint4 = eCPoint4.add(eCPoint3);
                    continue;
                }
                eCPoint4 = eCPoint4.add(eCPoint);
                continue;
            }
            if (!bigInteger2.testBit(i2)) continue;
            eCPoint4 = eCPoint4.add(eCPoint2);
        }
        return eCPoint4;
    }
}

