/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.math.ec;

import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECFieldElement;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;

public abstract class ECCurve {
    ECFieldElement a;
    ECFieldElement b;

    public abstract int getFieldSize();

    public abstract ECFieldElement fromBigInteger(BigInteger var1);

    public abstract ECPoint createPoint(BigInteger var1, BigInteger var2, boolean var3);

    public abstract ECPoint getInfinity();

    public ECFieldElement getA() {
        return this.a;
    }

    public ECFieldElement getB() {
        return this.b;
    }

    protected abstract ECPoint decompressPoint(int var1, BigInteger var2);

    public ECPoint decodePoint(byte[] byArray) {
        ECPoint eCPoint = null;
        int n2 = (this.getFieldSize() + 7) / 8;
        switch (byArray[0]) {
            case 0: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("Incorrect length for infinity encoding");
                }
                eCPoint = this.getInfinity();
                break;
            }
            case 2: 
            case 3: {
                if (byArray.length != n2 + 1) {
                    throw new IllegalArgumentException("Incorrect length for compressed encoding");
                }
                int n3 = byArray[0] & 1;
                BigInteger bigInteger = ECCurve.fromArray(byArray, 1, n2);
                eCPoint = this.decompressPoint(n3, bigInteger);
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                if (byArray.length != 2 * n2 + 1) {
                    throw new IllegalArgumentException("Incorrect length for uncompressed/hybrid encoding");
                }
                BigInteger bigInteger = ECCurve.fromArray(byArray, 1, n2);
                BigInteger bigInteger2 = ECCurve.fromArray(byArray, 1 + n2, n2);
                eCPoint = this.createPoint(bigInteger, bigInteger2, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid point encoding 0x" + Integer.toString(byArray[0], 16));
            }
        }
        return eCPoint;
    }

    private static BigInteger fromArray(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return new BigInteger(1, byArray2);
    }
}

