/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.math.ec;

import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECConstants;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECFieldElement;
import java.math.BigInteger;
import java.util.Random;

public class ECFieldElement$Fp
extends ECFieldElement {
    BigInteger a;
    BigInteger b;

    public ECFieldElement$Fp(BigInteger bigInteger, BigInteger bigInteger2) {
        this.a = bigInteger2;
        if (bigInteger2.compareTo(bigInteger) >= 0) {
            throw new IllegalArgumentException("x value too large in field element");
        }
        this.b = bigInteger;
    }

    public BigInteger toBigInteger() {
        return this.a;
    }

    public String getFieldName() {
        return "Fp";
    }

    public int getFieldSize() {
        return this.b.bitLength();
    }

    public BigInteger getQ() {
        return this.b;
    }

    public ECFieldElement add(ECFieldElement eCFieldElement) {
        return new ECFieldElement$Fp(this.b, this.a.add(eCFieldElement.toBigInteger()).mod(this.b));
    }

    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        return new ECFieldElement$Fp(this.b, this.a.subtract(eCFieldElement.toBigInteger()).mod(this.b));
    }

    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        return new ECFieldElement$Fp(this.b, this.a.multiply(eCFieldElement.toBigInteger()).mod(this.b));
    }

    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        return new ECFieldElement$Fp(this.b, this.a.multiply(eCFieldElement.toBigInteger().modInverse(this.b)).mod(this.b));
    }

    public ECFieldElement negate() {
        return new ECFieldElement$Fp(this.b, this.a.negate().mod(this.b));
    }

    public ECFieldElement square() {
        return new ECFieldElement$Fp(this.b, this.a.multiply(this.a).mod(this.b));
    }

    public ECFieldElement invert() {
        return new ECFieldElement$Fp(this.b, this.a.modInverse(this.b));
    }

    public ECFieldElement sqrt() {
        if (!this.b.testBit(0)) {
            throw new RuntimeException("not done yet");
        }
        if (this.b.testBit(1)) {
            ECFieldElement$Fp eCFieldElement$Fp = new ECFieldElement$Fp(this.b, this.a.modPow(this.b.shiftRight(2).add(ECConstants.ONE), this.b));
            return ((ECFieldElement)eCFieldElement$Fp).square().equals(this) ? eCFieldElement$Fp : null;
        }
        BigInteger bigInteger = this.b.subtract(ECConstants.ONE);
        BigInteger bigInteger2 = bigInteger.shiftRight(1);
        if (!this.a.modPow(bigInteger2, this.b).equals(ECConstants.ONE)) {
            return null;
        }
        BigInteger bigInteger3 = bigInteger.shiftRight(2);
        BigInteger bigInteger4 = bigInteger3.shiftLeft(1).add(ECConstants.ONE);
        BigInteger bigInteger5 = this.a;
        BigInteger bigInteger6 = bigInteger5.shiftLeft(2).mod(this.b);
        Random random = new Random();
        while (true) {
            BigInteger bigInteger7;
            if ((bigInteger7 = new BigInteger(this.b.bitLength(), random)).compareTo(this.b) >= 0 || !bigInteger7.multiply(bigInteger7).subtract(bigInteger6).modPow(bigInteger2, this.b).equals(bigInteger)) {
                continue;
            }
            BigInteger[] bigIntegerArray = ECFieldElement$Fp.lucasSequence(this.b, bigInteger7, bigInteger5, bigInteger4);
            BigInteger bigInteger8 = bigIntegerArray[0];
            BigInteger bigInteger9 = bigIntegerArray[1];
            if (bigInteger9.multiply(bigInteger9).mod(this.b).equals(bigInteger6)) {
                if (bigInteger9.testBit(0)) {
                    bigInteger9 = bigInteger9.add(this.b);
                }
                bigInteger9 = bigInteger9.shiftRight(1);
                return new ECFieldElement$Fp(this.b, bigInteger9);
            }
            if (!bigInteger8.equals(ECConstants.ONE) && !bigInteger8.equals(bigInteger)) break;
        }
        return null;
    }

    private static BigInteger[] lucasSequence(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        int n2;
        int n3 = bigInteger4.bitLength();
        int n4 = bigInteger4.getLowestSetBit();
        BigInteger bigInteger5 = ECConstants.ONE;
        BigInteger bigInteger6 = ECConstants.TWO;
        BigInteger bigInteger7 = bigInteger2;
        BigInteger bigInteger8 = ECConstants.ONE;
        BigInteger bigInteger9 = ECConstants.ONE;
        for (n2 = n3 - 1; n2 >= n4 + 1; --n2) {
            bigInteger8 = bigInteger8.multiply(bigInteger9).mod(bigInteger);
            if (bigInteger4.testBit(n2)) {
                bigInteger9 = bigInteger8.multiply(bigInteger3).mod(bigInteger);
                bigInteger5 = bigInteger5.multiply(bigInteger7).mod(bigInteger);
                bigInteger6 = bigInteger7.multiply(bigInteger6).subtract(bigInteger2.multiply(bigInteger8)).mod(bigInteger);
                bigInteger7 = bigInteger7.multiply(bigInteger7).subtract(bigInteger9.shiftLeft(1)).mod(bigInteger);
                continue;
            }
            bigInteger9 = bigInteger8;
            bigInteger5 = bigInteger5.multiply(bigInteger6).subtract(bigInteger8).mod(bigInteger);
            bigInteger7 = bigInteger7.multiply(bigInteger6).subtract(bigInteger2.multiply(bigInteger8)).mod(bigInteger);
            bigInteger6 = bigInteger6.multiply(bigInteger6).subtract(bigInteger8.shiftLeft(1)).mod(bigInteger);
        }
        bigInteger8 = bigInteger8.multiply(bigInteger9).mod(bigInteger);
        bigInteger9 = bigInteger8.multiply(bigInteger3).mod(bigInteger);
        bigInteger5 = bigInteger5.multiply(bigInteger6).subtract(bigInteger8).mod(bigInteger);
        bigInteger6 = bigInteger7.multiply(bigInteger6).subtract(bigInteger2.multiply(bigInteger8)).mod(bigInteger);
        bigInteger8 = bigInteger8.multiply(bigInteger9).mod(bigInteger);
        for (n2 = 1; n2 <= n4; ++n2) {
            bigInteger5 = bigInteger5.multiply(bigInteger6).mod(bigInteger);
            bigInteger6 = bigInteger6.multiply(bigInteger6).subtract(bigInteger8.shiftLeft(1)).mod(bigInteger);
            bigInteger8 = bigInteger8.multiply(bigInteger8).mod(bigInteger);
        }
        return new BigInteger[]{bigInteger5, bigInteger6};
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ECFieldElement$Fp)) {
            return false;
        }
        ECFieldElement$Fp eCFieldElement$Fp = (ECFieldElement$Fp)object;
        return this.b.equals(eCFieldElement$Fp.b) && this.a.equals(eCFieldElement$Fp.a);
    }

    public int hashCode() {
        return this.b.hashCode() ^ this.a.hashCode();
    }
}

