/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.math.ec;

import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECCurve$F2m;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECMultiplier;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECPoint;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECPoint$F2m;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.PreCompInfo;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.Tnaf;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.WTauNafPreCompInfo;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ZTauElement;
import java.math.BigInteger;

class WTauNafMultiplier
implements ECMultiplier {
    WTauNafMultiplier() {
    }

    public ECPoint multiply(ECPoint eCPoint, BigInteger bigInteger, PreCompInfo preCompInfo) {
        if (!(eCPoint instanceof ECPoint$F2m)) {
            throw new IllegalArgumentException("Only ECPoint.F2m can be used in WTauNafMultiplier");
        }
        ECPoint$F2m eCPoint$F2m = (ECPoint$F2m)eCPoint;
        ECCurve$F2m eCCurve$F2m = (ECCurve$F2m)eCPoint$F2m.getCurve();
        int n2 = eCCurve$F2m.getM();
        byte by2 = eCCurve$F2m.getA().toBigInteger().byteValue();
        byte by3 = eCCurve$F2m.a();
        BigInteger[] bigIntegerArray = eCCurve$F2m.a();
        ZTauElement zTauElement = Tnaf.partModReduction(bigInteger, n2, by2, bigIntegerArray, by3, (byte)10);
        return this.multiplyWTnaf(eCPoint$F2m, zTauElement, preCompInfo, by2, by3);
    }

    private ECPoint$F2m multiplyWTnaf(ECPoint$F2m eCPoint$F2m, ZTauElement zTauElement, PreCompInfo preCompInfo, byte by2, byte by3) {
        ZTauElement[] zTauElementArray = by2 == 0 ? Tnaf.alpha0 : Tnaf.alpha1;
        BigInteger bigInteger = Tnaf.getTw(by3, 4);
        byte[] byArray = Tnaf.tauAdicWNaf(by3, zTauElement, (byte)4, BigInteger.valueOf(16L), bigInteger, zTauElementArray);
        return WTauNafMultiplier.multiplyFromWTnaf(eCPoint$F2m, byArray, preCompInfo);
    }

    private static ECPoint$F2m multiplyFromWTnaf(ECPoint$F2m eCPoint$F2m, byte[] byArray, PreCompInfo preCompInfo) {
        ECPoint$F2m[] eCPoint$F2mArray;
        ECCurve$F2m eCCurve$F2m = (ECCurve$F2m)eCPoint$F2m.getCurve();
        byte by2 = eCCurve$F2m.getA().toBigInteger().byteValue();
        if (preCompInfo == null || !(preCompInfo instanceof WTauNafPreCompInfo)) {
            eCPoint$F2mArray = Tnaf.getPreComp(eCPoint$F2m, by2);
            eCPoint$F2m.a(new WTauNafPreCompInfo(eCPoint$F2mArray));
        } else {
            eCPoint$F2mArray = ((WTauNafPreCompInfo)preCompInfo).getPreComp();
        }
        ECPoint$F2m eCPoint$F2m2 = (ECPoint$F2m)eCPoint$F2m.getCurve().getInfinity();
        for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
            eCPoint$F2m2 = Tnaf.tau(eCPoint$F2m2);
            if (byArray[i2] == 0) continue;
            eCPoint$F2m2 = byArray[i2] > 0 ? eCPoint$F2m2.addSimple(eCPoint$F2mArray[byArray[i2]]) : eCPoint$F2m2.subtractSimple(eCPoint$F2mArray[-byArray[i2]]);
        }
        return eCPoint$F2m2;
    }
}

