/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.ocsp;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.DEROctetString;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ocsp.OCSPResponse;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ocsp.OCSPResponseStatus;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ocsp.ResponseBytes;
import com.zeroturnaround.bundled.org.bouncycastle.ocsp.BasicOCSPResp;
import com.zeroturnaround.bundled.org.bouncycastle.ocsp.OCSPException;
import com.zeroturnaround.bundled.org.bouncycastle.ocsp.OCSPResp;
import java.io.IOException;

public class OCSPRespGenerator {
    public static final int SUCCESSFUL = 0;
    public static final int MALFORMED_REQUEST = 1;
    public static final int INTERNAL_ERROR = 2;
    public static final int TRY_LATER = 3;
    public static final int SIG_REQUIRED = 5;
    public static final int UNAUTHORIZED = 6;

    public OCSPResp generate(int n2, Object object) throws OCSPException {
        if (object == null) {
            return new OCSPResp(new OCSPResponse(new OCSPResponseStatus(n2), null));
        }
        if (object instanceof BasicOCSPResp) {
            DEROctetString dEROctetString;
            BasicOCSPResp basicOCSPResp = (BasicOCSPResp)object;
            try {
                dEROctetString = new DEROctetString(basicOCSPResp.getEncoded());
            }
            catch (IOException iOException) {
                throw new OCSPException("can't encode object.", iOException);
            }
            ResponseBytes responseBytes = new ResponseBytes(OCSPObjectIdentifiers.id_pkix_ocsp_basic, dEROctetString);
            return new OCSPResp(new OCSPResponse(new OCSPResponseStatus(n2), responseBytes));
        }
        throw new OCSPException("unknown response object");
    }
}

