/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.pqc.asn1;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1EncodableVector;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Integer;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Object;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1OctetString;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Primitive;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Sequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DEROctetString;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERSequence;
import com.zeroturnaround.bundled.org.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import com.zeroturnaround.bundled.org.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.zeroturnaround.bundled.org.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.zeroturnaround.bundled.org.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import java.math.BigInteger;

public class McEliecePrivateKey
extends ASN1Object {
    private ASN1ObjectIdentifier oid;
    private int n;
    private int k;
    private byte[] encField;
    private byte[] encGp;
    private byte[] encSInv;
    private byte[] encP1;
    private byte[] encP2;
    private byte[] encH;
    private byte[][] encqInv;

    public McEliecePrivateKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, int n2, int n3, GF2mField gF2mField, PolynomialGF2mSmallM polynomialGF2mSmallM, GF2Matrix gF2Matrix, Permutation permutation, Permutation permutation2, GF2Matrix gF2Matrix2, PolynomialGF2mSmallM[] polynomialGF2mSmallMArray) {
        this.oid = aSN1ObjectIdentifier;
        this.n = n2;
        this.k = n3;
        this.encField = gF2mField.getEncoded();
        this.encGp = polynomialGF2mSmallM.getEncoded();
        this.encSInv = gF2Matrix.getEncoded();
        this.encP1 = permutation.getEncoded();
        this.encP2 = permutation2.getEncoded();
        this.encH = gF2Matrix2.getEncoded();
        this.encqInv = new byte[polynomialGF2mSmallMArray.length][];
        for (int i2 = 0; i2 != polynomialGF2mSmallMArray.length; ++i2) {
            this.encqInv[i2] = polynomialGF2mSmallMArray[i2].getEncoded();
        }
    }

    public static McEliecePrivateKey getInstance(Object object) {
        if (object instanceof McEliecePrivateKey) {
            return (McEliecePrivateKey)object;
        }
        if (object != null) {
            return new McEliecePrivateKey(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private McEliecePrivateKey(ASN1Sequence aSN1Sequence) {
        this.oid = (ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(0);
        BigInteger bigInteger = ((ASN1Integer)aSN1Sequence.getObjectAt(1)).getValue();
        this.n = bigInteger.intValue();
        BigInteger bigInteger2 = ((ASN1Integer)aSN1Sequence.getObjectAt(2)).getValue();
        this.k = bigInteger2.intValue();
        this.encField = ((ASN1OctetString)aSN1Sequence.getObjectAt(3)).getOctets();
        this.encGp = ((ASN1OctetString)aSN1Sequence.getObjectAt(4)).getOctets();
        this.encSInv = ((ASN1OctetString)aSN1Sequence.getObjectAt(5)).getOctets();
        this.encP1 = ((ASN1OctetString)aSN1Sequence.getObjectAt(6)).getOctets();
        this.encP2 = ((ASN1OctetString)aSN1Sequence.getObjectAt(7)).getOctets();
        this.encH = ((ASN1OctetString)aSN1Sequence.getObjectAt(8)).getOctets();
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.getObjectAt(9);
        this.encqInv = new byte[aSN1Sequence2.size()][];
        for (int i2 = 0; i2 < aSN1Sequence2.size(); ++i2) {
            this.encqInv[i2] = ((ASN1OctetString)aSN1Sequence2.getObjectAt(i2)).getOctets();
        }
    }

    public ASN1ObjectIdentifier getOID() {
        return this.oid;
    }

    public int getN() {
        return this.n;
    }

    public int getK() {
        return this.k;
    }

    public GF2mField getField() {
        return new GF2mField(this.encField);
    }

    public PolynomialGF2mSmallM getGoppaPoly() {
        return new PolynomialGF2mSmallM(this.getField(), this.encGp);
    }

    public GF2Matrix getSInv() {
        return new GF2Matrix(this.encSInv);
    }

    public Permutation getP1() {
        return new Permutation(this.encP1);
    }

    public Permutation getP2() {
        return new Permutation(this.encP2);
    }

    public GF2Matrix getH() {
        return new GF2Matrix(this.encH);
    }

    public PolynomialGF2mSmallM[] getQInv() {
        PolynomialGF2mSmallM[] polynomialGF2mSmallMArray = new PolynomialGF2mSmallM[this.encqInv.length];
        GF2mField gF2mField = this.getField();
        for (int i2 = 0; i2 < this.encqInv.length; ++i2) {
            polynomialGF2mSmallMArray[i2] = new PolynomialGF2mSmallM(gF2mField, this.encqInv[i2]);
        }
        return polynomialGF2mSmallMArray;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.oid);
        aSN1EncodableVector.add(new ASN1Integer(this.n));
        aSN1EncodableVector.add(new ASN1Integer(this.k));
        aSN1EncodableVector.add(new DEROctetString(this.encField));
        aSN1EncodableVector.add(new DEROctetString(this.encGp));
        aSN1EncodableVector.add(new DEROctetString(this.encSInv));
        aSN1EncodableVector.add(new DEROctetString(this.encP1));
        aSN1EncodableVector.add(new DEROctetString(this.encP2));
        aSN1EncodableVector.add(new DEROctetString(this.encH));
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        for (int i2 = 0; i2 < this.encqInv.length; ++i2) {
            aSN1EncodableVector2.add(new DEROctetString(this.encqInv[i2]));
        }
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        return new DERSequence(aSN1EncodableVector);
    }
}

