/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.pqc.jcajce.spec;

import com.zeroturnaround.bundled.org.bouncycastle.util.Arrays;
import java.security.spec.AlgorithmParameterSpec;

public class RainbowParameterSpec
implements AlgorithmParameterSpec {
    private static final int[] DEFAULT_VI = new int[]{6, 12, 17, 22, 33};
    private int[] vi;

    public RainbowParameterSpec() {
        this.vi = DEFAULT_VI;
    }

    public RainbowParameterSpec(int[] nArray) {
        this.vi = nArray;
        try {
            this.checkParams();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void checkParams() throws Exception {
        if (this.vi == null) {
            throw new IllegalArgumentException("no layers defined.");
        }
        if (this.vi.length > 1) {
            for (int i2 = 0; i2 < this.vi.length - 1; ++i2) {
                if (this.vi[i2] < this.vi[i2 + 1]) continue;
                throw new IllegalArgumentException("v[i] has to be smaller than v[i+1]");
            }
        } else {
            throw new IllegalArgumentException("Rainbow needs at least 1 layer, such that v1 < v2.");
        }
    }

    public int getNumOfLayers() {
        return this.vi.length - 1;
    }

    public int getDocumentLength() {
        return this.vi[this.vi.length - 1] - this.vi[0];
    }

    public int[] getVi() {
        return Arrays.clone(this.vi);
    }
}

