/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.x509;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Encodable;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1InputStream;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1OctetString;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Primitive;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Sequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1TaggedObject;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DEREnumerated;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERIA5String;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERInteger;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERObjectIdentifier;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DEROctetString;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.AccessDescription;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.BasicConstraints;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.CRLDistPoint;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.DistributionPoint;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.DistributionPointName;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.GeneralName;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.GeneralNames;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.GeneralSubtree;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.NameConstraints;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.PolicyInformation;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.X509Extensions;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.qualified.Iso4217CurrencyCode;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.qualified.MonetaryValue;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.qualified.QCStatement;
import com.zeroturnaround.bundled.org.bouncycastle.i18n.ErrorBundle;
import com.zeroturnaround.bundled.org.bouncycastle.i18n.LocaleString;
import com.zeroturnaround.bundled.org.bouncycastle.i18n.LocalizedMessage;
import com.zeroturnaround.bundled.org.bouncycastle.i18n.filter.TrustedInput;
import com.zeroturnaround.bundled.org.bouncycastle.i18n.filter.UntrustedInput;
import com.zeroturnaround.bundled.org.bouncycastle.i18n.filter.UntrustedUrlInput;
import com.zeroturnaround.bundled.org.bouncycastle.jce.provider.AnnotatedException;
import com.zeroturnaround.bundled.org.bouncycastle.jce.provider.CertPathValidatorUtilities;
import com.zeroturnaround.bundled.org.bouncycastle.jce.provider.PKIXNameConstraintValidator;
import com.zeroturnaround.bundled.org.bouncycastle.jce.provider.PKIXNameConstraintValidatorException;
import com.zeroturnaround.bundled.org.bouncycastle.jce.provider.PKIXPolicyNode;
import com.zeroturnaround.bundled.org.bouncycastle.util.Integers;
import com.zeroturnaround.bundled.org.bouncycastle.x509.CertPathReviewerException;
import com.zeroturnaround.bundled.org.bouncycastle.x509.X509CRLStoreSelector;
import com.zeroturnaround.bundled.org.bouncycastle.x509.extension.X509ExtensionUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;

public class PKIXCertPathReviewer
extends CertPathValidatorUtilities {
    private static final String QC_STATEMENT = X509Extensions.QCStatements.getId();
    private static final String CRL_DIST_POINTS = X509Extensions.CRLDistributionPoints.getId();
    private static final String AUTH_INFO_ACCESS = X509Extensions.AuthorityInfoAccess.getId();
    private static final String RESOURCE_NAME = "com.zeroturnaround.bundled.org.bouncycastle.x509.CertPathReviewerMessages";
    protected CertPath certPath;
    protected PKIXParameters pkixParams;
    protected Date validDate;
    protected List certs;
    protected int n;
    protected List[] notifications;
    protected List[] errors;
    protected TrustAnchor trustAnchor;
    protected PublicKey subjectPublicKey;
    protected PolicyNode policyTree;
    private boolean initialized;

    public void init(CertPath certPath, PKIXParameters pKIXParameters) throws CertPathReviewerException {
        if (this.initialized) {
            throw new IllegalStateException("object is already initialized!");
        }
        this.initialized = true;
        if (certPath == null) {
            throw new NullPointerException("certPath was null");
        }
        this.certPath = certPath;
        this.certs = certPath.getCertificates();
        this.n = this.certs.size();
        if (this.certs.isEmpty()) {
            throw new CertPathReviewerException(new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.emptyCertPath"));
        }
        this.pkixParams = (PKIXParameters)pKIXParameters.clone();
        this.validDate = PKIXCertPathReviewer.getValidDate(this.pkixParams);
        this.notifications = null;
        this.errors = null;
        this.trustAnchor = null;
        this.subjectPublicKey = null;
        this.policyTree = null;
    }

    public PKIXCertPathReviewer(CertPath certPath, PKIXParameters pKIXParameters) throws CertPathReviewerException {
        this.init(certPath, pKIXParameters);
    }

    public PKIXCertPathReviewer() {
    }

    public CertPath getCertPath() {
        return this.certPath;
    }

    public int getCertPathSize() {
        return this.n;
    }

    public List[] getErrors() {
        this.doChecks();
        return this.errors;
    }

    public List getErrors(int n2) {
        this.doChecks();
        return this.errors[n2 + 1];
    }

    public List[] getNotifications() {
        this.doChecks();
        return this.notifications;
    }

    public List getNotifications(int n2) {
        this.doChecks();
        return this.notifications[n2 + 1];
    }

    public PolicyNode getPolicyTree() {
        this.doChecks();
        return this.policyTree;
    }

    public PublicKey getSubjectPublicKey() {
        this.doChecks();
        return this.subjectPublicKey;
    }

    public TrustAnchor getTrustAnchor() {
        this.doChecks();
        return this.trustAnchor;
    }

    public boolean isValidCertPath() {
        this.doChecks();
        boolean bl2 = true;
        for (int i2 = 0; i2 < this.errors.length; ++i2) {
            if (this.errors[i2].isEmpty()) continue;
            bl2 = false;
            break;
        }
        return bl2;
    }

    protected void addNotification(ErrorBundle errorBundle) {
        this.notifications[0].add(errorBundle);
    }

    protected void addNotification(ErrorBundle errorBundle, int n2) {
        if (n2 < -1 || n2 >= this.n) {
            throw new IndexOutOfBoundsException();
        }
        this.notifications[n2 + 1].add(errorBundle);
    }

    protected void addError(ErrorBundle errorBundle) {
        this.errors[0].add(errorBundle);
    }

    protected void addError(ErrorBundle errorBundle, int n2) {
        if (n2 < -1 || n2 >= this.n) {
            throw new IndexOutOfBoundsException();
        }
        this.errors[n2 + 1].add(errorBundle);
    }

    protected void doChecks() {
        if (!this.initialized) {
            throw new IllegalStateException("Object not initialized. Call init() first.");
        }
        if (this.notifications == null) {
            this.notifications = new List[this.n + 1];
            this.errors = new List[this.n + 1];
            for (int i2 = 0; i2 < this.notifications.length; ++i2) {
                this.notifications[i2] = new ArrayList();
                this.errors[i2] = new ArrayList();
            }
            this.checkSignatures();
            this.checkNameConstraints();
            this.checkPathLength();
            this.checkPolicy();
            this.checkCriticalExtensions();
        }
    }

    private void checkNameConstraints() {
        X509Certificate x509Certificate = null;
        PKIXNameConstraintValidator pKIXNameConstraintValidator = new PKIXNameConstraintValidator();
        try {
            for (int i2 = this.certs.size() - 1; i2 > 0; --i2) {
                int n2;
                Object object;
                GeneralSubtree[] generalSubtreeArray;
                Object object2;
                Object object3;
                int n3 = this.n - i2;
                x509Certificate = (X509Certificate)this.certs.get(i2);
                if (!PKIXCertPathReviewer.isSelfIssued(x509Certificate)) {
                    Object object4;
                    object3 = PKIXCertPathReviewer.getSubjectPrincipal(x509Certificate);
                    object2 = new ASN1InputStream(new ByteArrayInputStream(((X500Principal)object3).getEncoded()));
                    try {
                        generalSubtreeArray = (ASN1Sequence)((ASN1InputStream)object2).readObject();
                    }
                    catch (IOException iOException) {
                        ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.ncSubjectNameError", new Object[]{new UntrustedInput(object3)});
                        throw new CertPathReviewerException(errorBundle, (Throwable)iOException, this.certPath, i2);
                    }
                    try {
                        pKIXNameConstraintValidator.checkPermittedDN((ASN1Sequence)generalSubtreeArray);
                    }
                    catch (PKIXNameConstraintValidatorException pKIXNameConstraintValidatorException) {
                        ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.notPermittedDN", new Object[]{new UntrustedInput(((X500Principal)object3).getName())});
                        throw new CertPathReviewerException(errorBundle, (Throwable)pKIXNameConstraintValidatorException, this.certPath, i2);
                    }
                    try {
                        pKIXNameConstraintValidator.checkExcludedDN((ASN1Sequence)generalSubtreeArray);
                    }
                    catch (PKIXNameConstraintValidatorException pKIXNameConstraintValidatorException) {
                        ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.excludedDN", new Object[]{new UntrustedInput(((X500Principal)object3).getName())});
                        throw new CertPathReviewerException(errorBundle, (Throwable)pKIXNameConstraintValidatorException, this.certPath, i2);
                    }
                    try {
                        object = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(x509Certificate, SUBJECT_ALTERNATIVE_NAME);
                    }
                    catch (AnnotatedException annotatedException) {
                        object4 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.subjAltNameExtError");
                        throw new CertPathReviewerException((ErrorBundle)object4, (Throwable)annotatedException, this.certPath, i2);
                    }
                    if (object != null) {
                        for (n2 = 0; n2 < ((ASN1Sequence)object).size(); ++n2) {
                            object4 = GeneralName.getInstance(((ASN1Sequence)object).getObjectAt(n2));
                            try {
                                pKIXNameConstraintValidator.checkPermitted((GeneralName)object4);
                                pKIXNameConstraintValidator.checkExcluded((GeneralName)object4);
                                continue;
                            }
                            catch (PKIXNameConstraintValidatorException pKIXNameConstraintValidatorException) {
                                ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.notPermittedEmail", new Object[]{new UntrustedInput(object4)});
                                throw new CertPathReviewerException(errorBundle, (Throwable)pKIXNameConstraintValidatorException, this.certPath, i2);
                            }
                        }
                    }
                }
                try {
                    object3 = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(x509Certificate, NAME_CONSTRAINTS);
                }
                catch (AnnotatedException annotatedException) {
                    generalSubtreeArray = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.ncExtError");
                    throw new CertPathReviewerException((ErrorBundle)generalSubtreeArray, (Throwable)annotatedException, this.certPath, i2);
                }
                if (object3 == null) continue;
                object2 = NameConstraints.getInstance(object3);
                generalSubtreeArray = ((NameConstraints)object2).getPermittedSubtrees();
                if (generalSubtreeArray != null) {
                    pKIXNameConstraintValidator.intersectPermittedSubtree(generalSubtreeArray);
                }
                if ((object = ((NameConstraints)object2).getExcludedSubtrees()) == null) continue;
                for (n2 = 0; n2 != ((GeneralSubtree[])object).length; ++n2) {
                    pKIXNameConstraintValidator.addExcludedSubtree(object[n2]);
                }
            }
        }
        catch (CertPathReviewerException certPathReviewerException) {
            this.addError(certPathReviewerException.getErrorMessage(), certPathReviewerException.getIndex());
        }
    }

    private void checkPathLength() {
        int n2 = this.n;
        int n3 = 0;
        X509Certificate x509Certificate = null;
        for (int i2 = this.certs.size() - 1; i2 > 0; --i2) {
            int n4;
            BigInteger bigInteger;
            Object object;
            int n5 = this.n - i2;
            x509Certificate = (X509Certificate)this.certs.get(i2);
            if (!PKIXCertPathReviewer.isSelfIssued(x509Certificate)) {
                if (n2 <= 0) {
                    object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.pathLenghtExtended");
                    this.addError((ErrorBundle)object);
                }
                --n2;
                ++n3;
            }
            try {
                object = BasicConstraints.getInstance(PKIXCertPathReviewer.getExtensionValue(x509Certificate, BASIC_CONSTRAINTS));
            }
            catch (AnnotatedException annotatedException) {
                ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.processLengthConstError");
                this.addError(errorBundle, i2);
                object = null;
            }
            if (object == null || (bigInteger = ((BasicConstraints)object).getPathLenConstraint()) == null || (n4 = bigInteger.intValue()) >= n2) continue;
            n2 = n4;
        }
        ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.totalPathLength", new Object[]{Integers.valueOf(n3)});
        this.addNotification(errorBundle);
    }

    private void checkSignatures() {
        Object object;
        Object object2;
        Object object3;
        TrustAnchor trustAnchor = null;
        Object object4 = null;
        Object object5 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certPathValidDate", new Object[]{new TrustedInput(this.validDate), new TrustedInput(new Date())});
        this.addNotification((ErrorBundle)object5);
        try {
            object5 = (X509Certificate)this.certs.get(this.certs.size() - 1);
            object3 = this.getTrustAnchors((X509Certificate)object5, this.pkixParams.getTrustAnchors());
            if (object3.size() > 1) {
                object2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.conflictingTrustAnchors", new Object[]{Integers.valueOf(object3.size()), new UntrustedInput(((X509Certificate)object5).getIssuerX500Principal())});
                this.addError((ErrorBundle)object2);
            } else if (object3.isEmpty()) {
                object2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noTrustAnchorFound", new Object[]{new UntrustedInput(((X509Certificate)object5).getIssuerX500Principal()), Integers.valueOf(this.pkixParams.getTrustAnchors().size())});
                this.addError((ErrorBundle)object2);
            } else {
                trustAnchor = (TrustAnchor)object3.iterator().next();
                object2 = trustAnchor.getTrustedCert() != null ? trustAnchor.getTrustedCert().getPublicKey() : trustAnchor.getCAPublicKey();
                try {
                    CertPathValidatorUtilities.verifyX509Certificate((X509Certificate)object5, (PublicKey)object2, this.pkixParams.getSigProvider());
                }
                catch (SignatureException signatureException) {
                    object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.trustButInvalidCert");
                    this.addError((ErrorBundle)object);
                }
                catch (Exception exception) {}
            }
        }
        catch (CertPathReviewerException certPathReviewerException) {
            this.addError(certPathReviewerException.getErrorMessage());
        }
        catch (Throwable throwable) {
            object3 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.unknown", new Object[]{new UntrustedInput(throwable.getMessage()), new UntrustedInput(throwable)});
            this.addError((ErrorBundle)object3);
        }
        if (trustAnchor != null) {
            object5 = trustAnchor.getTrustedCert();
            try {
                object4 = object5 != null ? PKIXCertPathReviewer.getSubjectPrincipal((X509Certificate)object5) : new X500Principal(trustAnchor.getCAName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                object2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.trustDNInvalid", new Object[]{new UntrustedInput(trustAnchor.getCAName())});
                this.addError((ErrorBundle)object2);
            }
            if (object5 != null && (object3 = (Object)((X509Certificate)object5).getKeyUsage()) != null && object3[5] == false) {
                object2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.trustKeyUsage");
                this.addNotification((ErrorBundle)object2);
            }
        }
        object5 = null;
        object3 = object4;
        object2 = null;
        AlgorithmIdentifier algorithmIdentifier = null;
        object = null;
        ASN1Encodable aSN1Encodable = null;
        if (trustAnchor != null) {
            object2 = trustAnchor.getTrustedCert();
            object5 = object2 != null ? ((Certificate)object2).getPublicKey() : trustAnchor.getCAPublicKey();
            try {
                algorithmIdentifier = PKIXCertPathReviewer.getAlgorithmIdentifier((PublicKey)object5);
                object = algorithmIdentifier.getObjectId();
                aSN1Encodable = algorithmIdentifier.getParameters();
            }
            catch (CertPathValidatorException certPathValidatorException) {
                ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.trustPubKeyError");
                this.addError(errorBundle);
                algorithmIdentifier = null;
            }
        }
        X509Certificate x509Certificate = null;
        for (int i2 = this.certs.size() - 1; i2 >= 0; --i2) {
            Object object6;
            Iterator iterator;
            Object object7;
            Object object8;
            Object object9;
            Object object10;
            int n2 = this.n - i2;
            x509Certificate = (X509Certificate)this.certs.get(i2);
            if (object5 != null) {
                try {
                    CertPathValidatorUtilities.verifyX509Certificate(x509Certificate, (PublicKey)object5, this.pkixParams.getSigProvider());
                }
                catch (GeneralSecurityException generalSecurityException) {
                    object10 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.signatureNotVerified", new Object[]{generalSecurityException.getMessage(), generalSecurityException, generalSecurityException.getClass().getName()});
                    this.addError((ErrorBundle)object10, i2);
                }
            } else if (PKIXCertPathReviewer.isSelfIssued(x509Certificate)) {
                try {
                    CertPathValidatorUtilities.verifyX509Certificate(x509Certificate, x509Certificate.getPublicKey(), this.pkixParams.getSigProvider());
                    object9 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.rootKeyIsValidButNotATrustAnchor");
                    this.addError((ErrorBundle)object9, i2);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    object10 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.signatureNotVerified", new Object[]{generalSecurityException.getMessage(), generalSecurityException, generalSecurityException.getClass().getName()});
                    this.addError((ErrorBundle)object10, i2);
                }
            } else {
                object9 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.NoIssuerPublicKey");
                object10 = x509Certificate.getExtensionValue(X509Extensions.AuthorityKeyIdentifier.getId());
                if (object10 != null) {
                    try {
                        object8 = AuthorityKeyIdentifier.getInstance(X509ExtensionUtil.fromExtensionValue(object10));
                        object7 = ((AuthorityKeyIdentifier)object8).getAuthorityCertIssuer();
                        if (object7 != null) {
                            iterator = ((GeneralNames)object7).getNames()[0];
                            object6 = ((AuthorityKeyIdentifier)object8).getAuthorityCertSerialNumber();
                            if (object6 != null) {
                                Object[] objectArray = new Object[]{new LocaleString(RESOURCE_NAME, "missingIssuer"), " \"", iterator, "\" ", new LocaleString(RESOURCE_NAME, "missingSerial"), " ", object6};
                                ((LocalizedMessage)object9).setExtraArguments(objectArray);
                            }
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.addError((ErrorBundle)object9, i2);
            }
            try {
                x509Certificate.checkValidity(this.validDate);
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                object10 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certificateNotYetValid", new Object[]{new TrustedInput(x509Certificate.getNotBefore())});
                this.addError((ErrorBundle)object10, i2);
            }
            catch (CertificateExpiredException certificateExpiredException) {
                object10 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certificateExpired", new Object[]{new TrustedInput(x509Certificate.getNotAfter())});
                this.addError((ErrorBundle)object10, i2);
            }
            if (this.pkixParams.isRevocationEnabled()) {
                object9 = null;
                try {
                    object10 = PKIXCertPathReviewer.getExtensionValue(x509Certificate, CRL_DIST_POINTS);
                    if (object10 != null) {
                        object9 = CRLDistPoint.getInstance(object10);
                    }
                }
                catch (AnnotatedException annotatedException) {
                    object8 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlDistPtExtError");
                    this.addError((ErrorBundle)object8, i2);
                }
                object10 = null;
                try {
                    object8 = PKIXCertPathReviewer.getExtensionValue(x509Certificate, AUTH_INFO_ACCESS);
                    if (object8 != null) {
                        object10 = AuthorityInformationAccess.getInstance(object8);
                    }
                }
                catch (AnnotatedException annotatedException) {
                    object7 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlAuthInfoAccError");
                    this.addError((ErrorBundle)object7, i2);
                }
                object8 = this.getCRLDistUrls((CRLDistPoint)object9);
                object7 = this.getOCSPUrls((AuthorityInformationAccess)object10);
                iterator = ((Vector)object8).iterator();
                while (iterator.hasNext()) {
                    object6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlDistPoint", new Object[]{new UntrustedUrlInput(iterator.next())});
                    this.addNotification((ErrorBundle)object6, i2);
                }
                iterator = ((Vector)object7).iterator();
                while (iterator.hasNext()) {
                    object6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.ocspLocation", new Object[]{new UntrustedUrlInput(iterator.next())});
                    this.addNotification((ErrorBundle)object6, i2);
                }
                try {
                    this.checkRevocation(this.pkixParams, x509Certificate, this.validDate, (X509Certificate)object2, (PublicKey)object5, (Vector)object8, (Vector)object7, i2);
                }
                catch (CertPathReviewerException certPathReviewerException) {
                    this.addError(certPathReviewerException.getErrorMessage(), i2);
                }
            }
            if (object3 != null && !x509Certificate.getIssuerX500Principal().equals(object3)) {
                object9 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certWrongIssuer", new Object[]{((X500Principal)object3).getName(), x509Certificate.getIssuerX500Principal().getName()});
                this.addError((ErrorBundle)object9, i2);
            }
            if (n2 != this.n) {
                if (x509Certificate != null && x509Certificate.getVersion() == 1) {
                    object9 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noCACert");
                    this.addError((ErrorBundle)object9, i2);
                }
                try {
                    object9 = BasicConstraints.getInstance(PKIXCertPathReviewer.getExtensionValue(x509Certificate, BASIC_CONSTRAINTS));
                    if (object9 != null) {
                        if (!((BasicConstraints)object9).isCA()) {
                            object10 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noCACert");
                            this.addError((ErrorBundle)object10, i2);
                        }
                    } else {
                        object10 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noBasicConstraints");
                        this.addError((ErrorBundle)object10, i2);
                    }
                }
                catch (AnnotatedException annotatedException) {
                    object8 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.errorProcesingBC");
                    this.addError((ErrorBundle)object8, i2);
                }
                object10 = x509Certificate.getKeyUsage();
                if (object10 != null && object10[5] == 0) {
                    object8 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noCertSign");
                    this.addError((ErrorBundle)object8, i2);
                }
            }
            object2 = x509Certificate;
            object3 = x509Certificate.getSubjectX500Principal();
            try {
                object5 = PKIXCertPathReviewer.getNextWorkingKey(this.certs, i2);
                algorithmIdentifier = PKIXCertPathReviewer.getAlgorithmIdentifier((PublicKey)object5);
                object = algorithmIdentifier.getObjectId();
                aSN1Encodable = algorithmIdentifier.getParameters();
                continue;
            }
            catch (CertPathValidatorException certPathValidatorException) {
                object10 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.pubKeyError");
                this.addError((ErrorBundle)object10, i2);
                algorithmIdentifier = null;
                object = null;
                aSN1Encodable = null;
            }
        }
        this.trustAnchor = trustAnchor;
        this.subjectPublicKey = object5;
    }

    private void checkPolicy() {
        Set<String> set = this.pkixParams.getInitialPolicies();
        List[] listArray = new ArrayList[this.n + 1];
        for (int i2 = 0; i2 < listArray.length; ++i2) {
            listArray[i2] = new ArrayList();
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("2.5.29.32.0");
        Object object = new PKIXPolicyNode(new ArrayList(), 0, hashSet, null, new HashSet(), "2.5.29.32.0", false);
        listArray[0].add(object);
        int n2 = this.pkixParams.isExplicitPolicyRequired() ? 0 : this.n + 1;
        int n3 = this.pkixParams.isAnyPolicyInhibited() ? 0 : this.n + 1;
        int n4 = this.pkixParams.isPolicyMappingInhibited() ? 0 : this.n + 1;
        Object object2 = null;
        X509Certificate x509Certificate = null;
        try {
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            int n5;
            for (n5 = this.certs.size() - 1; n5 >= 0; --n5) {
                Set set2;
                Iterator iterator;
                int n6 = this.n - n5;
                x509Certificate = (X509Certificate)this.certs.get(n5);
                try {
                    object6 = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(x509Certificate, CERTIFICATE_POLICIES);
                }
                catch (AnnotatedException annotatedException) {
                    object5 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyExtError");
                    throw new CertPathReviewerException((ErrorBundle)object5, (Throwable)annotatedException, this.certPath, n5);
                }
                if (object6 != null && object != null) {
                    int n7;
                    Object object7;
                    Object object8;
                    Object object9;
                    object4 = ((ASN1Sequence)object6).getObjects();
                    object5 = new HashSet();
                    while (object4.hasMoreElements()) {
                        object9 = PolicyInformation.getInstance(object4.nextElement());
                        object8 = ((PolicyInformation)object9).getPolicyIdentifier();
                        object5.add(((DERObjectIdentifier)object8).getId());
                        if ("2.5.29.32.0".equals(((DERObjectIdentifier)object8).getId())) continue;
                        try {
                            object7 = PKIXCertPathReviewer.getQualifierSet(((PolicyInformation)object9).getPolicyQualifiers());
                        }
                        catch (CertPathValidatorException certPathValidatorException) {
                            object3 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyQualifierError");
                            throw new CertPathReviewerException((ErrorBundle)object3, (Throwable)certPathValidatorException, this.certPath, n5);
                        }
                        n7 = PKIXCertPathReviewer.processCertD1i(n6, listArray, (DERObjectIdentifier)object8, object7);
                        if (n7 != 0) continue;
                        PKIXCertPathReviewer.processCertD1ii(n6, listArray, (DERObjectIdentifier)object8, object7);
                    }
                    if (object2 == null || object2.contains("2.5.29.32.0")) {
                        object2 = object5;
                    } else {
                        object9 = object2.iterator();
                        object8 = new HashSet();
                        while (object9.hasNext()) {
                            object7 = object9.next();
                            if (!object5.contains(object7)) continue;
                            object8.add(object7);
                        }
                        object2 = object8;
                    }
                    if (n3 > 0 || n6 < this.n && PKIXCertPathReviewer.isSelfIssued(x509Certificate)) {
                        object4 = ((ASN1Sequence)object6).getObjects();
                        while (object4.hasMoreElements()) {
                            object9 = PolicyInformation.getInstance(object4.nextElement());
                            if (!"2.5.29.32.0".equals(((PolicyInformation)object9).getPolicyIdentifier().getId())) continue;
                            try {
                                object8 = PKIXCertPathReviewer.getQualifierSet(((PolicyInformation)object9).getPolicyQualifiers());
                            }
                            catch (CertPathValidatorException certPathValidatorException) {
                                ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyQualifierError");
                                throw new CertPathReviewerException(errorBundle, (Throwable)certPathValidatorException, this.certPath, n5);
                            }
                            object7 = listArray[n6 - 1];
                            for (n7 = 0; n7 < object7.size(); ++n7) {
                                object3 = (PKIXPolicyNode)object7.get(n7);
                                iterator = ((PKIXPolicyNode)object3).getExpectedPolicies().iterator();
                                while (iterator.hasNext()) {
                                    Object object10;
                                    String string;
                                    set2 = iterator.next();
                                    if (set2 instanceof String) {
                                        string = (String)((Object)set2);
                                    } else {
                                        if (!(set2 instanceof DERObjectIdentifier)) continue;
                                        string = ((DERObjectIdentifier)((Object)set2)).getId();
                                    }
                                    boolean bl2 = false;
                                    Iterator iterator2 = ((PKIXPolicyNode)object3).getChildren();
                                    while (iterator2.hasNext()) {
                                        object10 = (PKIXPolicyNode)iterator2.next();
                                        if (!string.equals(((PKIXPolicyNode)object10).getValidPolicy())) continue;
                                        bl2 = true;
                                    }
                                    if (bl2) continue;
                                    object10 = new HashSet();
                                    object10.add(string);
                                    PKIXPolicyNode pKIXPolicyNode = new PKIXPolicyNode(new ArrayList(), n6, (Set)object10, (PolicyNode)object3, (Set)object8, string, false);
                                    ((PKIXPolicyNode)object3).addChild(pKIXPolicyNode);
                                    listArray[n6].add(pKIXPolicyNode);
                                }
                            }
                        }
                    }
                    for (int i3 = n6 - 1; i3 >= 0; --i3) {
                        PKIXPolicyNode pKIXPolicyNode;
                        object8 = listArray[i3];
                        for (int i4 = 0; i4 < object8.size() && ((pKIXPolicyNode = (PKIXPolicyNode)object8.get(i4)).hasChildren() || (object = PKIXCertPathReviewer.removePolicyNode((PKIXPolicyNode)object, listArray, pKIXPolicyNode)) != null); ++i4) {
                        }
                    }
                    Set<String> set3 = x509Certificate.getCriticalExtensionOIDs();
                    if (set3 != null) {
                        boolean bl3 = set3.contains(CERTIFICATE_POLICIES);
                        List list = listArray[n6];
                        for (int i5 = 0; i5 < list.size(); ++i5) {
                            object3 = (PKIXPolicyNode)list.get(i5);
                            ((PKIXPolicyNode)object3).setCritical(bl3);
                        }
                    }
                }
                if (object6 == null) {
                    object = null;
                }
                if (n2 <= 0 && object == null) {
                    object4 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noValidPolicyTree");
                    throw new CertPathReviewerException((ErrorBundle)object4);
                }
                if (n6 == this.n) continue;
                try {
                    object4 = PKIXCertPathReviewer.getExtensionValue(x509Certificate, POLICY_MAPPINGS);
                }
                catch (AnnotatedException annotatedException) {
                    ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyMapExtError");
                    throw new CertPathReviewerException(errorBundle, (Throwable)annotatedException, this.certPath, n5);
                }
                if (object4 != null) {
                    object5 = (ASN1Sequence)object4;
                    for (int i6 = 0; i6 < ((ASN1Sequence)object5).size(); ++i6) {
                        ASN1Sequence aSN1Sequence = (ASN1Sequence)((ASN1Sequence)object5).getObjectAt(i6);
                        DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)aSN1Sequence.getObjectAt(0);
                        DERObjectIdentifier dERObjectIdentifier2 = (DERObjectIdentifier)aSN1Sequence.getObjectAt(1);
                        if ("2.5.29.32.0".equals(dERObjectIdentifier.getId())) {
                            object3 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.invalidPolicyMapping");
                            throw new CertPathReviewerException((ErrorBundle)object3, this.certPath, n5);
                        }
                        if (!"2.5.29.32.0".equals(dERObjectIdentifier2.getId())) continue;
                        object3 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.invalidPolicyMapping");
                        throw new CertPathReviewerException((ErrorBundle)object3, this.certPath, n5);
                    }
                }
                if (object4 != null) {
                    object5 = (ASN1Sequence)object4;
                    HashMap hashMap = new HashMap();
                    HashSet<Object> hashSet2 = new HashSet<Object>();
                    for (int i7 = 0; i7 < ((ASN1Sequence)object5).size(); ++i7) {
                        ASN1Sequence aSN1Sequence = (ASN1Sequence)((ASN1Sequence)object5).getObjectAt(i7);
                        object3 = ((DERObjectIdentifier)aSN1Sequence.getObjectAt(0)).getId();
                        iterator = ((DERObjectIdentifier)aSN1Sequence.getObjectAt(1)).getId();
                        if (!hashMap.containsKey(object3)) {
                            set2 = new HashSet();
                            set2.add(iterator);
                            hashMap.put(object3, set2);
                            hashSet2.add(object3);
                            continue;
                        }
                        set2 = (Set)hashMap.get(object3);
                        set2.add(iterator);
                    }
                    Iterator iterator3 = hashSet2.iterator();
                    while (iterator3.hasNext()) {
                        String string = (String)iterator3.next();
                        if (n4 > 0) {
                            try {
                                PKIXCertPathReviewer.prepareNextCertB1(n6, listArray, string, hashMap, x509Certificate);
                                continue;
                            }
                            catch (AnnotatedException annotatedException) {
                                iterator = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyExtError");
                                throw new CertPathReviewerException((ErrorBundle)((Object)iterator), (Throwable)annotatedException, this.certPath, n5);
                            }
                            catch (CertPathValidatorException certPathValidatorException) {
                                iterator = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyQualifierError");
                                throw new CertPathReviewerException((ErrorBundle)((Object)iterator), (Throwable)certPathValidatorException, this.certPath, n5);
                            }
                        }
                        if (n4 > 0) continue;
                        object = PKIXCertPathReviewer.prepareNextCertB2(n6, listArray, string, (PKIXPolicyNode)object);
                    }
                }
                if (!PKIXCertPathReviewer.isSelfIssued(x509Certificate)) {
                    if (n2 != 0) {
                        --n2;
                    }
                    if (n4 != 0) {
                        --n4;
                    }
                    if (n3 != 0) {
                        --n3;
                    }
                }
                try {
                    object5 = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(x509Certificate, POLICY_CONSTRAINTS);
                    if (object5 != null) {
                        Enumeration enumeration = ((ASN1Sequence)object5).getObjects();
                        while (enumeration.hasMoreElements()) {
                            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
                            switch (aSN1TaggedObject.getTagNo()) {
                                case 0: {
                                    int n8 = DERInteger.getInstance(aSN1TaggedObject, false).getValue().intValue();
                                    if (n8 >= n2) break;
                                    n2 = n8;
                                    break;
                                }
                                case 1: {
                                    int n8 = DERInteger.getInstance(aSN1TaggedObject, false).getValue().intValue();
                                    if (n8 >= n4) break;
                                    n4 = n8;
                                }
                            }
                        }
                    }
                }
                catch (AnnotatedException annotatedException) {
                    ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyConstExtError");
                    throw new CertPathReviewerException(errorBundle, this.certPath, n5);
                }
                try {
                    int n9;
                    object5 = (DERInteger)PKIXCertPathReviewer.getExtensionValue(x509Certificate, INHIBIT_ANY_POLICY);
                    if (object5 == null || (n9 = ((DERInteger)object5).getValue().intValue()) >= n3) continue;
                    n3 = n9;
                    continue;
                }
                catch (AnnotatedException annotatedException) {
                    ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyInhibitExtError");
                    throw new CertPathReviewerException(errorBundle, this.certPath, n5);
                }
            }
            if (!PKIXCertPathReviewer.isSelfIssued(x509Certificate) && n2 > 0) {
                --n2;
            }
            try {
                object6 = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(x509Certificate, POLICY_CONSTRAINTS);
                if (object6 != null) {
                    object4 = ((ASN1Sequence)object6).getObjects();
                    while (object4.hasMoreElements()) {
                        object5 = (ASN1TaggedObject)object4.nextElement();
                        switch (((ASN1TaggedObject)object5).getTagNo()) {
                            case 0: {
                                int n10 = DERInteger.getInstance((ASN1TaggedObject)object5, false).getValue().intValue();
                                if (n10 != 0) break;
                                n2 = 0;
                            }
                        }
                    }
                }
            }
            catch (AnnotatedException annotatedException) {
                object4 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyConstExtError");
                throw new CertPathReviewerException((ErrorBundle)object4, this.certPath, n5);
            }
            if (object == null) {
                if (this.pkixParams.isExplicitPolicyRequired()) {
                    object4 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.explicitPolicy");
                    throw new CertPathReviewerException((ErrorBundle)object4, this.certPath, n5);
                }
                object6 = null;
            } else if (PKIXCertPathReviewer.isAnyPolicy(set)) {
                if (this.pkixParams.isExplicitPolicyRequired()) {
                    if (object2.isEmpty()) {
                        object4 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.explicitPolicy");
                        throw new CertPathReviewerException((ErrorBundle)object4, this.certPath, n5);
                    }
                    object4 = new HashSet();
                    for (int i8 = 0; i8 < listArray.length; ++i8) {
                        ArrayList arrayList = listArray[i8];
                        for (int i9 = 0; i9 < arrayList.size(); ++i9) {
                            PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)arrayList.get(i9);
                            if (!"2.5.29.32.0".equals(pKIXPolicyNode.getValidPolicy())) continue;
                            Iterator iterator = pKIXPolicyNode.getChildren();
                            while (iterator.hasNext()) {
                                object4.add(iterator.next());
                            }
                        }
                    }
                    Iterator iterator = object4.iterator();
                    while (iterator.hasNext()) {
                        PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)iterator.next();
                        String string = pKIXPolicyNode.getValidPolicy();
                        if (object2.contains(string)) continue;
                    }
                    if (object != null) {
                        for (int i10 = this.n - 1; i10 >= 0; --i10) {
                            List list = listArray[i10];
                            for (int i11 = 0; i11 < list.size(); ++i11) {
                                PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)list.get(i11);
                                if (pKIXPolicyNode.hasChildren()) continue;
                                object = PKIXCertPathReviewer.removePolicyNode((PKIXPolicyNode)object, listArray, pKIXPolicyNode);
                            }
                        }
                    }
                }
                object6 = object;
            } else {
                object4 = new HashSet();
                for (int i12 = 0; i12 < listArray.length; ++i12) {
                    ArrayList arrayList = listArray[i12];
                    for (int i13 = 0; i13 < arrayList.size(); ++i13) {
                        PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)arrayList.get(i13);
                        if (!"2.5.29.32.0".equals(pKIXPolicyNode.getValidPolicy())) continue;
                        Iterator iterator = pKIXPolicyNode.getChildren();
                        while (iterator.hasNext()) {
                            object3 = (PKIXPolicyNode)iterator.next();
                            if ("2.5.29.32.0".equals(((PKIXPolicyNode)object3).getValidPolicy())) continue;
                            object4.add(object3);
                        }
                    }
                }
                Iterator iterator = object4.iterator();
                while (iterator.hasNext()) {
                    PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)iterator.next();
                    String string = pKIXPolicyNode.getValidPolicy();
                    if (set.contains(string)) continue;
                    object = PKIXCertPathReviewer.removePolicyNode((PKIXPolicyNode)object, listArray, pKIXPolicyNode);
                }
                if (object != null) {
                    for (int i14 = this.n - 1; i14 >= 0; --i14) {
                        ArrayList arrayList = listArray[i14];
                        for (int i15 = 0; i15 < arrayList.size(); ++i15) {
                            PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)arrayList.get(i15);
                            if (pKIXPolicyNode.hasChildren()) continue;
                            object = PKIXCertPathReviewer.removePolicyNode((PKIXPolicyNode)object, listArray, pKIXPolicyNode);
                        }
                    }
                }
                object6 = object;
            }
            if (n2 <= 0 && object6 == null) {
                object4 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.invalidPolicy");
                throw new CertPathReviewerException((ErrorBundle)object4);
            }
            object = object6;
        }
        catch (CertPathReviewerException certPathReviewerException) {
            this.addError(certPathReviewerException.getErrorMessage(), certPathReviewerException.getIndex());
            object = null;
        }
    }

    private void checkCriticalExtensions() {
        List<PKIXCertPathChecker> list = this.pkixParams.getCertPathCheckers();
        Iterator<PKIXCertPathChecker> iterator = list.iterator();
        try {
            try {
                while (iterator.hasNext()) {
                    iterator.next().init(false);
                }
            }
            catch (CertPathValidatorException certPathValidatorException) {
                ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certPathCheckerError", new Object[]{certPathValidatorException.getMessage(), certPathValidatorException, certPathValidatorException.getClass().getName()});
                throw new CertPathReviewerException(errorBundle, (Throwable)certPathValidatorException);
            }
            X509Certificate x509Certificate = null;
            for (int i2 = this.certs.size() - 1; i2 >= 0; --i2) {
                Object object;
                x509Certificate = (X509Certificate)this.certs.get(i2);
                Set<String> set = x509Certificate.getCriticalExtensionOIDs();
                if (set == null || set.isEmpty()) continue;
                set.remove(KEY_USAGE);
                set.remove(CERTIFICATE_POLICIES);
                set.remove(POLICY_MAPPINGS);
                set.remove(INHIBIT_ANY_POLICY);
                set.remove(ISSUING_DISTRIBUTION_POINT);
                set.remove(DELTA_CRL_INDICATOR);
                set.remove(POLICY_CONSTRAINTS);
                set.remove(BASIC_CONSTRAINTS);
                set.remove(SUBJECT_ALTERNATIVE_NAME);
                set.remove(NAME_CONSTRAINTS);
                if (set.contains(QC_STATEMENT) && this.processQcStatements(x509Certificate, i2)) {
                    set.remove(QC_STATEMENT);
                }
                Iterator<PKIXCertPathChecker> iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    try {
                        iterator2.next().check(x509Certificate, set);
                    }
                    catch (CertPathValidatorException certPathValidatorException) {
                        object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.criticalExtensionError", new Object[]{certPathValidatorException.getMessage(), certPathValidatorException, certPathValidatorException.getClass().getName()});
                        throw new CertPathReviewerException((ErrorBundle)object, certPathValidatorException.getCause(), this.certPath, i2);
                    }
                }
                if (set.isEmpty()) continue;
                object = set.iterator();
                while (object.hasNext()) {
                    ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.unknownCriticalExt", new Object[]{new DERObjectIdentifier(object.next())});
                    this.addError(errorBundle, i2);
                }
            }
        }
        catch (CertPathReviewerException certPathReviewerException) {
            this.addError(certPathReviewerException.getErrorMessage(), certPathReviewerException.getIndex());
        }
    }

    private boolean processQcStatements(X509Certificate x509Certificate, int n2) {
        try {
            boolean bl2 = false;
            ASN1Sequence aSN1Sequence = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(x509Certificate, QC_STATEMENT);
            for (int i2 = 0; i2 < aSN1Sequence.size(); ++i2) {
                Object object;
                QCStatement qCStatement = QCStatement.getInstance(aSN1Sequence.getObjectAt(i2));
                if (QCStatement.id_etsi_qcs_QcCompliance.equals(qCStatement.getStatementId())) {
                    object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcEuCompliance");
                    this.addNotification((ErrorBundle)object, n2);
                    continue;
                }
                if (QCStatement.id_qcs_pkixQCSyntax_v1.equals(qCStatement.getStatementId())) continue;
                if (QCStatement.id_etsi_qcs_QcSSCD.equals(qCStatement.getStatementId())) {
                    object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcSSCD");
                    this.addNotification((ErrorBundle)object, n2);
                    continue;
                }
                if (QCStatement.id_etsi_qcs_LimiteValue.equals(qCStatement.getStatementId())) {
                    object = MonetaryValue.getInstance(qCStatement.getStatementInfo());
                    Iso4217CurrencyCode iso4217CurrencyCode = ((MonetaryValue)object).getCurrency();
                    double d2 = ((MonetaryValue)object).getAmount().doubleValue() * Math.pow(10.0, ((MonetaryValue)object).getExponent().doubleValue());
                    ErrorBundle errorBundle = ((MonetaryValue)object).getCurrency().isAlphabetic() ? new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcLimitValueAlpha", new Object[]{((MonetaryValue)object).getCurrency().getAlphabetic(), new TrustedInput(new Double(d2)), object}) : new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcLimitValueNum", new Object[]{Integers.valueOf(((MonetaryValue)object).getCurrency().getNumeric()), new TrustedInput(new Double(d2)), object});
                    this.addNotification(errorBundle, n2);
                    continue;
                }
                object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcUnknownStatement", new Object[]{qCStatement.getStatementId(), new UntrustedInput(qCStatement)});
                this.addNotification((ErrorBundle)object, n2);
                bl2 = true;
            }
            return !bl2;
        }
        catch (AnnotatedException annotatedException) {
            ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcStatementExtError");
            this.addError(errorBundle, n2);
            return false;
        }
    }

    private String IPtoString(byte[] byArray) {
        String string;
        try {
            string = InetAddress.getByAddress(byArray).getHostAddress();
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 != byArray.length; ++i2) {
                stringBuffer.append(Integer.toHexString(byArray[i2] & 0xFF));
                stringBuffer.append(' ');
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    protected void checkRevocation(PKIXParameters pKIXParameters, X509Certificate x509Certificate, Date date, X509Certificate x509Certificate2, PublicKey publicKey, Vector vector, Vector vector2, int n2) throws CertPathReviewerException {
        this.checkCRLs(pKIXParameters, x509Certificate, date, x509Certificate2, publicKey, vector, n2);
    }

    protected void checkCRLs(PKIXParameters pKIXParameters, X509Certificate x509Certificate, Date date, X509Certificate x509Certificate2, PublicKey publicKey, Vector vector, int n2) throws CertPathReviewerException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Iterator iterator;
        X509CRLStoreSelector x509CRLStoreSelector = new X509CRLStoreSelector();
        try {
            x509CRLStoreSelector.addIssuerName(PKIXCertPathReviewer.getEncodedIssuerPrincipal(x509Certificate).getEncoded());
        }
        catch (IOException iOException) {
            ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlIssuerException");
            throw new CertPathReviewerException(errorBundle, (Throwable)iOException);
        }
        x509CRLStoreSelector.setCertificateChecking(x509Certificate);
        try {
            Set set = CRL_UTIL.findCRLs(x509CRLStoreSelector, pKIXParameters);
            iterator = set.iterator();
            if (set.isEmpty()) {
                set = CRL_UTIL.findCRLs(new X509CRLStoreSelector(), pKIXParameters);
                object4 = set.iterator();
                object3 = new ArrayList<X500Principal>();
                while (object4.hasNext()) {
                    object3.add(((X509CRL)object4.next()).getIssuerX500Principal());
                }
                int n3 = object3.size();
                object2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noCrlInCertstore", new Object[]{new UntrustedInput(x509CRLStoreSelector.getIssuerNames()), new UntrustedInput(object3), Integers.valueOf(n3)});
                this.addNotification((ErrorBundle)object2, n2);
            }
        }
        catch (AnnotatedException annotatedException) {
            object4 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlExtractionError", new Object[]{annotatedException.getCause().getMessage(), annotatedException.getCause(), annotatedException.getCause().getClass().getName()});
            this.addError((ErrorBundle)object4, n2);
            iterator = new ArrayList().iterator();
        }
        boolean bl2 = false;
        object4 = null;
        while (iterator.hasNext()) {
            object4 = (X509CRL)iterator.next();
            if (((X509CRL)object4).getNextUpdate() == null || pKIXParameters.getDate().before(((X509CRL)object4).getNextUpdate())) {
                bl2 = true;
                object3 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.localValidCRL", new Object[]{new TrustedInput(((X509CRL)object4).getThisUpdate()), new TrustedInput(((X509CRL)object4).getNextUpdate())});
                this.addNotification((ErrorBundle)object3, n2);
                break;
            }
            object3 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.localInvalidCRL", new Object[]{new TrustedInput(((X509CRL)object4).getThisUpdate()), new TrustedInput(((X509CRL)object4).getNextUpdate())});
            this.addNotification((ErrorBundle)object3, n2);
        }
        if (!bl2) {
            object3 = null;
            Iterator iterator2 = vector.iterator();
            while (iterator2.hasNext()) {
                try {
                    object2 = (String)iterator2.next();
                    object3 = this.getCRL((String)object2);
                    if (object3 == null) continue;
                    if (!x509Certificate.getIssuerX500Principal().equals(((X509CRL)object3).getIssuerX500Principal())) {
                        object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.onlineCRLWrongCA", new Object[]{new UntrustedInput(((X509CRL)object3).getIssuerX500Principal().getName()), new UntrustedInput(x509Certificate.getIssuerX500Principal().getName()), new UntrustedUrlInput(object2)});
                        this.addNotification((ErrorBundle)object, n2);
                        continue;
                    }
                    if (((X509CRL)object3).getNextUpdate() == null || this.pkixParams.getDate().before(((X509CRL)object3).getNextUpdate())) {
                        bl2 = true;
                        object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.onlineValidCRL", new Object[]{new TrustedInput(((X509CRL)object3).getThisUpdate()), new TrustedInput(((X509CRL)object3).getNextUpdate()), new UntrustedUrlInput(object2)});
                        this.addNotification((ErrorBundle)object, n2);
                        object4 = object3;
                        break;
                    }
                    object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.onlineInvalidCRL", new Object[]{new TrustedInput(((X509CRL)object3).getThisUpdate()), new TrustedInput(((X509CRL)object3).getNextUpdate()), new UntrustedUrlInput(object2)});
                    this.addNotification((ErrorBundle)object, n2);
                }
                catch (CertPathReviewerException certPathReviewerException) {
                    this.addNotification(certPathReviewerException.getErrorMessage(), n2);
                }
            }
        }
        if (object4 != null) {
            Object object5;
            Object object6;
            Object object7;
            boolean[] blArray;
            if (!(x509Certificate2 == null || (blArray = x509Certificate2.getKeyUsage()) == null || blArray.length >= 7 && blArray[6])) {
                object2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noCrlSigningPermited");
                throw new CertPathReviewerException((ErrorBundle)object2);
            }
            if (publicKey != null) {
                try {
                    ((X509CRL)object4).verify(publicKey, "BC");
                }
                catch (Exception exception) {
                    object2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlVerifyFailed");
                    throw new CertPathReviewerException((ErrorBundle)object2, (Throwable)exception);
                }
            } else {
                ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlNoIssuerPublicKey");
                throw new CertPathReviewerException(errorBundle);
            }
            object3 = ((X509CRL)object4).getRevokedCertificate(x509Certificate.getSerialNumber());
            if (object3 != null) {
                object7 = null;
                if (((X509CRLEntry)object3).hasExtensions()) {
                    try {
                        object2 = DEREnumerated.getInstance(PKIXCertPathReviewer.getExtensionValue((X509Extension)object3, X509Extensions.ReasonCode.getId()));
                    }
                    catch (AnnotatedException annotatedException) {
                        ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlReasonExtError");
                        throw new CertPathReviewerException(errorBundle, (Throwable)annotatedException);
                    }
                    if (object2 != null) {
                        object7 = crlReasons[((DEREnumerated)object2).getValue().intValue()];
                    }
                }
                if (object7 == null) {
                    object7 = crlReasons[7];
                }
                object2 = new LocaleString(RESOURCE_NAME, (String)object7);
                if (!date.before(((X509CRLEntry)object3).getRevocationDate())) {
                    object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certRevoked", new Object[]{new TrustedInput(((X509CRLEntry)object3).getRevocationDate()), object2});
                    throw new CertPathReviewerException((ErrorBundle)object);
                }
                object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.revokedAfterValidation", new Object[]{new TrustedInput(((X509CRLEntry)object3).getRevocationDate()), object2});
                this.addNotification((ErrorBundle)object, n2);
            } else {
                object7 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.notRevoked");
                this.addNotification((ErrorBundle)object7, n2);
            }
            if (((X509CRL)object4).getNextUpdate() != null && ((X509CRL)object4).getNextUpdate().before(this.pkixParams.getDate())) {
                object7 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlUpdateAvailable", new Object[]{new TrustedInput(((X509CRL)object4).getNextUpdate())});
                this.addNotification((ErrorBundle)object7, n2);
            }
            try {
                object7 = PKIXCertPathReviewer.getExtensionValue((X509Extension)object4, ISSUING_DISTRIBUTION_POINT);
            }
            catch (AnnotatedException annotatedException) {
                object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.distrPtExtError");
                throw new CertPathReviewerException((ErrorBundle)object);
            }
            try {
                object2 = PKIXCertPathReviewer.getExtensionValue((X509Extension)object4, DELTA_CRL_INDICATOR);
            }
            catch (AnnotatedException annotatedException) {
                ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.deltaCrlExtError");
                throw new CertPathReviewerException(errorBundle);
            }
            if (object2 != null) {
                object = new X509CRLStoreSelector();
                try {
                    ((X509CRLSelector)object).addIssuerName(PKIXCertPathReviewer.getIssuerPrincipal((X509CRL)object4).getEncoded());
                }
                catch (IOException iOException) {
                    ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlIssuerException");
                    throw new CertPathReviewerException(errorBundle, (Throwable)iOException);
                }
                ((X509CRLSelector)object).setMinCRLNumber(((DERInteger)object2).getPositiveValue());
                try {
                    ((X509CRLSelector)object).setMaxCRLNumber(((DERInteger)PKIXCertPathReviewer.getExtensionValue((X509Extension)object4, CRL_NUMBER)).getPositiveValue().subtract(BigInteger.valueOf(1L)));
                }
                catch (AnnotatedException annotatedException) {
                    ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlNbrExtError");
                    throw new CertPathReviewerException(errorBundle, (Throwable)annotatedException);
                }
                boolean bl3 = false;
                try {
                    object6 = CRL_UTIL.findCRLs((X509CRLStoreSelector)object, pKIXParameters).iterator();
                }
                catch (AnnotatedException annotatedException) {
                    ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlExtractionError");
                    throw new CertPathReviewerException(errorBundle, (Throwable)annotatedException);
                }
                while (object6.hasNext()) {
                    ASN1Primitive aSN1Primitive;
                    object5 = (X509CRL)object6.next();
                    try {
                        aSN1Primitive = PKIXCertPathReviewer.getExtensionValue((X509Extension)object5, ISSUING_DISTRIBUTION_POINT);
                    }
                    catch (AnnotatedException annotatedException) {
                        ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.distrPtExtError");
                        throw new CertPathReviewerException(errorBundle, (Throwable)annotatedException);
                    }
                    if (object7 == null) {
                        if (aSN1Primitive != null) continue;
                        bl3 = true;
                        break;
                    }
                    if (!((ASN1Primitive)object7).equals(aSN1Primitive)) continue;
                    bl3 = true;
                    break;
                }
                if (!bl3) {
                    object5 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noBaseCRL");
                    throw new CertPathReviewerException((ErrorBundle)object5);
                }
            }
            if (object7 != null) {
                object = IssuingDistributionPoint.getInstance(object7);
                BasicConstraints basicConstraints = null;
                try {
                    basicConstraints = BasicConstraints.getInstance(PKIXCertPathReviewer.getExtensionValue(x509Certificate, BASIC_CONSTRAINTS));
                }
                catch (AnnotatedException annotatedException) {
                    object5 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlBCExtError");
                    throw new CertPathReviewerException((ErrorBundle)object5, (Throwable)annotatedException);
                }
                if (((IssuingDistributionPoint)object).onlyContainsUserCerts() && basicConstraints != null && basicConstraints.isCA()) {
                    object6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlOnlyUserCert");
                    throw new CertPathReviewerException((ErrorBundle)object6);
                }
                if (((IssuingDistributionPoint)object).onlyContainsCACerts() && (basicConstraints == null || !basicConstraints.isCA())) {
                    object6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlOnlyCaCert");
                    throw new CertPathReviewerException((ErrorBundle)object6);
                }
                if (((IssuingDistributionPoint)object).onlyContainsAttributeCerts()) {
                    object6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlOnlyAttrCert");
                    throw new CertPathReviewerException((ErrorBundle)object6);
                }
            }
        }
        if (!bl2) {
            ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noValidCrlFound");
            throw new CertPathReviewerException(errorBundle);
        }
    }

    protected Vector getCRLDistUrls(CRLDistPoint cRLDistPoint) {
        Vector<String> vector = new Vector<String>();
        if (cRLDistPoint != null) {
            DistributionPoint[] distributionPointArray = cRLDistPoint.getDistributionPoints();
            for (int i2 = 0; i2 < distributionPointArray.length; ++i2) {
                DistributionPointName distributionPointName = distributionPointArray[i2].getDistributionPoint();
                if (distributionPointName.getType() != 0) continue;
                GeneralName[] generalNameArray = GeneralNames.getInstance(distributionPointName.getName()).getNames();
                for (int i3 = 0; i3 < generalNameArray.length; ++i3) {
                    if (generalNameArray[i3].getTagNo() != 6) continue;
                    String string = ((DERIA5String)generalNameArray[i3].getName()).getString();
                    vector.add(string);
                }
            }
        }
        return vector;
    }

    protected Vector getOCSPUrls(AuthorityInformationAccess authorityInformationAccess) {
        Vector<String> vector = new Vector<String>();
        if (authorityInformationAccess != null) {
            AccessDescription[] accessDescriptionArray = authorityInformationAccess.getAccessDescriptions();
            for (int i2 = 0; i2 < accessDescriptionArray.length; ++i2) {
                GeneralName generalName;
                if (!accessDescriptionArray[i2].getAccessMethod().equals(AccessDescription.id_ad_ocsp) || (generalName = accessDescriptionArray[i2].getAccessLocation()).getTagNo() != 6) continue;
                String string = ((DERIA5String)generalName.getName()).getString();
                vector.add(string);
            }
        }
        return vector;
    }

    private X509CRL getCRL(String string) throws CertPathReviewerException {
        X509CRL x509CRL;
        block3: {
            x509CRL = null;
            try {
                URL uRL = new URL(string);
                if (!uRL.getProtocol().equals("http") && !uRL.getProtocol().equals("https")) break block3;
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setUseCaches(false);
                httpURLConnection.setDoInput(true);
                httpURLConnection.connect();
                if (httpURLConnection.getResponseCode() == 200) {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
                    x509CRL = (X509CRL)certificateFactory.generateCRL(httpURLConnection.getInputStream());
                    break block3;
                }
                throw new Exception(httpURLConnection.getResponseMessage());
            }
            catch (Exception exception) {
                ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.loadCrlDistPointError", new Object[]{new UntrustedInput(string), exception.getMessage(), exception, exception.getClass().getName()});
                throw new CertPathReviewerException(errorBundle);
            }
        }
        return x509CRL;
    }

    protected Collection getTrustAnchors(X509Certificate x509Certificate, Set set) throws CertPathReviewerException {
        Object object;
        Object object2;
        Object object3;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = set.iterator();
        X509CertSelector x509CertSelector = new X509CertSelector();
        try {
            x509CertSelector.setSubject(PKIXCertPathReviewer.getEncodedIssuerPrincipal(x509Certificate).getEncoded());
            object3 = x509Certificate.getExtensionValue(X509Extensions.AuthorityKeyIdentifier.getId());
            if (object3 != null) {
                object2 = (ASN1OctetString)ASN1Primitive.fromByteArray((byte[])object3);
                object = AuthorityKeyIdentifier.getInstance(ASN1Primitive.fromByteArray(((ASN1OctetString)object2).getOctets()));
                x509CertSelector.setSerialNumber(((AuthorityKeyIdentifier)object).getAuthorityCertSerialNumber());
                byte[] byArray = ((AuthorityKeyIdentifier)object).getKeyIdentifier();
                if (byArray != null) {
                    x509CertSelector.setSubjectKeyIdentifier(new DEROctetString(byArray).getEncoded());
                }
            }
        }
        catch (IOException iOException) {
            ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.trustAnchorIssuerError");
            throw new CertPathReviewerException(errorBundle);
        }
        while (iterator.hasNext()) {
            object3 = (TrustAnchor)iterator.next();
            if (((TrustAnchor)object3).getTrustedCert() != null) {
                if (!x509CertSelector.match(((TrustAnchor)object3).getTrustedCert())) continue;
                arrayList.add(object3);
                continue;
            }
            if (((TrustAnchor)object3).getCAName() == null || ((TrustAnchor)object3).getCAPublicKey() == null || !((X500Principal)(object2 = PKIXCertPathReviewer.getEncodedIssuerPrincipal(x509Certificate))).equals(object = new X500Principal(((TrustAnchor)object3).getCAName()))) continue;
            arrayList.add(object3);
        }
        return arrayList;
    }
}

