/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.slf4j;

import com.zeroturnaround.bundled.org.slf4j.ILoggerFactory;
import com.zeroturnaround.bundled.org.slf4j.Logger;
import com.zeroturnaround.bundled.org.slf4j.helpers.NOPLoggerFactory;
import com.zeroturnaround.bundled.org.slf4j.helpers.SubstituteLoggerFactory;
import com.zeroturnaround.bundled.org.slf4j.helpers.Util;
import com.zeroturnaround.bundled.org.slf4j.impl.StaticLoggerBinder;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;

public final class LoggerFactory {
    static final String CODES_PREFIX = "http://www.slf4j.org/codes.html";
    static final String NO_STATICLOGGERBINDER_URL = "http://www.slf4j.org/codes.html#StaticLoggerBinder";
    static final String MULTIPLE_BINDINGS_URL = "http://www.slf4j.org/codes.html#multiple_bindings";
    static final String NULL_LF_URL = "http://www.slf4j.org/codes.html#null_LF";
    static final String VERSION_MISMATCH = "http://www.slf4j.org/codes.html#version_mismatch";
    static final String SUBSTITUTE_LOGGER_URL = "http://www.slf4j.org/codes.html#substituteLogger";
    static final String UNSUCCESSFUL_INIT_URL = "http://www.slf4j.org/codes.html#unsuccessfulInit";
    static final String UNSUCCESSFUL_INIT_MSG = "org.slf4j.LoggerFactory could not be successfully initialized. See also http://www.slf4j.org/codes.html#unsuccessfulInit";
    static final int UNINITIALIZED = 0;
    static final int ONGOING_INITILIZATION = 1;
    static final int FAILED_INITILIZATION = 2;
    static final int SUCCESSFUL_INITILIZATION = 3;
    static final int NOP_FALLBACK_INITILIZATION = 4;
    static int INITIALIZATION_STATE = 0;
    static SubstituteLoggerFactory TEMP_FACTORY = new SubstituteLoggerFactory();
    static NOPLoggerFactory NOP_FALLBACK_FACTORY = new NOPLoggerFactory();
    private static final String[] API_COMPATIBILITY_LIST = new String[]{"1.6"};
    private static String STATIC_LOGGER_BINDER_PATH = "com/zeroturnaround/bundled/org/slf4j/impl/StaticLoggerBinder.class";
    static Class class$org$slf4j$LoggerFactory;

    private LoggerFactory() {
    }

    static void reset() {
        INITIALIZATION_STATE = 0;
        TEMP_FACTORY = new SubstituteLoggerFactory();
    }

    private static final void performInitialization() {
        LoggerFactory.singleImplementationSanityCheck();
        LoggerFactory.bind();
        if (INITIALIZATION_STATE == 3) {
            LoggerFactory.versionSanityCheck();
        }
    }

    private static boolean messageContainsOrgSlf4jImplStaticLoggerBinder(String string) {
        if (string == null) {
            return false;
        }
        if (string.indexOf("com/zeroturnaround/bundled/org/slf4j/impl/StaticLoggerBinder") != -1) {
            return true;
        }
        return string.indexOf("com.zeroturnaround.bundled.org.slf4j.impl.StaticLoggerBinder") != -1;
    }

    private static final void bind() {
        try {
            StaticLoggerBinder.getSingleton();
            INITIALIZATION_STATE = 3;
            LoggerFactory.emitSubstituteLoggerWarning();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String string = noClassDefFoundError.getMessage();
            if (LoggerFactory.messageContainsOrgSlf4jImplStaticLoggerBinder(string)) {
                INITIALIZATION_STATE = 4;
                Util.report("Failed to load class \"org.slf4j.impl.StaticLoggerBinder\".");
                Util.report("Defaulting to no-operation (NOP) logger implementation");
                Util.report("See http://www.slf4j.org/codes.html#StaticLoggerBinder for further details.");
            }
            LoggerFactory.failedBinding(noClassDefFoundError);
            throw noClassDefFoundError;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            String string = noSuchMethodError.getMessage();
            if (string != null && string.indexOf("org.slf4j.impl.StaticLoggerBinder.getSingleton()") != -1) {
                INITIALIZATION_STATE = 2;
                Util.report("slf4j-api 1.6.x (or later) is incompatible with this binding.");
                Util.report("Your binding is version 1.5.5 or earlier.");
                Util.report("Upgrade your binding to version 1.6.x. or 2.0.x");
            }
            throw noSuchMethodError;
        }
        catch (Exception exception) {
            LoggerFactory.failedBinding(exception);
            throw new IllegalStateException("Unexpected initialization failure", exception);
        }
    }

    static void failedBinding(Throwable throwable) {
        INITIALIZATION_STATE = 2;
        Util.report("Failed to instantiate SLF4J LoggerFactory", throwable);
    }

    private static final void emitSubstituteLoggerWarning() {
        List list = TEMP_FACTORY.getLoggerNameList();
        if (list.size() == 0) {
            return;
        }
        Util.report("The following loggers will not work because they were created");
        Util.report("during the default configuration phase of the underlying logging system.");
        Util.report("See also http://www.slf4j.org/codes.html#substituteLogger");
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string = (String)list.get(i2);
            Util.report(string);
        }
    }

    private static final void versionSanityCheck() {
        try {
            String string = StaticLoggerBinder.REQUESTED_API_VERSION;
            boolean bl2 = false;
            for (int i2 = 0; i2 < API_COMPATIBILITY_LIST.length; ++i2) {
                if (!string.startsWith(API_COMPATIBILITY_LIST[i2])) continue;
                bl2 = true;
            }
            if (!bl2) {
                Util.report("The requested version " + string + " by your slf4j binding is not compatible with " + Arrays.asList(API_COMPATIBILITY_LIST).toString());
                Util.report("See http://www.slf4j.org/codes.html#version_mismatch for further details.");
            }
        }
        catch (NoSuchFieldError noSuchFieldError) {
        }
        catch (Throwable throwable) {
            Util.report("Unexpected problem occured during version sanity check", throwable);
        }
    }

    private static void singleImplementationSanityCheck() {
        try {
            Object object;
            ClassLoader classLoader = (class$org$slf4j$LoggerFactory == null ? (class$org$slf4j$LoggerFactory = LoggerFactory.class$("com.zeroturnaround.bundled.org.slf4j.LoggerFactory")) : class$org$slf4j$LoggerFactory).getClassLoader();
            Enumeration<URL> enumeration = classLoader == null ? ClassLoader.getSystemResources(STATIC_LOGGER_BINDER_PATH) : classLoader.getResources(STATIC_LOGGER_BINDER_PATH);
            LinkedHashSet<URL> linkedHashSet = new LinkedHashSet<URL>();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                linkedHashSet.add((URL)object);
            }
            if (linkedHashSet.size() > 1) {
                Util.report("Class path contains multiple SLF4J bindings.");
                object = linkedHashSet.iterator();
                while (object.hasNext()) {
                    URL uRL = (URL)object.next();
                    Util.report("Found binding in [" + uRL + "]");
                }
                Util.report("See http://www.slf4j.org/codes.html#multiple_bindings for an explanation.");
            }
        }
        catch (IOException iOException) {
            Util.report("Error getting resources from path", iOException);
        }
    }

    public static Logger getLogger(String string) {
        ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
        return iLoggerFactory.getLogger(string);
    }

    public static Logger getLogger(Class clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    public static ILoggerFactory getILoggerFactory() {
        if (INITIALIZATION_STATE == 0) {
            INITIALIZATION_STATE = 1;
            LoggerFactory.performInitialization();
        }
        switch (INITIALIZATION_STATE) {
            case 3: {
                return StaticLoggerBinder.getSingleton().getLoggerFactory();
            }
            case 4: {
                return NOP_FALLBACK_FACTORY;
            }
            case 2: {
                throw new IllegalStateException(UNSUCCESSFUL_INIT_MSG);
            }
            case 1: {
                return TEMP_FACTORY;
            }
        }
        throw new IllegalStateException("Unreachable code");
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

