/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.liverebel.util;

import com.zeroturnaround.bundled.org.slf4j.Logger;
import com.zeroturnaround.bundled.org.slf4j.LoggerFactory;
import com.zeroturnaround.javarebel.ap;
import com.zeroturnaround.liverebel.util.AppXmlHandler;
import com.zeroturnaround.liverebel.util.AppXmlParser$HandlerException;
import com.zeroturnaround.liverebel.util.ErrorUtil;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;

public class AppXmlParser {
    private static final Logger log;
    public static final String APPLICATION_XML = "application.xml";
    private static final String ELEMENT_APPLICATION = "application";
    private static final String ELEMENT_DISPLAY_NAME = "display-name";
    private static final String ELEMENT_DESCRIPTION = "description";
    private static final String ELEMENT_MODULE = "module";
    private static final String ELEMENT_LIBRARY_DIRECTORY = "library-directory";
    private static final String ELEMENT_EJB = "ejb";
    private static final String ELEMENT_JAVA = "java";
    private static final String ELEMENT_WEB = "web";
    private static final String ELEMENT_WEB_URI = "web-uri";
    private static final String ELEMENT_CONTEXT_ROOT = "context-root";
    static Class class$com$zeroturnaround$liverebel$util$AppXmlParser;

    public static void parse(byte[] byArray, AppXmlHandler appXmlHandler) {
        String string;
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        AppXmlParser.parse(string, appXmlHandler);
    }

    public static void parse(String string, AppXmlHandler appXmlHandler) {
        log.trace("Parsing {}: {}", (Object)APPLICATION_XML, (Object)string);
        try {
            ap ap2 = new ap();
            ap2.a(string);
            AppXmlParser.processDocument(ap2, appXmlHandler);
        }
        catch (AppXmlParser$HandlerException appXmlParser$HandlerException) {
            throw ErrorUtil.rethrow(appXmlParser$HandlerException.getCause());
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to process 'application.xml", exception);
        }
    }

    private static void processDocument(ap ap2, AppXmlHandler appXmlHandler) {
        AppXmlParser.expectName(ap2, ELEMENT_APPLICATION);
        boolean bl2 = false;
        Iterator iterator = ap2.a().iterator();
        while (iterator.hasNext()) {
            ap ap3 = (ap)iterator.next();
            String string = ap3.b();
            if (ELEMENT_DISPLAY_NAME.equals(string)) {
                try {
                    appXmlHandler.displayName(ap3.a());
                    continue;
                }
                catch (Exception exception) {
                    throw new AppXmlParser$HandlerException(exception);
                }
            }
            if (ELEMENT_DESCRIPTION.equals(string)) {
                try {
                    appXmlHandler.description(ap3.a());
                    continue;
                }
                catch (Exception exception) {
                    throw new AppXmlParser$HandlerException(exception);
                }
            }
            if (ELEMENT_MODULE.equals(string)) {
                AppXmlParser.processModule(ap3, appXmlHandler);
                continue;
            }
            if (!ELEMENT_LIBRARY_DIRECTORY.equals(string)) continue;
            appXmlHandler.libraryDirectory(ap3.a());
            bl2 = true;
        }
        if (!bl2) {
            appXmlHandler.libraryDirectory("lib");
        }
    }

    private static void processModule(ap ap2, AppXmlHandler appXmlHandler) {
        Iterator iterator = ap2.a().iterator();
        while (iterator.hasNext()) {
            ap ap3 = (ap)iterator.next();
            String string = ap3.b();
            if (ELEMENT_EJB.equals(string)) {
                AppXmlParser.processEjb(ap3, appXmlHandler);
                continue;
            }
            if (ELEMENT_JAVA.equals(string)) {
                AppXmlParser.processJava(ap3, appXmlHandler);
                continue;
            }
            if (!ELEMENT_WEB.equals(string)) continue;
            AppXmlParser.processWeb(ap3, appXmlHandler);
        }
    }

    private static void processEjb(ap ap2, AppXmlHandler appXmlHandler) {
        String string = ap2.a();
        try {
            appXmlHandler.ejb(string);
        }
        catch (Exception exception) {
            throw new AppXmlParser$HandlerException(exception);
        }
    }

    private static void processJava(ap ap2, AppXmlHandler appXmlHandler) {
        String string = ap2.a();
        try {
            appXmlHandler.java(string);
        }
        catch (Exception exception) {
            throw new AppXmlParser$HandlerException(exception);
        }
    }

    private static void processWeb(ap ap2, AppXmlHandler appXmlHandler) {
        String string = null;
        String string2 = null;
        Iterator iterator = ap2.a().iterator();
        while (iterator.hasNext()) {
            ap ap3 = (ap)iterator.next();
            String string3 = ap3.b();
            if (ELEMENT_WEB_URI.equals(string3)) {
                string = ap3.a();
                continue;
            }
            if (!ELEMENT_CONTEXT_ROOT.equals(string3)) continue;
            string2 = ap3.a();
        }
        try {
            appXmlHandler.web(string, string2);
        }
        catch (Exception exception) {
            throw new AppXmlParser$HandlerException(exception);
        }
    }

    private static void expectName(ap ap2, String string) {
        if (!string.equals(ap2.b())) {
            throw new IllegalArgumentException("Element '" + string + "' expected instead of '" + ap2.b() + "'.");
        }
    }

    static {
        Class<?> clazz = class$com$zeroturnaround$liverebel$util$AppXmlParser;
        if (clazz == null) {
            clazz = class$com$zeroturnaround$liverebel$util$AppXmlParser = new AppXmlParser[0].getClass().getComponentType();
        }
        log = LoggerFactory.getLogger(clazz);
    }
}

