/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.liverebel.util;

import com.zeroturnaround.javarebel.ap;
import com.zeroturnaround.javarebel.aq;
import com.zeroturnaround.javarebel.cO;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;

public class LiveRebelXml {
    public static final String FILENAME = "liverebel.xml";
    private final String applicationId;
    private volatile String versionId;

    public LiveRebelXml(String string, String string2) {
        this.applicationId = string != null ? string.trim() : null;
        this.setVersionId(string2);
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String string) {
        this.versionId = string != null ? string.trim() : null;
    }

    public String getAsXml() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<application>\n  <name>" + this.applicationId + "</name>\n" + (this.versionId == null ? "" : "  <version>" + this.versionId + "</version>\n") + "</application>";
    }

    public static LiveRebelXml parse(byte[] byArray) {
        String string;
        if (byArray == null) {
            throw new IllegalArgumentException("XML must be provided.");
        }
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        return LiveRebelXml.parse(string);
    }

    public static LiveRebelXml parse(String string) {
        if (string == null) {
            throw new IllegalArgumentException("XML must be provided.");
        }
        if ("".equals(string)) {
            throw new IllegalArgumentException("Non-empty XML must be provided.");
        }
        ap ap2 = new ap();
        try {
            ap2.a(string);
        }
        catch (aq aq2) {
            throw new IllegalArgumentException("Could not parse liverebel.xml: " + string);
        }
        return LiveRebelXml.parse(ap2);
    }

    private static LiveRebelXml parse(ap ap2) {
        LiveRebelXml.expectName(ap2, "application");
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Iterator iterator = ap2.a().iterator();
        while (iterator.hasNext()) {
            ap ap3 = (ap)iterator.next();
            String string5 = ap3.b();
            String string6 = ap3.a();
            string6 = cO.b(string6);
            if ("name".equals(string5)) {
                string = string6;
            }
            if ("module".equals(string5)) {
                string2 = string6;
            }
            if ("deployment".equals(string5)) {
                string3 = string6;
            }
            if (!"version".equals(string5)) continue;
            string4 = string6;
        }
        LiveRebelXml.expectElementFound(string, "name");
        return new LiveRebelXml(LiveRebelXml.join(string, string2, string3), string4);
    }

    private static String join(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string2 != null) {
            stringBuffer.append("-").append(string2);
        }
        if (string3 != null) {
            stringBuffer.append("-").append(string3);
        }
        return stringBuffer.toString();
    }

    private static void expectName(ap ap2, String string) {
        if (!string.equals(ap2.b())) {
            throw new IllegalArgumentException("Element '" + string + "' expected instead of '" + ap2.b() + "'.");
        }
    }

    private static void expectElementFound(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Element '" + string2 + "' expected but not found.");
        }
    }

    public String toString() {
        return this.versionId == null ? this.applicationId : this.applicationId + "-" + this.versionId;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.applicationId == null ? 0 : this.applicationId.hashCode());
        n3 = 31 * n3 + (this.versionId == null ? 0 : this.versionId.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LiveRebelXml liveRebelXml = (LiveRebelXml)object;
        if (this.applicationId == null ? liveRebelXml.applicationId != null : !this.applicationId.equals(liveRebelXml.applicationId)) {
            return false;
        }
        return !(this.versionId == null ? liveRebelXml.versionId != null : !this.versionId.equals(liveRebelXml.versionId));
    }
}

