/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;
import org.zeroturnaround.bundled.javassist.bytecode.ExceptionTable;
import org.zeroturnaround.bundled.javassist.bytecode.Opcode;

class CodeAnalyzer
implements Opcode {
    private ConstPool constPool;
    private CodeAttribute codeAttr;

    public CodeAnalyzer(CodeAttribute codeAttribute) {
        this.codeAttr = codeAttribute;
        this.constPool = codeAttribute.getConstPool();
    }

    public int computeMaxStack() throws BadBytecode {
        int n2;
        boolean bl2;
        CodeIterator codeIterator = this.codeAttr.iterator();
        int n3 = codeIterator.getCodeLength();
        int[] nArray = new int[n3];
        this.constPool = this.codeAttr.getConstPool();
        this.initStack(nArray, this.codeAttr);
        do {
            bl2 = false;
            for (n2 = 0; n2 < n3; ++n2) {
                if (nArray[n2] >= 0) continue;
                bl2 = true;
                this.visitBytecode(codeIterator, nArray, n2);
            }
        } while (bl2);
        n2 = 1;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (nArray[i2] <= n2) continue;
            n2 = nArray[i2];
        }
        return n2 - 1;
    }

    private void initStack(int[] nArray, CodeAttribute codeAttribute) {
        nArray[0] = -1;
        ExceptionTable exceptionTable = codeAttribute.getExceptionTable();
        if (exceptionTable != null) {
            int n2 = exceptionTable.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[exceptionTable.handlerPc((int)i2)] = -2;
            }
        }
    }

    private void visitBytecode(CodeIterator codeIterator, int[] nArray, int n2) throws BadBytecode {
        int n3 = nArray.length;
        codeIterator.move(n2);
        int n4 = -nArray[n2];
        int[] nArray2 = new int[]{-1};
        while (codeIterator.hasNext()) {
            n2 = codeIterator.next();
            nArray[n2] = n4;
            int n5 = codeIterator.byteAt(n2);
            n4 = this.visitInst(n5, codeIterator, n2, n4);
            if (n4 < 1) {
                throw new BadBytecode("stack underflow at " + n2);
            }
            if (this.processBranch(n5, codeIterator, n2, n3, nArray, n4, nArray2) || CodeAnalyzer.isEnd(n5)) break;
            if (n5 != 168 && n5 != 201) continue;
            --n4;
        }
    }

    private boolean processBranch(int n2, CodeIterator codeIterator, int n3, int n4, int[] nArray, int n5, int[] nArray2) throws BadBytecode {
        if (153 <= n2 && n2 <= 166 || n2 == 198 || n2 == 199) {
            int n6 = n3 + codeIterator.s16bitAt(n3 + 1);
            this.checkTarget(n3, n6, n4, nArray, n5);
        } else {
            switch (n2) {
                case 167: {
                    int n7 = n3 + codeIterator.s16bitAt(n3 + 1);
                    this.checkTarget(n3, n7, n4, nArray, n5);
                    return true;
                }
                case 200: {
                    int n8 = n3 + codeIterator.s32bitAt(n3 + 1);
                    this.checkTarget(n3, n8, n4, nArray, n5);
                    return true;
                }
                case 168: 
                case 201: {
                    int n9 = n2 == 168 ? n3 + codeIterator.s16bitAt(n3 + 1) : n3 + codeIterator.s32bitAt(n3 + 1);
                    this.checkTarget(n3, n9, n4, nArray, n5);
                    if (nArray2[0] < 0) {
                        nArray2[0] = n5;
                        return false;
                    }
                    if (n5 == nArray2[0]) {
                        return false;
                    }
                    throw new BadBytecode("sorry, cannot compute this data flow due to JSR: " + n5 + "," + nArray2[0]);
                }
                case 169: {
                    if (nArray2[0] < 0) {
                        nArray2[0] = n5 + 1;
                        return false;
                    }
                    if (n5 + 1 == nArray2[0]) {
                        return true;
                    }
                    throw new BadBytecode("sorry, cannot compute this data flow due to RET: " + n5 + "," + nArray2[0]);
                }
                case 170: 
                case 171: {
                    int n10 = (n3 & 0xFFFFFFFC) + 4;
                    int n11 = n3 + codeIterator.s32bitAt(n10);
                    this.checkTarget(n3, n11, n4, nArray, n5);
                    if (n2 == 171) {
                        int n12 = codeIterator.s32bitAt(n10 + 4);
                        n10 += 12;
                        for (int i2 = 0; i2 < n12; ++i2) {
                            n11 = n3 + codeIterator.s32bitAt(n10);
                            this.checkTarget(n3, n11, n4, nArray, n5);
                            n10 += 8;
                        }
                    } else {
                        int n13 = codeIterator.s32bitAt(n10 + 4);
                        int n14 = codeIterator.s32bitAt(n10 + 8);
                        int n15 = n14 - n13 + 1;
                        n10 += 12;
                        for (int i3 = 0; i3 < n15; ++i3) {
                            n11 = n3 + codeIterator.s32bitAt(n10);
                            this.checkTarget(n3, n11, n4, nArray, n5);
                            n10 += 4;
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private void checkTarget(int n2, int n3, int n4, int[] nArray, int n5) throws BadBytecode {
        if (n3 < 0 || n4 <= n3) {
            throw new BadBytecode("bad branch offset at " + n2);
        }
        int n6 = nArray[n3];
        if (n6 == 0) {
            nArray[n3] = -n5;
        } else if (n6 != n5 && n6 != -n5) {
            throw new BadBytecode("verification error (" + n5 + "," + n6 + ") at " + n2);
        }
    }

    private static boolean isEnd(int n2) {
        return 172 <= n2 && n2 <= 177 || n2 == 191;
    }

    private int visitInst(int n2, CodeIterator codeIterator, int n3, int n4) throws BadBytecode {
        switch (n2) {
            case 180: {
                n4 += this.getFieldSize(codeIterator, n3) - 1;
                break;
            }
            case 181: {
                n4 -= this.getFieldSize(codeIterator, n3) + 1;
                break;
            }
            case 178: {
                n4 += this.getFieldSize(codeIterator, n3);
                break;
            }
            case 179: {
                n4 -= this.getFieldSize(codeIterator, n3);
                break;
            }
            case 182: 
            case 183: {
                String string = this.constPool.getMethodrefType(codeIterator.u16bitAt(n3 + 1));
                n4 += Descriptor.dataSize(string) - 1;
                break;
            }
            case 184: {
                String string = this.constPool.getMethodrefType(codeIterator.u16bitAt(n3 + 1));
                n4 += Descriptor.dataSize(string);
                break;
            }
            case 185: {
                String string = this.constPool.getInterfaceMethodrefType(codeIterator.u16bitAt(n3 + 1));
                n4 += Descriptor.dataSize(string) - 1;
                break;
            }
            case 186: {
                String string = this.constPool.getInvokeDynamicType(codeIterator.u16bitAt(n3 + 1));
                n4 += Descriptor.dataSize(string);
                break;
            }
            case 191: {
                n4 = 1;
                break;
            }
            case 197: {
                n4 += 1 - codeIterator.byteAt(n3 + 3);
                break;
            }
            case 196: {
                n2 = codeIterator.byteAt(n3 + 1);
            }
            default: {
                n4 += STACK_GROW[n2];
            }
        }
        return n4;
    }

    private int getFieldSize(CodeIterator codeIterator, int n2) {
        String string = this.constPool.getFieldrefType(codeIterator.u16bitAt(n2 + 1));
        return Descriptor.dataSize(string);
    }
}

