/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import org.zeroturnaround.bundled.javassist.bytecode.AttributeInfo;
import org.zeroturnaround.bundled.javassist.bytecode.ByteArray;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.LineNumberAttribute$Pc;

public class LineNumberAttribute
extends AttributeInfo {
    public static final String tag = "LineNumberTable";

    LineNumberAttribute(ConstPool constPool, int n2, DataInputStream dataInputStream) throws IOException {
        super(constPool, n2, dataInputStream);
    }

    private LineNumberAttribute(ConstPool constPool, byte[] byArray) {
        super(constPool, tag, byArray);
    }

    public int tableLength() {
        return ByteArray.readU16bit(this.info, 0);
    }

    public int startPc(int n2) {
        return ByteArray.readU16bit(this.info, n2 * 4 + 2);
    }

    public int lineNumber(int n2) {
        return ByteArray.readU16bit(this.info, n2 * 4 + 4);
    }

    public int toLineNumber(int n2) {
        int n3;
        int n4 = this.tableLength();
        for (n3 = 0; n3 < n4; ++n3) {
            if (n2 >= this.startPc(n3)) continue;
            if (n3 != 0) break;
            return this.lineNumber(0);
        }
        return this.lineNumber(n3 - 1);
    }

    public int toStartPc(int n2) {
        int n3 = this.tableLength();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (n2 != this.lineNumber(i2)) continue;
            return this.startPc(i2);
        }
        return -1;
    }

    public LineNumberAttribute$Pc toNearPc(int n2) {
        int n3 = this.tableLength();
        int n4 = 0;
        int n5 = 0;
        if (n3 > 0) {
            n5 = this.lineNumber(0) - n2;
            n4 = this.startPc(0);
        }
        for (int i2 = 1; i2 < n3; ++i2) {
            int n6 = this.lineNumber(i2) - n2;
            if ((n6 >= 0 || n6 <= n5) && (n6 < 0 || n6 >= n5 && n5 >= 0)) continue;
            n5 = n6;
            n4 = this.startPc(i2);
        }
        LineNumberAttribute$Pc lineNumberAttribute$Pc = new LineNumberAttribute$Pc();
        lineNumberAttribute$Pc.index = n4;
        lineNumberAttribute$Pc.line = n2 + n5;
        return lineNumberAttribute$Pc;
    }

    public AttributeInfo copy(ConstPool constPool, Map map) {
        byte[] byArray = this.info;
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray2[i2] = byArray[i2];
        }
        LineNumberAttribute lineNumberAttribute = new LineNumberAttribute(constPool, byArray2);
        return lineNumberAttribute;
    }

    void shiftPc(int n2, int n3, boolean bl2) {
        int n4 = this.tableLength();
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = i2 * 4 + 2;
            int n6 = ByteArray.readU16bit(this.info, n5);
            if (n6 <= n2 && (!bl2 || n6 != n2)) continue;
            ByteArray.write16bit(n6 + n3, this.info, n5);
        }
    }
}

