/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import org.zeroturnaround.bundled.javassist.bytecode.ConstInfo;

final class LongVector {
    static final int ASIZE = 128;
    static final int ABITS = 7;
    static final int VSIZE = 8;
    private ConstInfo[][] objects;
    private int elements;

    public LongVector() {
        this.objects = new ConstInfo[8][];
        this.elements = 0;
    }

    public LongVector(int n2) {
        int n3 = (n2 >> 7 & 0xFFFFFFF8) + 8;
        this.objects = new ConstInfo[n3][];
        this.elements = 0;
    }

    public int size() {
        return this.elements;
    }

    public int capacity() {
        return this.objects.length * 128;
    }

    public ConstInfo elementAt(int n2) {
        if (n2 < 0 || this.elements <= n2) {
            return null;
        }
        return this.objects[n2 >> 7][n2 & 0x7F];
    }

    public void addElement(ConstInfo constInfo) {
        int n2 = this.elements >> 7;
        int n3 = this.elements & 0x7F;
        int n4 = this.objects.length;
        if (n2 >= n4) {
            ConstInfo[][] constInfoArrayArray = new ConstInfo[n4 + 8][];
            System.arraycopy(this.objects, 0, constInfoArrayArray, 0, n4);
            this.objects = constInfoArrayArray;
        }
        if (this.objects[n2] == null) {
            this.objects[n2] = new ConstInfo[128];
        }
        this.objects[n2][n3] = constInfo;
        ++this.elements;
    }
}

