/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.zeroturnaround.bundled.javassist.bytecode.ConstInfo;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;

class MethodHandleInfo
extends ConstInfo {
    static final int tag = 15;
    int refKind;
    int refIndex;

    public MethodHandleInfo(int n2, int n3, int n4) {
        super(n4);
        this.refKind = n2;
        this.refIndex = n3;
    }

    public MethodHandleInfo(DataInputStream dataInputStream, int n2) throws IOException {
        super(n2);
        this.refKind = dataInputStream.readUnsignedByte();
        this.refIndex = dataInputStream.readUnsignedShort();
    }

    public int hashCode() {
        return this.refKind << 16 ^ this.refIndex;
    }

    public boolean equals(Object object) {
        if (object instanceof MethodHandleInfo) {
            MethodHandleInfo methodHandleInfo = (MethodHandleInfo)object;
            return methodHandleInfo.refKind == this.refKind && methodHandleInfo.refIndex == this.refIndex;
        }
        return false;
    }

    public int getTag() {
        return 15;
    }

    public int copy(ConstPool constPool, ConstPool constPool2, Map map) {
        return constPool2.addMethodHandleInfo(this.refKind, constPool.getItem(this.refIndex).copy(constPool, constPool2, map));
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(15);
        dataOutputStream.writeByte(this.refKind);
        dataOutputStream.writeShort(this.refIndex);
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("MethodHandle #");
        printWriter.print(this.refKind);
        printWriter.print(", index #");
        printWriter.println(this.refIndex);
    }
}

