/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Map;
import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.bytecode.AttributeInfo;
import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.StackMapTable$Copier;
import org.zeroturnaround.bundled.javassist.bytecode.StackMapTable$InsertLocal;
import org.zeroturnaround.bundled.javassist.bytecode.StackMapTable$NewRemover;
import org.zeroturnaround.bundled.javassist.bytecode.StackMapTable$OffsetShifter;
import org.zeroturnaround.bundled.javassist.bytecode.StackMapTable$Printer;
import org.zeroturnaround.bundled.javassist.bytecode.StackMapTable$RuntimeCopyException;
import org.zeroturnaround.bundled.javassist.bytecode.StackMapTable$Shifter;
import org.zeroturnaround.bundled.javassist.bytecode.StackMapTable$SwitchShifter;

public class StackMapTable
extends AttributeInfo {
    public static final String tag = "StackMapTable";
    public static final int TOP = 0;
    public static final int INTEGER = 1;
    public static final int FLOAT = 2;
    public static final int DOUBLE = 3;
    public static final int LONG = 4;
    public static final int NULL = 5;
    public static final int THIS = 6;
    public static final int OBJECT = 7;
    public static final int UNINIT = 8;

    StackMapTable(ConstPool constPool, byte[] byArray) {
        super(constPool, tag, byArray);
    }

    StackMapTable(ConstPool constPool, int n2, DataInputStream dataInputStream) throws IOException {
        super(constPool, n2, dataInputStream);
    }

    public AttributeInfo copy(ConstPool constPool, Map map) throws StackMapTable$RuntimeCopyException {
        try {
            return new StackMapTable(constPool, new StackMapTable$Copier(this.constPool, this.info, constPool, map).doit());
        }
        catch (BadBytecode badBytecode) {
            throw new StackMapTable$RuntimeCopyException("bad bytecode. fatal?");
        }
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
    }

    public void insertLocal(int n2, int n3, int n4) throws BadBytecode {
        byte[] byArray = new StackMapTable$InsertLocal(this.get(), n2, n3, n4).doit();
        this.set(byArray);
    }

    public static int typeTagOf(char c2) {
        switch (c2) {
            case 'D': {
                return 3;
            }
            case 'F': {
                return 2;
            }
            case 'J': {
                return 4;
            }
            case 'L': 
            case '[': {
                return 7;
            }
        }
        return 1;
    }

    public void println(PrintWriter printWriter) {
        StackMapTable$Printer.print(this, printWriter);
    }

    public void println(PrintStream printStream) {
        StackMapTable$Printer.print(this, new PrintWriter(printStream, true));
    }

    void shiftPc(int n2, int n3, boolean bl2) throws BadBytecode {
        new StackMapTable$OffsetShifter(this, n2, n3).parse();
        new StackMapTable$Shifter(this, n2, n3, bl2).doit();
    }

    void shiftForSwitch(int n2, int n3) throws BadBytecode {
        new StackMapTable$SwitchShifter(this, n2, n3).doit();
    }

    public void removeNew(int n2) throws CannotCompileException {
        try {
            byte[] byArray = new StackMapTable$NewRemover(this.get(), n2).doit();
            this.set(byArray);
        }
        catch (BadBytecode badBytecode) {
            throw new CannotCompileException("bad stack map table", badBytecode);
        }
    }
}

