/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode.analysis;

import java.util.Iterator;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;
import org.zeroturnaround.bundled.javassist.bytecode.ExceptionTable;
import org.zeroturnaround.bundled.javassist.bytecode.MethodInfo;
import org.zeroturnaround.bundled.javassist.bytecode.Opcode;
import org.zeroturnaround.bundled.javassist.bytecode.analysis.Analyzer$ExceptionInfo;
import org.zeroturnaround.bundled.javassist.bytecode.analysis.Executor;
import org.zeroturnaround.bundled.javassist.bytecode.analysis.Frame;
import org.zeroturnaround.bundled.javassist.bytecode.analysis.IntQueue;
import org.zeroturnaround.bundled.javassist.bytecode.analysis.Subroutine;
import org.zeroturnaround.bundled.javassist.bytecode.analysis.SubroutineScanner;
import org.zeroturnaround.bundled.javassist.bytecode.analysis.Type;
import org.zeroturnaround.bundled.javassist.bytecode.analysis.Util;

public class Analyzer
implements Opcode {
    private final SubroutineScanner scanner = new SubroutineScanner();
    private CtClass clazz;
    private Analyzer$ExceptionInfo[] exceptions;
    private Frame[] frames;
    private Subroutine[] subroutines;

    public Frame[] analyze(CtClass ctClass, MethodInfo methodInfo) throws BadBytecode {
        this.clazz = ctClass;
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        if (codeAttribute == null) {
            return null;
        }
        int n2 = codeAttribute.getMaxLocals();
        int n3 = codeAttribute.getMaxStack();
        int n4 = codeAttribute.getCodeLength();
        CodeIterator codeIterator = codeAttribute.iterator();
        IntQueue intQueue = new IntQueue();
        this.exceptions = this.buildExceptionInfo(methodInfo);
        this.subroutines = this.scanner.scan(methodInfo);
        Executor executor = new Executor(ctClass.getClassPool(), methodInfo.getConstPool());
        this.frames = new Frame[n4];
        this.frames[codeIterator.lookAhead()] = this.firstFrame(methodInfo, n2, n3);
        intQueue.add(codeIterator.next());
        while (!intQueue.isEmpty()) {
            this.analyzeNextEntry(methodInfo, codeIterator, intQueue, executor);
        }
        return this.frames;
    }

    public Frame[] analyze(CtMethod ctMethod) throws BadBytecode {
        return this.analyze(ctMethod.getDeclaringClass(), ctMethod.getMethodInfo2());
    }

    private void analyzeNextEntry(MethodInfo methodInfo, CodeIterator codeIterator, IntQueue intQueue, Executor executor) throws BadBytecode {
        int n2 = intQueue.take();
        codeIterator.move(n2);
        codeIterator.next();
        Frame frame = this.frames[n2].copy();
        Subroutine subroutine = this.subroutines[n2];
        try {
            executor.execute(methodInfo, n2, codeIterator, frame, subroutine);
        }
        catch (RuntimeException runtimeException) {
            throw new BadBytecode(runtimeException.getMessage() + "[pos = " + n2 + "]", (Throwable)runtimeException);
        }
        int n3 = codeIterator.byteAt(n2);
        if (n3 == 170) {
            this.mergeTableSwitch(intQueue, n2, codeIterator, frame);
        } else if (n3 == 171) {
            this.mergeLookupSwitch(intQueue, n2, codeIterator, frame);
        } else if (n3 == 169) {
            this.mergeRet(intQueue, codeIterator, n2, frame, subroutine);
        } else if (Util.isJumpInstruction(n3)) {
            int n4 = Util.getJumpTarget(n2, codeIterator);
            if (Util.isJsr(n3)) {
                this.mergeJsr(intQueue, this.frames[n2], this.subroutines[n4], n2, this.lookAhead(codeIterator, n2));
            } else if (!Util.isGoto(n3)) {
                this.merge(intQueue, frame, this.lookAhead(codeIterator, n2));
            }
            this.merge(intQueue, frame, n4);
        } else if (n3 != 191 && !Util.isReturn(n3)) {
            this.merge(intQueue, frame, this.lookAhead(codeIterator, n2));
        }
        this.mergeExceptionHandlers(intQueue, methodInfo, n2, frame);
    }

    private Analyzer$ExceptionInfo[] buildExceptionInfo(MethodInfo methodInfo) {
        ConstPool constPool = methodInfo.getConstPool();
        ClassPool classPool = this.clazz.getClassPool();
        ExceptionTable exceptionTable = methodInfo.getCodeAttribute().getExceptionTable();
        Analyzer$ExceptionInfo[] analyzer$ExceptionInfoArray = new Analyzer$ExceptionInfo[exceptionTable.size()];
        for (int i2 = 0; i2 < exceptionTable.size(); ++i2) {
            Type type;
            int n2 = exceptionTable.catchType(i2);
            try {
                type = n2 == 0 ? Type.THROWABLE : Type.get(classPool.get(constPool.getClassInfo(n2)));
            }
            catch (NotFoundException notFoundException) {
                throw new IllegalStateException(notFoundException.getMessage());
            }
            analyzer$ExceptionInfoArray[i2] = new Analyzer$ExceptionInfo(exceptionTable.startPc(i2), exceptionTable.endPc(i2), exceptionTable.handlerPc(i2), type, null);
        }
        return analyzer$ExceptionInfoArray;
    }

    private Frame firstFrame(MethodInfo methodInfo, int n2, int n3) {
        CtClass[] ctClassArray;
        int n4 = 0;
        Frame frame = new Frame(n2, n3);
        if ((methodInfo.getAccessFlags() & 8) == 0) {
            frame.setLocal(n4++, Type.get(this.clazz));
        }
        try {
            ctClassArray = Descriptor.getParameterTypes(methodInfo.getDescriptor(), this.clazz.getClassPool());
        }
        catch (NotFoundException notFoundException) {
            throw new RuntimeException(notFoundException);
        }
        for (int i2 = 0; i2 < ctClassArray.length; ++i2) {
            Type type = this.zeroExtend(Type.get(ctClassArray[i2]));
            frame.setLocal(n4++, type);
            if (type.getSize() != 2) continue;
            frame.setLocal(n4++, Type.TOP);
        }
        return frame;
    }

    private int getNext(CodeIterator codeIterator, int n2, int n3) throws BadBytecode {
        codeIterator.move(n2);
        codeIterator.next();
        int n4 = codeIterator.lookAhead();
        codeIterator.move(n3);
        codeIterator.next();
        return n4;
    }

    private int lookAhead(CodeIterator codeIterator, int n2) throws BadBytecode {
        if (!codeIterator.hasNext()) {
            throw new BadBytecode("Execution falls off end! [pos = " + n2 + "]");
        }
        return codeIterator.lookAhead();
    }

    private void merge(IntQueue intQueue, Frame frame, int n2) {
        boolean bl2;
        Frame frame2 = this.frames[n2];
        if (frame2 == null) {
            this.frames[n2] = frame.copy();
            bl2 = true;
        } else {
            bl2 = frame2.merge(frame);
        }
        if (bl2) {
            intQueue.add(n2);
        }
    }

    private void mergeExceptionHandlers(IntQueue intQueue, MethodInfo methodInfo, int n2, Frame frame) {
        for (int i2 = 0; i2 < this.exceptions.length; ++i2) {
            Analyzer$ExceptionInfo analyzer$ExceptionInfo = this.exceptions[i2];
            if (n2 < Analyzer$ExceptionInfo.access$100(analyzer$ExceptionInfo) || n2 >= Analyzer$ExceptionInfo.access$200(analyzer$ExceptionInfo)) continue;
            Frame frame2 = frame.copy();
            frame2.clearStack();
            frame2.push(Analyzer$ExceptionInfo.access$300(analyzer$ExceptionInfo));
            this.merge(intQueue, frame2, Analyzer$ExceptionInfo.access$400(analyzer$ExceptionInfo));
        }
    }

    private void mergeJsr(IntQueue intQueue, Frame frame, Subroutine subroutine, int n2, int n3) throws BadBytecode {
        if (subroutine == null) {
            throw new BadBytecode("No subroutine at jsr target! [pos = " + n2 + "]");
        }
        Frame frame2 = this.frames[n3];
        boolean bl2 = false;
        if (frame2 == null) {
            frame2 = this.frames[n3] = frame.copy();
            bl2 = true;
        } else {
            for (int i2 = 0; i2 < frame.localsLength(); ++i2) {
                if (subroutine.isAccessed(i2)) continue;
                Type type = frame2.getLocal(i2);
                Type type2 = frame.getLocal(i2);
                if (type == null) {
                    frame2.setLocal(i2, type2);
                    bl2 = true;
                    continue;
                }
                type2 = type.merge(type2);
                frame2.setLocal(i2, type2);
                if (type2.equals(type) && !type2.popChanged()) continue;
                bl2 = true;
            }
        }
        if (!frame2.isJsrMerged()) {
            frame2.setJsrMerged(true);
            bl2 = true;
        }
        if (bl2 && frame2.isRetMerged()) {
            intQueue.add(n3);
        }
    }

    private void mergeLookupSwitch(IntQueue intQueue, int n2, CodeIterator codeIterator, Frame frame) throws BadBytecode {
        int n3 = (n2 & 0xFFFFFFFC) + 4;
        this.merge(intQueue, frame, n2 + codeIterator.s32bitAt(n3));
        int n4 = codeIterator.s32bitAt(n3 += 4);
        int n5 = n4 * 8 + (n3 += 4);
        n3 += 4;
        while (n3 < n5) {
            int n6 = codeIterator.s32bitAt(n3) + n2;
            this.merge(intQueue, frame, n6);
            n3 += 8;
        }
    }

    private void mergeRet(IntQueue intQueue, CodeIterator codeIterator, int n2, Frame frame, Subroutine subroutine) throws BadBytecode {
        if (subroutine == null) {
            throw new BadBytecode("Ret on no subroutine! [pos = " + n2 + "]");
        }
        Iterator iterator = subroutine.callers().iterator();
        while (iterator.hasNext()) {
            int n3 = (Integer)iterator.next();
            int n4 = this.getNext(codeIterator, n3, n2);
            boolean bl2 = false;
            Frame frame2 = this.frames[n4];
            if (frame2 == null) {
                frame2 = this.frames[n4] = frame.copyStack();
                bl2 = true;
            } else {
                bl2 = frame2.mergeStack(frame);
            }
            Iterator iterator2 = subroutine.accessed().iterator();
            while (iterator2.hasNext()) {
                Type type;
                int n5 = (Integer)iterator2.next();
                Type type2 = frame2.getLocal(n5);
                if (type2 == (type = frame.getLocal(n5))) continue;
                frame2.setLocal(n5, type);
                bl2 = true;
            }
            if (!frame2.isRetMerged()) {
                frame2.setRetMerged(true);
                bl2 = true;
            }
            if (!bl2 || !frame2.isJsrMerged()) continue;
            intQueue.add(n4);
        }
    }

    private void mergeTableSwitch(IntQueue intQueue, int n2, CodeIterator codeIterator, Frame frame) throws BadBytecode {
        int n3 = (n2 & 0xFFFFFFFC) + 4;
        this.merge(intQueue, frame, n2 + codeIterator.s32bitAt(n3));
        int n4 = codeIterator.s32bitAt(n3 += 4);
        int n5 = codeIterator.s32bitAt(n3 += 4);
        int n6 = (n5 - n4 + 1) * 4 + (n3 += 4);
        while (n3 < n6) {
            int n7 = codeIterator.s32bitAt(n3) + n2;
            this.merge(intQueue, frame, n7);
            n3 += 4;
        }
    }

    private Type zeroExtend(Type type) {
        if (type == Type.SHORT || type == Type.BYTE || type == Type.CHAR || type == Type.BOOLEAN) {
            return Type.INTEGER;
        }
        return type;
    }
}

