/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode.analysis;

import java.io.PrintStream;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.Modifier;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;
import org.zeroturnaround.bundled.javassist.bytecode.InstructionPrinter;
import org.zeroturnaround.bundled.javassist.bytecode.MethodInfo;
import org.zeroturnaround.bundled.javassist.bytecode.analysis.Analyzer;
import org.zeroturnaround.bundled.javassist.bytecode.analysis.Frame;
import org.zeroturnaround.bundled.javassist.bytecode.analysis.Type;

public final class FramePrinter {
    private final PrintStream stream;

    public FramePrinter(PrintStream printStream) {
        this.stream = printStream;
    }

    public static void print(CtClass ctClass, PrintStream printStream) {
        new FramePrinter(printStream).print(ctClass);
    }

    public void print(CtClass ctClass) {
        CtMethod[] ctMethodArray = ctClass.getDeclaredMethods();
        for (int i2 = 0; i2 < ctMethodArray.length; ++i2) {
            this.print(ctMethodArray[i2]);
        }
    }

    private String getMethodString(CtMethod ctMethod) {
        try {
            return Modifier.toString(ctMethod.getModifiers()) + " " + ctMethod.getReturnType().getName() + " " + ctMethod.getName() + Descriptor.toString(ctMethod.getSignature()) + ";";
        }
        catch (NotFoundException notFoundException) {
            throw new RuntimeException(notFoundException);
        }
    }

    public void print(CtMethod ctMethod) {
        Frame[] frameArray;
        this.stream.println("\n" + this.getMethodString(ctMethod));
        MethodInfo methodInfo = ctMethod.getMethodInfo2();
        ConstPool constPool = methodInfo.getConstPool();
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        if (codeAttribute == null) {
            return;
        }
        try {
            frameArray = new Analyzer().analyze(ctMethod.getDeclaringClass(), methodInfo);
        }
        catch (BadBytecode badBytecode) {
            throw new RuntimeException(badBytecode);
        }
        int n2 = String.valueOf(codeAttribute.getCodeLength()).length();
        CodeIterator codeIterator = codeAttribute.iterator();
        while (codeIterator.hasNext()) {
            int n3;
            try {
                n3 = codeIterator.next();
            }
            catch (BadBytecode badBytecode) {
                throw new RuntimeException(badBytecode);
            }
            this.stream.println(n3 + ": " + InstructionPrinter.instructionString(codeIterator, n3, constPool));
            this.addSpacing(n2 + 3);
            Frame frame = frameArray[n3];
            if (frame == null) {
                this.stream.println("--DEAD CODE--");
                continue;
            }
            this.printStack(frame);
            this.addSpacing(n2 + 3);
            this.printLocals(frame);
        }
    }

    private void printStack(Frame frame) {
        this.stream.print("stack [");
        int n2 = frame.getTopIndex();
        for (int i2 = 0; i2 <= n2; ++i2) {
            if (i2 > 0) {
                this.stream.print(", ");
            }
            Type type = frame.getStack(i2);
            this.stream.print(type);
        }
        this.stream.println("]");
    }

    private void printLocals(Frame frame) {
        this.stream.print("locals [");
        int n2 = frame.localsLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Type type;
            if (i2 > 0) {
                this.stream.print(", ");
            }
            this.stream.print((type = frame.getLocal(i2)) == null ? "empty" : type.toString());
        }
        this.stream.println("]");
    }

    private void addSpacing(int n2) {
        while (n2-- > 0) {
            this.stream.print(' ');
        }
    }
}

