/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode.annotation;

import java.io.IOException;
import java.lang.reflect.Method;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.AnnotationsWriter;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.MemberValue;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.MemberValueVisitor;

public class BooleanMemberValue
extends MemberValue {
    int valueIndex;

    public BooleanMemberValue(int n2, ConstPool constPool) {
        super('Z', constPool);
        this.valueIndex = n2;
    }

    public BooleanMemberValue(boolean bl2, ConstPool constPool) {
        super('Z', constPool);
        this.setValue(bl2);
    }

    public BooleanMemberValue(ConstPool constPool) {
        super('Z', constPool);
        this.setValue(false);
    }

    Object getValue(ClassLoader classLoader, ClassPool classPool, Method method) {
        return new Boolean(this.getValue());
    }

    Class getType(ClassLoader classLoader) {
        return Boolean.TYPE;
    }

    public boolean getValue() {
        return this.cp.getIntegerInfo(this.valueIndex) != 0;
    }

    public void setValue(boolean bl2) {
        this.valueIndex = this.cp.addIntegerInfo(bl2 ? 1 : 0);
    }

    public String toString() {
        return this.getValue() ? "true" : "false";
    }

    public void write(AnnotationsWriter annotationsWriter) throws IOException {
        annotationsWriter.constValueIndex(this.getValue());
    }

    public void accept(MemberValueVisitor memberValueVisitor) {
        memberValueVisitor.visitBooleanMemberValue(this);
    }
}

