/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode.annotation;

import java.io.IOException;
import java.lang.reflect.Method;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.AnnotationsWriter;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.MemberValue;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.MemberValueVisitor;

public class CharMemberValue
extends MemberValue {
    int valueIndex;

    public CharMemberValue(int n2, ConstPool constPool) {
        super('C', constPool);
        this.valueIndex = n2;
    }

    public CharMemberValue(char c2, ConstPool constPool) {
        super('C', constPool);
        this.setValue(c2);
    }

    public CharMemberValue(ConstPool constPool) {
        super('C', constPool);
        this.setValue('\u0000');
    }

    Object getValue(ClassLoader classLoader, ClassPool classPool, Method method) {
        return new Character(this.getValue());
    }

    Class getType(ClassLoader classLoader) {
        return Character.TYPE;
    }

    public char getValue() {
        return (char)this.cp.getIntegerInfo(this.valueIndex);
    }

    public void setValue(char c2) {
        this.valueIndex = this.cp.addIntegerInfo(c2);
    }

    public String toString() {
        return Character.toString(this.getValue());
    }

    public void write(AnnotationsWriter annotationsWriter) throws IOException {
        annotationsWriter.constValueIndex(this.getValue());
    }

    public void accept(MemberValueVisitor memberValueVisitor) {
        memberValueVisitor.visitCharMemberValue(this);
    }
}

