/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode.annotation;

import java.io.IOException;
import java.lang.reflect.Method;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.AnnotationsWriter;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.MemberValueVisitor;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.NoSuchClassError;

public abstract class MemberValue {
    ConstPool cp;
    char tag;

    MemberValue(char c2, ConstPool constPool) {
        this.cp = constPool;
        this.tag = c2;
    }

    abstract Object getValue(ClassLoader var1, ClassPool var2, Method var3) throws ClassNotFoundException;

    abstract Class getType(ClassLoader var1) throws ClassNotFoundException;

    static Class loadClass(ClassLoader classLoader, String string) throws ClassNotFoundException, NoSuchClassError {
        try {
            return Class.forName(MemberValue.convertFromArray(string), true, classLoader);
        }
        catch (LinkageError linkageError) {
            throw new NoSuchClassError(string, linkageError);
        }
    }

    private static String convertFromArray(String string) {
        int n2 = string.indexOf("[]");
        if (n2 != -1) {
            String string2 = string.substring(0, n2);
            StringBuffer stringBuffer = new StringBuffer(Descriptor.of(string2));
            while (n2 != -1) {
                stringBuffer.insert(0, "[");
                n2 = string.indexOf("[]", n2 + 1);
            }
            return stringBuffer.toString().replace('/', '.');
        }
        return string;
    }

    public abstract void accept(MemberValueVisitor var1);

    public abstract void write(AnnotationsWriter var1) throws IOException;
}

