/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode.stackmap;

import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.BasicBlock$Catch;

public class BasicBlock {
    protected int position;
    protected int length;
    protected int incoming;
    protected BasicBlock[] exit;
    protected boolean stop;
    protected BasicBlock$Catch toCatch;

    protected BasicBlock(int n2) {
        this.position = n2;
        this.length = 0;
        this.incoming = 0;
    }

    public static BasicBlock find(BasicBlock[] basicBlockArray, int n2) throws BadBytecode {
        for (int i2 = 0; i2 < basicBlockArray.length; ++i2) {
            int n3 = basicBlockArray[i2].position;
            if (n3 > n2 || n2 >= n3 + basicBlockArray[i2].length) continue;
            return basicBlockArray[i2];
        }
        throw new BadBytecode("no basic block at " + n2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getClass().getName();
        int n2 = string.lastIndexOf(46);
        stringBuffer.append(n2 < 0 ? string : string.substring(n2 + 1));
        stringBuffer.append("[");
        this.toString2(stringBuffer);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected void toString2(StringBuffer stringBuffer) {
        stringBuffer.append("pos=").append(this.position).append(", len=").append(this.length).append(", in=").append(this.incoming).append(", exit{");
        if (this.exit != null) {
            for (int i2 = 0; i2 < this.exit.length; ++i2) {
                stringBuffer.append(this.exit[i2].position).append(",");
            }
        }
        stringBuffer.append("}, {");
        BasicBlock$Catch basicBlock$Catch = this.toCatch;
        while (basicBlock$Catch != null) {
            stringBuffer.append("(").append(basicBlock$Catch.body.position).append(", ").append(basicBlock$Catch.typeIndex).append("), ");
            basicBlock$Catch = basicBlock$Catch.next;
        }
        stringBuffer.append("}");
    }
}

