/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode.stackmap;

import java.util.ArrayList;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.ByteArray;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.MethodInfo;
import org.zeroturnaround.bundled.javassist.bytecode.StackMap;
import org.zeroturnaround.bundled.javassist.bytecode.StackMap$Writer;
import org.zeroturnaround.bundled.javassist.bytecode.StackMapTable;
import org.zeroturnaround.bundled.javassist.bytecode.StackMapTable$Writer;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.BasicBlock$Catch;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.BasicBlock$JsrBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.Tracer;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.TypeData;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.TypeData$AbsTypeVar;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.TypeData$ClassName;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.TypedBlock;

public class MapMaker
extends Tracer {
    public static StackMapTable make(ClassPool classPool, MethodInfo methodInfo) throws BadBytecode {
        TypedBlock[] typedBlockArray;
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        if (codeAttribute == null) {
            return null;
        }
        try {
            typedBlockArray = TypedBlock.makeBlocks(methodInfo, codeAttribute, true);
        }
        catch (BasicBlock$JsrBytecode basicBlock$JsrBytecode) {
            return null;
        }
        if (typedBlockArray == null) {
            return null;
        }
        MapMaker mapMaker = new MapMaker(classPool, methodInfo, codeAttribute);
        try {
            mapMaker.make(typedBlockArray, codeAttribute.getCode());
        }
        catch (BadBytecode badBytecode) {
            throw new BadBytecode(methodInfo, (Throwable)badBytecode);
        }
        return mapMaker.toStackMap(typedBlockArray);
    }

    public static StackMap make2(ClassPool classPool, MethodInfo methodInfo) throws BadBytecode {
        TypedBlock[] typedBlockArray;
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        if (codeAttribute == null) {
            return null;
        }
        try {
            typedBlockArray = TypedBlock.makeBlocks(methodInfo, codeAttribute, true);
        }
        catch (BasicBlock$JsrBytecode basicBlock$JsrBytecode) {
            return null;
        }
        if (typedBlockArray == null) {
            return null;
        }
        MapMaker mapMaker = new MapMaker(classPool, methodInfo, codeAttribute);
        try {
            mapMaker.make(typedBlockArray, codeAttribute.getCode());
        }
        catch (BadBytecode badBytecode) {
            throw new BadBytecode(methodInfo, (Throwable)badBytecode);
        }
        return mapMaker.toStackMap2(methodInfo.getConstPool(), typedBlockArray);
    }

    public MapMaker(ClassPool classPool, MethodInfo methodInfo, CodeAttribute codeAttribute) {
        super(classPool, methodInfo.getConstPool(), codeAttribute.getMaxStack(), codeAttribute.getMaxLocals(), TypedBlock.getRetType(methodInfo.getDescriptor()));
    }

    protected MapMaker(MapMaker mapMaker) {
        super(mapMaker);
    }

    void make(TypedBlock[] typedBlockArray, byte[] byArray) throws BadBytecode {
        this.make(byArray, typedBlockArray[0]);
        this.findDeadCatchers(byArray, typedBlockArray);
        try {
            this.fixTypes(byArray, typedBlockArray);
        }
        catch (NotFoundException notFoundException) {
            throw new BadBytecode("failed to resolve types", (Throwable)notFoundException);
        }
    }

    private void make(byte[] byArray, TypedBlock typedBlock) throws BadBytecode {
        int n2;
        MapMaker.copyTypeData(typedBlock.stackTop, typedBlock.stackTypes, this.stackTypes);
        this.stackTop = typedBlock.stackTop;
        MapMaker.copyTypeData(typedBlock.localsTypes.length, typedBlock.localsTypes, this.localsTypes);
        this.traceException(byArray, typedBlock.toCatch);
        int n3 = n2 + typedBlock.length;
        for (n2 = typedBlock.position; n2 < n3; n2 += this.doOpcode(n2, byArray)) {
        }
        this.traceException(byArray, typedBlock.toCatch);
        if (typedBlock.exit != null) {
            for (int i2 = 0; i2 < typedBlock.exit.length; ++i2) {
                TypedBlock typedBlock2 = (TypedBlock)typedBlock.exit[i2];
                if (typedBlock2.alreadySet()) {
                    this.mergeMap(typedBlock2, true);
                    continue;
                }
                this.recordStackMap(typedBlock2);
                MapMaker mapMaker = new MapMaker(this);
                mapMaker.make(byArray, typedBlock2);
            }
        }
    }

    private void traceException(byte[] byArray, BasicBlock$Catch basicBlock$Catch) throws BadBytecode {
        while (basicBlock$Catch != null) {
            TypedBlock typedBlock = (TypedBlock)basicBlock$Catch.body;
            if (typedBlock.alreadySet()) {
                this.mergeMap(typedBlock, false);
                if (typedBlock.stackTop < 1) {
                    throw new BadBytecode("bad catch clause: " + basicBlock$Catch.typeIndex);
                }
                typedBlock.stackTypes[0] = this.merge(this.toExceptionType(basicBlock$Catch.typeIndex), typedBlock.stackTypes[0]);
            } else {
                this.recordStackMap(typedBlock, basicBlock$Catch.typeIndex);
                MapMaker mapMaker = new MapMaker(this);
                mapMaker.make(byArray, typedBlock);
            }
            basicBlock$Catch = basicBlock$Catch.next;
        }
    }

    private void mergeMap(TypedBlock typedBlock, boolean bl2) throws BadBytecode {
        int n2;
        int n3 = this.localsTypes.length;
        for (n2 = 0; n2 < n3; ++n2) {
            typedBlock.localsTypes[n2] = this.merge(this.localsTypes[n2], typedBlock.localsTypes[n2]);
        }
        if (bl2) {
            n3 = this.stackTop;
            for (n2 = 0; n2 < n3; ++n2) {
                typedBlock.stackTypes[n2] = this.merge(this.stackTypes[n2], typedBlock.stackTypes[n2]);
            }
        }
    }

    private TypeData merge(TypeData typeData, TypeData typeData2) throws BadBytecode {
        if (typeData == typeData2) {
            return typeData2;
        }
        if (typeData2 instanceof TypeData$ClassName || typeData2 instanceof TypeData.BasicType) {
            return typeData2;
        }
        if (typeData2 instanceof TypeData$AbsTypeVar) {
            ((TypeData$AbsTypeVar)typeData2).merge(typeData);
            return typeData2;
        }
        throw new RuntimeException("fatal: this should never happen");
    }

    private void recordStackMap(TypedBlock typedBlock) throws BadBytecode {
        TypeData[] typeDataArray = TypeData.make(this.stackTypes.length);
        int n2 = this.stackTop;
        MapMaker.recordTypeData(n2, this.stackTypes, typeDataArray);
        this.recordStackMap0(typedBlock, n2, typeDataArray);
    }

    private void recordStackMap(TypedBlock typedBlock, int n2) throws BadBytecode {
        TypeData[] typeDataArray = TypeData.make(this.stackTypes.length);
        typeDataArray[0] = this.toExceptionType(n2).join();
        this.recordStackMap0(typedBlock, 1, typeDataArray);
    }

    private TypeData$ClassName toExceptionType(int n2) {
        String string = n2 == 0 ? "java.lang.Throwable" : this.cpool.getClassInfo(n2);
        return new TypeData$ClassName(string);
    }

    private void recordStackMap0(TypedBlock typedBlock, int n2, TypeData[] typeDataArray) throws BadBytecode {
        int n3 = this.localsTypes.length;
        TypeData[] typeDataArray2 = TypeData.make(n3);
        int n4 = MapMaker.recordTypeData(n3, this.localsTypes, typeDataArray2);
        typedBlock.setStackMap(n2, typeDataArray, n4, typeDataArray2);
    }

    protected static int recordTypeData(int n2, TypeData[] typeDataArray, TypeData[] typeDataArray2) {
        int n3 = -1;
        for (int i2 = 0; i2 < n2; ++i2) {
            TypeData typeData = typeDataArray[i2];
            typeDataArray2[i2] = typeData.join();
            if (typeData == TOP) continue;
            n3 = i2 + 1;
        }
        return n3 + 1;
    }

    protected static void copyTypeData(int n2, TypeData[] typeDataArray, TypeData[] typeDataArray2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            typeDataArray2[i2] = typeDataArray[i2];
        }
    }

    private void findDeadCatchers(byte[] byArray, TypedBlock[] typedBlockArray) throws BadBytecode {
        int n2 = typedBlockArray.length;
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            TypedBlock typedBlock = typedBlockArray[i2];
            if (typedBlock.localsTypes != null) continue;
            BasicBlock$Catch basicBlock$Catch = typedBlock.toCatch;
            while (basicBlock$Catch != null) {
                if (basicBlock$Catch.body == typedBlock) {
                    BasicBlock$Catch basicBlock$Catch2 = new BasicBlock$Catch(typedBlock, basicBlock$Catch.typeIndex, null);
                    this.traceException(byArray, basicBlock$Catch2);
                    continue block0;
                }
                basicBlock$Catch = basicBlock$Catch.next;
            }
        }
    }

    private void fixTypes(byte[] byArray, TypedBlock[] typedBlockArray) throws NotFoundException, BadBytecode {
        ArrayList arrayList = new ArrayList();
        int n2 = typedBlockArray.length;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4;
            TypedBlock typedBlock = typedBlockArray[i2];
            if (typedBlock.localsTypes == null) {
                this.fixDeadcode(byArray, typedBlock);
                continue;
            }
            int n5 = typedBlock.localsTypes.length;
            for (n4 = 0; n4 < n5; ++n4) {
                n3 = typedBlock.localsTypes[n4].dfs(arrayList, n3, this.classPool);
            }
            n5 = typedBlock.stackTop;
            for (n4 = 0; n4 < n5; ++n4) {
                n3 = typedBlock.stackTypes[n4].dfs(arrayList, n3, this.classPool);
            }
        }
    }

    private void fixDeadcode(byte[] byArray, TypedBlock typedBlock) throws BadBytecode {
        int n2 = typedBlock.position;
        int n3 = typedBlock.length - 3;
        if (n3 < 0) {
            throw new BadBytecode("dead code detected at " + n2 + ".  No stackmap table generated.");
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray[n2 + i2] = 0;
        }
        byArray[n2 + n3] = -89;
        ByteArray.write16bit(-n3, byArray, n2 + n3 + 1);
    }

    public StackMapTable toStackMap(TypedBlock[] typedBlockArray) {
        StackMapTable$Writer stackMapTable$Writer = new StackMapTable$Writer(32);
        int n2 = typedBlockArray.length;
        TypedBlock typedBlock = typedBlockArray[0];
        int n3 = typedBlock.length;
        if (typedBlock.incoming > 0) {
            stackMapTable$Writer.sameFrame(0);
            --n3;
        }
        for (int i2 = 1; i2 < n2; ++i2) {
            TypedBlock typedBlock2 = typedBlockArray[i2];
            if (this.isTarget(typedBlock2, typedBlockArray[i2 - 1])) {
                typedBlock2.resetNumLocals();
                int n4 = MapMaker.stackMapDiff(typedBlock.numLocals, typedBlock.localsTypes, typedBlock2.numLocals, typedBlock2.localsTypes);
                this.toStackMapBody(stackMapTable$Writer, typedBlock2, n4, n3, typedBlock);
                n3 = typedBlock2.length - 1;
                typedBlock = typedBlock2;
                continue;
            }
            if (typedBlock2.incoming == 0) {
                stackMapTable$Writer.sameFrame(n3);
                n3 = typedBlock2.length - 1;
                typedBlock = typedBlock2;
                continue;
            }
            n3 += typedBlock2.length;
        }
        return stackMapTable$Writer.toStackMapTable(this.cpool);
    }

    private boolean isTarget(TypedBlock typedBlock, TypedBlock typedBlock2) {
        int n2 = typedBlock.incoming;
        if (n2 > 1) {
            return true;
        }
        if (n2 < 1) {
            return false;
        }
        return typedBlock2.stop;
    }

    private void toStackMapBody(StackMapTable$Writer stackMapTable$Writer, TypedBlock typedBlock, int n2, int n3, TypedBlock typedBlock2) {
        Object object;
        int n4 = typedBlock.stackTop;
        if (n4 == 0) {
            if (n2 == 0) {
                stackMapTable$Writer.sameFrame(n3);
                return;
            }
            if (0 > n2 && n2 >= -3) {
                stackMapTable$Writer.chopFrame(n3, -n2);
                return;
            }
            if (0 < n2 && n2 <= 3) {
                int[] nArray = new int[n2];
                int[] nArray2 = this.fillStackMap(typedBlock.numLocals - typedBlock2.numLocals, typedBlock2.numLocals, nArray, typedBlock.localsTypes);
                stackMapTable$Writer.appendFrame(n3, nArray2, nArray);
                return;
            }
        } else {
            if (n4 == 1 && n2 == 0) {
                TypeData typeData = typedBlock.stackTypes[0];
                stackMapTable$Writer.sameLocals(n3, typeData.getTypeTag(), typeData.getTypeData(this.cpool));
                return;
            }
            if (n4 == 2 && n2 == 0 && ((TypeData)(object = (Object)typedBlock.stackTypes[0])).is2WordType()) {
                stackMapTable$Writer.sameLocals(n3, ((TypeData)object).getTypeTag(), ((TypeData)object).getTypeData(this.cpool));
                return;
            }
        }
        object = new int[n4];
        int[] nArray = this.fillStackMap(n4, 0, (int[])object, typedBlock.stackTypes);
        int[] nArray3 = new int[typedBlock.numLocals];
        int[] nArray4 = this.fillStackMap(typedBlock.numLocals, 0, nArray3, typedBlock.localsTypes);
        stackMapTable$Writer.fullFrame(n3, nArray4, nArray3, nArray, (int[])object);
    }

    private int[] fillStackMap(int n2, int n3, int[] nArray, TypeData[] typeDataArray) {
        int n4 = MapMaker.diffSize(typeDataArray, n3, n3 + n2);
        ConstPool constPool = this.cpool;
        int[] nArray2 = new int[n4];
        int n5 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            TypeData typeData = typeDataArray[n3 + i2];
            nArray2[n5] = typeData.getTypeTag();
            nArray[n5] = typeData.getTypeData(constPool);
            if (typeData.is2WordType()) {
                ++i2;
            }
            ++n5;
        }
        return nArray2;
    }

    private static int stackMapDiff(int n2, TypeData[] typeDataArray, int n3, TypeData[] typeDataArray2) {
        int n4 = n3 - n2;
        int n5 = n4 > 0 ? n2 : n3;
        if (MapMaker.stackMapEq(typeDataArray, typeDataArray2, n5)) {
            if (n4 > 0) {
                return MapMaker.diffSize(typeDataArray2, n5, n3);
            }
            return -MapMaker.diffSize(typeDataArray, n5, n2);
        }
        return -100;
    }

    private static boolean stackMapEq(TypeData[] typeDataArray, TypeData[] typeDataArray2, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (typeDataArray[i2].eq(typeDataArray2[i2])) continue;
            return false;
        }
        return true;
    }

    private static int diffSize(TypeData[] typeDataArray, int n2, int n3) {
        int n4 = 0;
        while (n2 < n3) {
            TypeData typeData = typeDataArray[n2++];
            ++n4;
            if (!typeData.is2WordType()) continue;
            ++n2;
        }
        return n4;
    }

    public StackMap toStackMap2(ConstPool constPool, TypedBlock[] typedBlockArray) {
        int n2;
        StackMap$Writer stackMap$Writer = new StackMap$Writer();
        int n3 = typedBlockArray.length;
        boolean[] blArray = new boolean[n3];
        TypedBlock typedBlock = typedBlockArray[0];
        blArray[0] = typedBlock.incoming > 0;
        int n4 = blArray[0] ? 1 : 0;
        for (n2 = 1; n2 < n3; ++n2) {
            TypedBlock typedBlock2 = typedBlockArray[n2];
            blArray[n2] = this.isTarget(typedBlock2, typedBlockArray[n2 - 1]);
            if (!blArray[n2]) continue;
            typedBlock2.resetNumLocals();
            typedBlock = typedBlock2;
            ++n4;
        }
        if (n4 == 0) {
            return null;
        }
        stackMap$Writer.write16bit(n4);
        for (n2 = 0; n2 < n3; ++n2) {
            if (!blArray[n2]) continue;
            this.writeStackFrame(stackMap$Writer, constPool, typedBlockArray[n2].position, typedBlockArray[n2]);
        }
        return stackMap$Writer.toStackMap(constPool);
    }

    private void writeStackFrame(StackMap$Writer stackMap$Writer, ConstPool constPool, int n2, TypedBlock typedBlock) {
        stackMap$Writer.write16bit(n2);
        this.writeVerifyTypeInfo(stackMap$Writer, constPool, typedBlock.localsTypes, typedBlock.numLocals);
        this.writeVerifyTypeInfo(stackMap$Writer, constPool, typedBlock.stackTypes, typedBlock.stackTop);
    }

    private void writeVerifyTypeInfo(StackMap$Writer stackMap$Writer, ConstPool constPool, TypeData[] typeDataArray, int n2) {
        TypeData typeData;
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            typeData = typeDataArray[n3];
            if (typeData == null || !typeData.is2WordType()) continue;
            ++n4;
            ++n3;
        }
        stackMap$Writer.write16bit(n2 - n4);
        for (n3 = 0; n3 < n2; ++n3) {
            typeData = typeDataArray[n3];
            stackMap$Writer.writeVerifyTypeInfo(typeData.getTypeTag(), typeData.getTypeData(constPool));
            if (!typeData.is2WordType()) continue;
            ++n3;
        }
    }
}

