/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.compiler;

import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtPrimitiveType;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.compiler.CodeGen;
import org.zeroturnaround.bundled.javassist.compiler.CompileError;
import org.zeroturnaround.bundled.javassist.compiler.JvstCodeGen;
import org.zeroturnaround.bundled.javassist.compiler.MemberResolver;
import org.zeroturnaround.bundled.javassist.compiler.TypeChecker;
import org.zeroturnaround.bundled.javassist.compiler.ast.ASTList;
import org.zeroturnaround.bundled.javassist.compiler.ast.ASTree;
import org.zeroturnaround.bundled.javassist.compiler.ast.CallExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.CastExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.Expr;
import org.zeroturnaround.bundled.javassist.compiler.ast.Member;
import org.zeroturnaround.bundled.javassist.compiler.ast.Symbol;

public class JvstTypeChecker
extends TypeChecker {
    private JvstCodeGen codeGen;

    public JvstTypeChecker(CtClass ctClass, ClassPool classPool, JvstCodeGen jvstCodeGen) {
        super(ctClass, classPool);
        this.codeGen = jvstCodeGen;
    }

    public void addNullIfVoid() {
        if (this.exprType == 344) {
            this.exprType = 307;
            this.arrayDim = 0;
            this.className = "java/lang/Object";
        }
    }

    public void atMember(Member member) throws CompileError {
        String string = member.get();
        if (string.equals(this.codeGen.paramArrayName)) {
            this.exprType = 307;
            this.arrayDim = 1;
            this.className = "java/lang/Object";
        } else if (string.equals("$sig")) {
            this.exprType = 307;
            this.arrayDim = 1;
            this.className = "java/lang/Class";
        } else if (string.equals("$type") || string.equals("$class")) {
            this.exprType = 307;
            this.arrayDim = 0;
            this.className = "java/lang/Class";
        } else {
            super.atMember(member);
        }
    }

    protected void atFieldAssign(Expr expr, int n2, ASTree aSTree, ASTree aSTree2) throws CompileError {
        if (aSTree instanceof Member && ((Member)aSTree).get().equals(this.codeGen.paramArrayName)) {
            aSTree2.accept(this);
            CtClass[] ctClassArray = this.codeGen.paramTypeList;
            if (ctClassArray == null) {
                return;
            }
            int n3 = ctClassArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                this.compileUnwrapValue(ctClassArray[i2]);
            }
        } else {
            super.atFieldAssign(expr, n2, aSTree, aSTree2);
        }
    }

    public void atCastExpr(CastExpr castExpr) throws CompileError {
        ASTree aSTree;
        ASTList aSTList = castExpr.getClassName();
        if (aSTList != null && castExpr.getArrayDim() == 0 && (aSTree = aSTList.head()) instanceof Symbol && aSTList.tail() == null) {
            String string = ((Symbol)aSTree).get();
            if (string.equals(this.codeGen.returnCastName)) {
                this.atCastToRtype(castExpr);
                return;
            }
            if (string.equals("$w")) {
                this.atCastToWrapper(castExpr);
                return;
            }
        }
        super.atCastExpr(castExpr);
    }

    protected void atCastToRtype(CastExpr castExpr) throws CompileError {
        CtClass ctClass = this.codeGen.returnType;
        castExpr.getOprand().accept(this);
        if (this.exprType == 344 || CodeGen.isRefType(this.exprType) || this.arrayDim > 0) {
            this.compileUnwrapValue(ctClass);
        } else if (ctClass instanceof CtPrimitiveType) {
            int n2;
            CtPrimitiveType ctPrimitiveType = (CtPrimitiveType)ctClass;
            this.exprType = n2 = MemberResolver.descToType(ctPrimitiveType.getDescriptor());
            this.arrayDim = 0;
            this.className = null;
        }
    }

    protected void atCastToWrapper(CastExpr castExpr) throws CompileError {
        castExpr.getOprand().accept(this);
        if (CodeGen.isRefType(this.exprType) || this.arrayDim > 0) {
            return;
        }
        CtClass ctClass = this.resolver.lookupClass(this.exprType, this.arrayDim, this.className);
        if (ctClass instanceof CtPrimitiveType) {
            this.exprType = 307;
            this.arrayDim = 0;
            this.className = "java/lang/Object";
        }
    }

    public void atCallExpr(CallExpr callExpr) throws CompileError {
        ASTree aSTree = callExpr.oprand1();
        if (aSTree instanceof Member) {
            String string = ((Member)aSTree).get();
            if (this.codeGen.procHandler != null && string.equals(this.codeGen.proceedName)) {
                this.codeGen.procHandler.setReturnType(this, (ASTList)callExpr.oprand2());
                return;
            }
            if (string.equals("$cflow")) {
                this.atCflow((ASTList)callExpr.oprand2());
                return;
            }
        }
        super.atCallExpr(callExpr);
    }

    protected void atCflow(ASTList aSTList) throws CompileError {
        this.exprType = 324;
        this.arrayDim = 0;
        this.className = null;
    }

    public boolean isParamListName(ASTList aSTList) {
        if (this.codeGen.paramTypeList != null && aSTList != null && aSTList.tail() == null) {
            ASTree aSTree = aSTList.head();
            return aSTree instanceof Member && ((Member)aSTree).get().equals(this.codeGen.paramListName);
        }
        return false;
    }

    public int getMethodArgsLength(ASTList aSTList) {
        String string = this.codeGen.paramListName;
        int n2 = 0;
        while (aSTList != null) {
            ASTree aSTree = aSTList.head();
            if (aSTree instanceof Member && ((Member)aSTree).get().equals(string)) {
                if (this.codeGen.paramTypeList != null) {
                    n2 += this.codeGen.paramTypeList.length;
                }
            } else {
                ++n2;
            }
            aSTList = aSTList.tail();
        }
        return n2;
    }

    public void atMethodArgs(ASTList aSTList, int[] nArray, int[] nArray2, String[] stringArray) throws CompileError {
        CtClass[] ctClassArray = this.codeGen.paramTypeList;
        String string = this.codeGen.paramListName;
        int n2 = 0;
        while (aSTList != null) {
            ASTree aSTree = aSTList.head();
            if (aSTree instanceof Member && ((Member)aSTree).get().equals(string)) {
                if (ctClassArray != null) {
                    int n3 = ctClassArray.length;
                    for (int i2 = 0; i2 < n3; ++i2) {
                        CtClass ctClass = ctClassArray[i2];
                        this.setType(ctClass);
                        nArray[n2] = this.exprType;
                        nArray2[n2] = this.arrayDim;
                        stringArray[n2] = this.className;
                        ++n2;
                    }
                }
            } else {
                aSTree.accept(this);
                nArray[n2] = this.exprType;
                nArray2[n2] = this.arrayDim;
                stringArray[n2] = this.className;
                ++n2;
            }
            aSTList = aSTList.tail();
        }
    }

    void compileInvokeSpecial(ASTree aSTree, String string, String string2, String string3, ASTList aSTList) throws CompileError {
        aSTree.accept(this);
        int n2 = this.getMethodArgsLength(aSTList);
        this.atMethodArgs(aSTList, new int[n2], new int[n2], new String[n2]);
        this.setReturnType(string3);
        this.addNullIfVoid();
    }

    protected void compileUnwrapValue(CtClass ctClass) throws CompileError {
        if (ctClass == CtClass.voidType) {
            this.addNullIfVoid();
        } else {
            this.setType(ctClass);
        }
    }

    public void setType(CtClass ctClass) throws CompileError {
        this.setType(ctClass, 0);
    }

    private void setType(CtClass ctClass, int n2) throws CompileError {
        if (ctClass.isPrimitive()) {
            CtPrimitiveType ctPrimitiveType = (CtPrimitiveType)ctClass;
            this.exprType = MemberResolver.descToType(ctPrimitiveType.getDescriptor());
            this.arrayDim = n2;
            this.className = null;
        } else if (ctClass.isArray()) {
            try {
                this.setType(ctClass.getComponentType(), n2 + 1);
            }
            catch (NotFoundException notFoundException) {
                throw new CompileError("undefined type: " + ctClass.getName());
            }
        } else {
            this.exprType = 307;
            this.arrayDim = n2;
            this.className = MemberResolver.javaToJvmName(ctClass.getName());
        }
    }
}

