/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.compiler;

import java.util.ArrayList;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtField;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.Modifier;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.AccessFlag;
import org.zeroturnaround.bundled.javassist.bytecode.Bytecode;
import org.zeroturnaround.bundled.javassist.bytecode.ClassFile;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;
import org.zeroturnaround.bundled.javassist.bytecode.FieldInfo;
import org.zeroturnaround.bundled.javassist.bytecode.MethodInfo;
import org.zeroturnaround.bundled.javassist.compiler.AccessorMaker;
import org.zeroturnaround.bundled.javassist.compiler.CodeGen;
import org.zeroturnaround.bundled.javassist.compiler.CompileError;
import org.zeroturnaround.bundled.javassist.compiler.MemberCodeGen$JsrHook;
import org.zeroturnaround.bundled.javassist.compiler.MemberCodeGen$JsrHook2;
import org.zeroturnaround.bundled.javassist.compiler.MemberResolver;
import org.zeroturnaround.bundled.javassist.compiler.MemberResolver$Method;
import org.zeroturnaround.bundled.javassist.compiler.NoFieldException;
import org.zeroturnaround.bundled.javassist.compiler.TypeChecker;
import org.zeroturnaround.bundled.javassist.compiler.ast.ASTList;
import org.zeroturnaround.bundled.javassist.compiler.ast.ASTree;
import org.zeroturnaround.bundled.javassist.compiler.ast.ArrayInit;
import org.zeroturnaround.bundled.javassist.compiler.ast.CallExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.Declarator;
import org.zeroturnaround.bundled.javassist.compiler.ast.Expr;
import org.zeroturnaround.bundled.javassist.compiler.ast.Keyword;
import org.zeroturnaround.bundled.javassist.compiler.ast.Member;
import org.zeroturnaround.bundled.javassist.compiler.ast.MethodDecl;
import org.zeroturnaround.bundled.javassist.compiler.ast.NewExpr;
import org.zeroturnaround.bundled.javassist.compiler.ast.Pair;
import org.zeroturnaround.bundled.javassist.compiler.ast.Stmnt;
import org.zeroturnaround.bundled.javassist.compiler.ast.Symbol;

public class MemberCodeGen
extends CodeGen {
    protected MemberResolver resolver;
    protected CtClass thisClass;
    protected MethodInfo thisMethod;
    protected boolean resultStatic;

    public MemberCodeGen(Bytecode bytecode, CtClass ctClass, ClassPool classPool) {
        super(bytecode);
        this.resolver = new MemberResolver(classPool);
        this.thisClass = ctClass;
        this.thisMethod = null;
    }

    public int getMajorVersion() {
        ClassFile classFile = this.thisClass.getClassFile2();
        if (classFile == null) {
            return ClassFile.MAJOR_VERSION;
        }
        return classFile.getMajorVersion();
    }

    public void setThisMethod(CtMethod ctMethod) {
        this.thisMethod = ctMethod.getMethodInfo2();
        if (this.typeChecker != null) {
            this.typeChecker.setThisMethod(this.thisMethod);
        }
    }

    public CtClass getThisClass() {
        return this.thisClass;
    }

    protected String getThisName() {
        return MemberResolver.javaToJvmName(this.thisClass.getName());
    }

    protected String getSuperName() throws CompileError {
        return MemberResolver.javaToJvmName(MemberResolver.getSuperclass(this.thisClass).getName());
    }

    protected void insertDefaultSuperCall() throws CompileError {
        this.bytecode.addAload(0);
        this.bytecode.addInvokespecial(MemberResolver.getSuperclass(this.thisClass), "<init>", "()V");
    }

    protected void atTryStmnt(Stmnt stmnt) throws CompileError {
        boolean bl2;
        Bytecode bytecode = this.bytecode;
        Stmnt stmnt2 = (Stmnt)stmnt.getLeft();
        if (stmnt2 == null) {
            return;
        }
        ASTList aSTList = (ASTList)stmnt.getRight().getLeft();
        Stmnt stmnt3 = (Stmnt)stmnt.getRight().getRight().getLeft();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        MemberCodeGen$JsrHook memberCodeGen$JsrHook = null;
        if (stmnt3 != null) {
            memberCodeGen$JsrHook = new MemberCodeGen$JsrHook(this);
        }
        int n2 = bytecode.currentPc();
        stmnt2.accept(this);
        int n3 = bytecode.currentPc();
        if (n2 == n3) {
            throw new CompileError("empty try block");
        }
        boolean bl3 = bl2 = !this.hasReturned;
        if (bl2) {
            bytecode.addOpcode(167);
            arrayList.add(new Integer(bytecode.currentPc()));
            bytecode.addIndex(0);
        }
        int n4 = this.getMaxLocals();
        this.incMaxLocals(1);
        while (aSTList != null) {
            Pair pair = (Pair)aSTList.head();
            aSTList = aSTList.tail();
            Declarator declarator = (Declarator)pair.getLeft();
            Stmnt stmnt4 = (Stmnt)pair.getRight();
            declarator.setLocalVar(n4);
            CtClass ctClass = this.resolver.lookupClassByJvmName(declarator.getClassName());
            declarator.setClassName(MemberResolver.javaToJvmName(ctClass.getName()));
            bytecode.addExceptionHandler(n2, n3, bytecode.currentPc(), ctClass);
            bytecode.growStack(1);
            bytecode.addAstore(n4);
            this.hasReturned = false;
            if (stmnt4 != null) {
                stmnt4.accept(this);
            }
            if (this.hasReturned) continue;
            bytecode.addOpcode(167);
            arrayList.add(new Integer(bytecode.currentPc()));
            bytecode.addIndex(0);
            bl2 = true;
        }
        if (stmnt3 != null) {
            memberCodeGen$JsrHook.remove(this);
            int n5 = bytecode.currentPc();
            bytecode.addExceptionHandler(n2, n5, n5, 0);
            bytecode.growStack(1);
            bytecode.addAstore(n4);
            this.hasReturned = false;
            stmnt3.accept(this);
            if (!this.hasReturned) {
                bytecode.addAload(n4);
                bytecode.addOpcode(191);
            }
            this.addFinally(memberCodeGen$JsrHook.jsrList, stmnt3);
        }
        int n6 = bytecode.currentPc();
        this.patchGoto(arrayList, n6);
        boolean bl4 = this.hasReturned = !bl2;
        if (stmnt3 != null && bl2) {
            stmnt3.accept(this);
        }
    }

    private void addFinally(ArrayList arrayList, Stmnt stmnt) throws CompileError {
        Bytecode bytecode = this.bytecode;
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            int[] nArray = (int[])arrayList.get(i2);
            int n3 = nArray[0];
            bytecode.write16bit(n3, bytecode.currentPc() - n3 + 1);
            MemberCodeGen$JsrHook2 memberCodeGen$JsrHook2 = new MemberCodeGen$JsrHook2(this, nArray);
            stmnt.accept(this);
            memberCodeGen$JsrHook2.remove(this);
            if (this.hasReturned) continue;
            bytecode.addOpcode(167);
            bytecode.addIndex(n3 + 3 - bytecode.currentPc());
        }
    }

    public void atNewExpr(NewExpr newExpr) throws CompileError {
        if (newExpr.isArray()) {
            this.atNewArrayExpr(newExpr);
        } else {
            CtClass ctClass = this.resolver.lookupClassByName(newExpr.getClassName());
            String string = ctClass.getName();
            ASTList aSTList = newExpr.getArguments();
            this.bytecode.addNew(string);
            this.bytecode.addOpcode(89);
            this.atMethodCallCore(ctClass, "<init>", aSTList, false, true, -1, null);
            this.exprType = 307;
            this.arrayDim = 0;
            this.className = MemberResolver.javaToJvmName(string);
        }
    }

    public void atNewArrayExpr(NewExpr newExpr) throws CompileError {
        int n2 = newExpr.getArrayType();
        ASTList aSTList = newExpr.getArraySize();
        ASTList aSTList2 = newExpr.getClassName();
        ArrayInit arrayInit = newExpr.getInitializer();
        if (aSTList.length() > 1) {
            if (arrayInit != null) {
                throw new CompileError("sorry, multi-dimensional array initializer for new is not supported");
            }
            this.atMultiNewArray(n2, aSTList2, aSTList);
            return;
        }
        ASTree aSTree = aSTList.head();
        this.atNewArrayExpr2(n2, aSTree, Declarator.astToClassName(aSTList2, '/'), arrayInit);
    }

    private void atNewArrayExpr2(int n2, ASTree aSTree, String string, ArrayInit arrayInit) throws CompileError {
        int n3;
        String string2;
        if (arrayInit == null) {
            if (aSTree == null) {
                throw new CompileError("no array size");
            }
            aSTree.accept(this);
        } else if (aSTree == null) {
            int n4 = arrayInit.length();
            this.bytecode.addIconst(n4);
        } else {
            throw new CompileError("unnecessary array size specified for new");
        }
        if (n2 == 307) {
            string2 = this.resolveClassName(string);
            this.bytecode.addAnewarray(MemberResolver.jvmToJavaName(string2));
        } else {
            string2 = null;
            n3 = 0;
            switch (n2) {
                case 301: {
                    n3 = 4;
                    break;
                }
                case 306: {
                    n3 = 5;
                    break;
                }
                case 317: {
                    n3 = 6;
                    break;
                }
                case 312: {
                    n3 = 7;
                    break;
                }
                case 303: {
                    n3 = 8;
                    break;
                }
                case 334: {
                    n3 = 9;
                    break;
                }
                case 324: {
                    n3 = 10;
                    break;
                }
                case 326: {
                    n3 = 11;
                    break;
                }
                default: {
                    MemberCodeGen.badNewExpr();
                }
            }
            this.bytecode.addOpcode(188);
            this.bytecode.add(n3);
        }
        if (arrayInit != null) {
            n3 = arrayInit.length();
            ASTList aSTList = arrayInit;
            for (int i2 = 0; i2 < n3; ++i2) {
                this.bytecode.addOpcode(89);
                this.bytecode.addIconst(i2);
                aSTList.head().accept(this);
                if (!MemberCodeGen.isRefType(n2)) {
                    this.atNumCastExpr(this.exprType, n2);
                }
                this.bytecode.addOpcode(MemberCodeGen.getArrayWriteOp(n2, 0));
                aSTList = aSTList.tail();
            }
        }
        this.exprType = n2;
        this.arrayDim = 1;
        this.className = string2;
    }

    private static void badNewExpr() throws CompileError {
        throw new CompileError("bad new expression");
    }

    protected void atArrayVariableAssign(ArrayInit arrayInit, int n2, int n3, String string) throws CompileError {
        this.atNewArrayExpr2(n2, null, string, arrayInit);
    }

    public void atArrayInit(ArrayInit arrayInit) throws CompileError {
        throw new CompileError("array initializer is not supported");
    }

    protected void atMultiNewArray(int n2, ASTList aSTList, ASTList aSTList2) throws CompileError {
        Object object;
        int n3 = aSTList2.length();
        int n4 = 0;
        while (aSTList2 != null && (object = aSTList2.head()) != null) {
            ++n4;
            ((ASTree)object).accept(this);
            if (this.exprType != 324) {
                throw new CompileError("bad type for array size");
            }
            aSTList2 = aSTList2.tail();
        }
        this.exprType = n2;
        this.arrayDim = n3;
        if (n2 == 307) {
            this.className = this.resolveClassName(aSTList);
            object = MemberCodeGen.toJvmArrayName(this.className, n3);
        } else {
            object = MemberCodeGen.toJvmTypeName(n2, n3);
        }
        this.bytecode.addMultiNewarray((String)object, n4);
    }

    public void atCallExpr(CallExpr callExpr) throws CompileError {
        String string = null;
        CtClass ctClass = null;
        ASTree aSTree = callExpr.oprand1();
        ASTList aSTList = (ASTList)callExpr.oprand2();
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = -1;
        MemberResolver$Method memberResolver$Method = callExpr.getMethod();
        if (aSTree instanceof Member) {
            string = ((Member)aSTree).get();
            ctClass = this.thisClass;
            if (this.inStaticMethod || memberResolver$Method != null && memberResolver$Method.isStatic()) {
                bl2 = true;
            } else {
                n2 = this.bytecode.currentPc();
                this.bytecode.addAload(0);
            }
        } else if (aSTree instanceof Keyword) {
            bl3 = true;
            string = "<init>";
            ctClass = this.thisClass;
            if (this.inStaticMethod) {
                throw new CompileError("a constructor cannot be static");
            }
            this.bytecode.addAload(0);
            if (((Keyword)aSTree).get() == 336) {
                ctClass = MemberResolver.getSuperclass(ctClass);
            }
        } else if (aSTree instanceof Expr) {
            Expr expr = (Expr)aSTree;
            string = ((Symbol)expr.oprand2()).get();
            int n3 = expr.getOperator();
            if (n3 == 35) {
                ctClass = this.resolver.lookupClass(((Symbol)expr.oprand1()).get(), false);
                bl2 = true;
            } else if (n3 == 46) {
                ASTree aSTree2 = expr.oprand1();
                if (aSTree2 instanceof Keyword && ((Keyword)aSTree2).get() == 336) {
                    bl3 = true;
                }
                try {
                    aSTree2.accept(this);
                }
                catch (NoFieldException noFieldException) {
                    if (noFieldException.getExpr() != aSTree2) {
                        throw noFieldException;
                    }
                    this.exprType = 307;
                    this.arrayDim = 0;
                    this.className = noFieldException.getField();
                    bl2 = true;
                }
                if (this.arrayDim > 0) {
                    ctClass = this.resolver.lookupClass("java.lang.Object", true);
                } else if (this.exprType == 307) {
                    ctClass = this.resolver.lookupClassByJvmName(this.className);
                } else {
                    MemberCodeGen.badMethod();
                }
            } else {
                MemberCodeGen.badMethod();
            }
        } else {
            MemberCodeGen.fatal();
        }
        this.atMethodCallCore(ctClass, string, aSTList, bl2, bl3, n2, memberResolver$Method);
    }

    private static void badMethod() throws CompileError {
        throw new CompileError("bad method");
    }

    public void atMethodCallCore(CtClass ctClass, String string, ASTList aSTList, boolean bl2, boolean bl3, int n2, MemberResolver$Method memberResolver$Method) throws CompileError {
        int n3 = this.getMethodArgsLength(aSTList);
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        String[] stringArray = new String[n3];
        if (!bl2 && memberResolver$Method != null && memberResolver$Method.isStatic()) {
            this.bytecode.addOpcode(87);
            bl2 = true;
        }
        int n4 = this.bytecode.getStackDepth();
        this.atMethodArgs(aSTList, nArray, nArray2, stringArray);
        int n5 = this.bytecode.getStackDepth() - n4 + 1;
        if (memberResolver$Method == null) {
            memberResolver$Method = this.resolver.lookupMethod(ctClass, this.thisClass, this.thisMethod, string, nArray, nArray2, stringArray);
        }
        if (memberResolver$Method == null) {
            String string2 = string.equals("<init>") ? "constructor not found" : "Method " + string + " not found in " + ctClass.getName();
            throw new CompileError(string2);
        }
        this.atMethodCallCore2(ctClass, string, bl2, bl3, n2, n5, memberResolver$Method);
    }

    private void atMethodCallCore2(CtClass ctClass, String string, boolean bl2, boolean bl3, int n2, int n3, MemberResolver$Method memberResolver$Method) throws CompileError {
        CtClass ctClass2 = memberResolver$Method.declaring;
        MethodInfo methodInfo = memberResolver$Method.info;
        String string2 = methodInfo.getDescriptor();
        int n4 = methodInfo.getAccessFlags();
        if (string.equals("<init>")) {
            bl3 = true;
            if (ctClass2 != ctClass) {
                throw new CompileError("no such constructor: " + ctClass.getName());
            }
            if (ctClass2 != this.thisClass && AccessFlag.isPrivate(n4)) {
                string2 = this.getAccessibleConstructor(string2, ctClass2, methodInfo);
                this.bytecode.addOpcode(1);
            }
        } else if (AccessFlag.isPrivate(n4)) {
            if (ctClass2 == this.thisClass) {
                bl3 = true;
            } else {
                bl3 = false;
                bl2 = true;
                String string3 = string2;
                if ((n4 & 8) == 0) {
                    string2 = Descriptor.insertParameter(ctClass2.getName(), string3);
                }
                n4 = AccessFlag.setPackage(n4) | 8;
                string = this.getAccessiblePrivate(string, string3, string2, methodInfo, ctClass2);
            }
        }
        boolean bl4 = false;
        if ((n4 & 8) != 0) {
            if (!bl2) {
                bl2 = true;
                if (n2 >= 0) {
                    this.bytecode.write(n2, 0);
                } else {
                    bl4 = true;
                }
            }
            this.bytecode.addInvokestatic(ctClass2, string, string2);
        } else if (bl3) {
            this.bytecode.addInvokespecial(ctClass2, string, string2);
        } else {
            if (!Modifier.isPublic(ctClass2.getModifiers()) || ctClass2.isInterface() != ctClass.isInterface()) {
                ctClass2 = ctClass;
            }
            if (ctClass2.isInterface()) {
                this.bytecode.addInvokeinterface(ctClass2, string, string2, n3);
            } else {
                if (bl2) {
                    throw new CompileError(string + " is not static");
                }
                this.bytecode.addInvokevirtual(ctClass2, string, string2);
            }
        }
        this.setReturnType(string2, bl2, bl4);
    }

    protected String getAccessiblePrivate(String string, String string2, String string3, MethodInfo methodInfo, CtClass ctClass) throws CompileError {
        AccessorMaker accessorMaker;
        if (this.isEnclosing(ctClass, this.thisClass) && (accessorMaker = ctClass.getAccessorMaker()) != null) {
            return accessorMaker.getMethodAccessor(string, string2, string3, methodInfo);
        }
        throw new CompileError("Method " + string + " is private");
    }

    protected String getAccessibleConstructor(String string, CtClass ctClass, MethodInfo methodInfo) throws CompileError {
        AccessorMaker accessorMaker;
        if (this.isEnclosing(ctClass, this.thisClass) && (accessorMaker = ctClass.getAccessorMaker()) != null) {
            return accessorMaker.getConstructor(ctClass, string, methodInfo);
        }
        throw new CompileError("the called constructor is private in " + ctClass.getName());
    }

    private boolean isEnclosing(CtClass ctClass, CtClass ctClass2) {
        try {
            while (ctClass2 != null) {
                if ((ctClass2 = ctClass2.getDeclaringClass()) != ctClass) continue;
                return true;
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return false;
    }

    public int getMethodArgsLength(ASTList aSTList) {
        return ASTList.length(aSTList);
    }

    public void atMethodArgs(ASTList aSTList, int[] nArray, int[] nArray2, String[] stringArray) throws CompileError {
        int n2 = 0;
        while (aSTList != null) {
            ASTree aSTree = aSTList.head();
            aSTree.accept(this);
            nArray[n2] = this.exprType;
            nArray2[n2] = this.arrayDim;
            stringArray[n2] = this.className;
            ++n2;
            aSTList = aSTList.tail();
        }
    }

    void setReturnType(String string, boolean bl2, boolean bl3) throws CompileError {
        int n2;
        int n3 = string.indexOf(41);
        if (n3 < 0) {
            MemberCodeGen.badMethod();
        }
        char c2 = string.charAt(++n3);
        int n4 = 0;
        while (c2 == '[') {
            ++n4;
            c2 = string.charAt(++n3);
        }
        this.arrayDim = n4;
        if (c2 == 'L') {
            n2 = string.indexOf(59, n3 + 1);
            if (n2 < 0) {
                MemberCodeGen.badMethod();
            }
            this.exprType = 307;
            this.className = string.substring(n3 + 1, n2);
        } else {
            this.exprType = MemberResolver.descToType(c2);
            this.className = null;
        }
        n2 = this.exprType;
        if (bl2 && bl3) {
            if (MemberCodeGen.is2word(n2, n4)) {
                this.bytecode.addOpcode(93);
                this.bytecode.addOpcode(88);
                this.bytecode.addOpcode(87);
            } else if (n2 == 344) {
                this.bytecode.addOpcode(87);
            } else {
                this.bytecode.addOpcode(95);
                this.bytecode.addOpcode(87);
            }
        }
    }

    protected void atFieldAssign(Expr expr, int n2, ASTree aSTree, ASTree aSTree2, boolean bl2) throws CompileError {
        int n3;
        CtField ctField = this.fieldAccess(aSTree, false);
        boolean bl3 = this.resultStatic;
        if (n2 != 61 && !bl3) {
            this.bytecode.addOpcode(89);
        }
        if (n2 == 61) {
            FieldInfo fieldInfo = ctField.getFieldInfo2();
            this.setFieldType(fieldInfo);
            AccessorMaker accessorMaker = this.isAccessibleField(ctField, fieldInfo);
            n3 = accessorMaker == null ? this.addFieldrefInfo(ctField, fieldInfo) : 0;
        } else {
            n3 = this.atFieldRead(ctField, bl3);
        }
        int n4 = this.exprType;
        int n5 = this.arrayDim;
        String string = this.className;
        this.atAssignCore(expr, n2, aSTree2, n4, n5, string);
        boolean bl4 = MemberCodeGen.is2word(n4, n5);
        if (bl2) {
            int n6 = bl3 ? (bl4 ? 92 : 89) : (bl4 ? 93 : 90);
            this.bytecode.addOpcode(n6);
        }
        this.atFieldAssignCore(ctField, bl3, n3, bl4);
        this.exprType = n4;
        this.arrayDim = n5;
        this.className = string;
    }

    private void atFieldAssignCore(CtField ctField, boolean bl2, int n2, boolean bl3) throws CompileError {
        if (n2 != 0) {
            if (bl2) {
                this.bytecode.add(179);
                this.bytecode.growStack(bl3 ? -2 : -1);
            } else {
                this.bytecode.add(181);
                this.bytecode.growStack(bl3 ? -3 : -2);
            }
            this.bytecode.addIndex(n2);
        } else {
            CtClass ctClass = ctField.getDeclaringClass();
            AccessorMaker accessorMaker = ctClass.getAccessorMaker();
            FieldInfo fieldInfo = ctField.getFieldInfo2();
            MethodInfo methodInfo = accessorMaker.getFieldSetter(fieldInfo, bl2);
            this.bytecode.addInvokestatic(ctClass, methodInfo.getName(), methodInfo.getDescriptor());
        }
    }

    public void atMember(Member member) throws CompileError {
        this.atFieldRead(member);
    }

    protected void atFieldRead(ASTree aSTree) throws CompileError {
        CtField ctField = this.fieldAccess(aSTree, true);
        if (ctField == null) {
            this.atArrayLength(aSTree);
            return;
        }
        boolean bl2 = this.resultStatic;
        ASTree aSTree2 = TypeChecker.getConstantFieldValue(ctField);
        if (aSTree2 == null) {
            this.atFieldRead(ctField, bl2);
        } else {
            aSTree2.accept(this);
            this.setFieldType(ctField.getFieldInfo2());
        }
    }

    private void atArrayLength(ASTree aSTree) throws CompileError {
        if (this.arrayDim == 0) {
            throw new CompileError(".length applied to a non array");
        }
        this.bytecode.addOpcode(190);
        this.exprType = 324;
        this.arrayDim = 0;
    }

    private int atFieldRead(CtField ctField, boolean bl2) throws CompileError {
        FieldInfo fieldInfo = ctField.getFieldInfo2();
        boolean bl3 = this.setFieldType(fieldInfo);
        AccessorMaker accessorMaker = this.isAccessibleField(ctField, fieldInfo);
        if (accessorMaker != null) {
            MethodInfo methodInfo = accessorMaker.getFieldGetter(fieldInfo, bl2);
            this.bytecode.addInvokestatic(ctField.getDeclaringClass(), methodInfo.getName(), methodInfo.getDescriptor());
            return 0;
        }
        int n2 = this.addFieldrefInfo(ctField, fieldInfo);
        if (bl2) {
            this.bytecode.add(178);
            this.bytecode.growStack(bl3 ? 2 : 1);
        } else {
            this.bytecode.add(180);
            this.bytecode.growStack(bl3 ? 1 : 0);
        }
        this.bytecode.addIndex(n2);
        return n2;
    }

    private AccessorMaker isAccessibleField(CtField ctField, FieldInfo fieldInfo) throws CompileError {
        if (AccessFlag.isPrivate(fieldInfo.getAccessFlags()) && ctField.getDeclaringClass() != this.thisClass) {
            CtClass ctClass = ctField.getDeclaringClass();
            if (this.isEnclosing(ctClass, this.thisClass)) {
                AccessorMaker accessorMaker = ctClass.getAccessorMaker();
                if (accessorMaker != null) {
                    return accessorMaker;
                }
                throw new CompileError("fatal error.  bug?");
            }
            throw new CompileError("Field " + ctField.getName() + " in " + ctClass.getName() + " is private.");
        }
        return null;
    }

    private boolean setFieldType(FieldInfo fieldInfo) throws CompileError {
        String string = fieldInfo.getDescriptor();
        int n2 = 0;
        int n3 = 0;
        char c2 = string.charAt(n2);
        while (c2 == '[') {
            ++n3;
            c2 = string.charAt(++n2);
        }
        this.arrayDim = n3;
        this.exprType = MemberResolver.descToType(c2);
        this.className = c2 == 'L' ? string.substring(n2 + 1, string.indexOf(59, n2 + 1)) : null;
        boolean bl2 = c2 == 'J' || c2 == 'D';
        return bl2;
    }

    private int addFieldrefInfo(CtField ctField, FieldInfo fieldInfo) {
        ConstPool constPool = this.bytecode.getConstPool();
        String string = ctField.getDeclaringClass().getName();
        int n2 = constPool.addClassInfo(string);
        String string2 = fieldInfo.getName();
        String string3 = fieldInfo.getDescriptor();
        return constPool.addFieldrefInfo(n2, string2, string3);
    }

    protected void atClassObject2(String string) throws CompileError {
        if (this.getMajorVersion() < 49) {
            super.atClassObject2(string);
        } else {
            this.bytecode.addLdc(this.bytecode.getConstPool().addClassInfo(string));
        }
    }

    protected void atFieldPlusPlus(int n2, boolean bl2, ASTree aSTree, Expr expr, boolean bl3) throws CompileError {
        CtField ctField = this.fieldAccess(aSTree, false);
        boolean bl4 = this.resultStatic;
        if (!bl4) {
            this.bytecode.addOpcode(89);
        }
        int n3 = this.atFieldRead(ctField, bl4);
        int n4 = this.exprType;
        boolean bl5 = MemberCodeGen.is2word(n4, this.arrayDim);
        int n5 = bl4 ? (bl5 ? 92 : 89) : (bl5 ? 93 : 90);
        this.atPlusPlusCore(n5, bl3, n2, bl2, expr);
        this.atFieldAssignCore(ctField, bl4, n3, bl5);
    }

    protected CtField fieldAccess(ASTree aSTree, boolean bl2) throws CompileError {
        if (aSTree instanceof Member) {
            String string = ((Member)aSTree).get();
            CtField ctField = null;
            try {
                ctField = this.thisClass.getField(string);
            }
            catch (NotFoundException notFoundException) {
                throw new NoFieldException(string, aSTree);
            }
            boolean bl3 = Modifier.isStatic(ctField.getModifiers());
            if (!bl3) {
                if (this.inStaticMethod) {
                    throw new CompileError("not available in a static method: " + string);
                }
                this.bytecode.addAload(0);
            }
            this.resultStatic = bl3;
            return ctField;
        }
        if (aSTree instanceof Expr) {
            Expr expr = (Expr)aSTree;
            int n2 = expr.getOperator();
            if (n2 == 35) {
                CtField ctField = this.resolver.lookupField(((Symbol)expr.oprand1()).get(), (Symbol)expr.oprand2());
                this.resultStatic = true;
                return ctField;
            }
            if (n2 == 46) {
                CtField ctField = null;
                try {
                    expr.oprand1().accept(this);
                    if (this.exprType == 307 && this.arrayDim == 0) {
                        ctField = this.resolver.lookupFieldByJvmName(this.className, (Symbol)expr.oprand2());
                    } else {
                        if (bl2 && this.arrayDim > 0 && ((Symbol)expr.oprand2()).get().equals("length")) {
                            return null;
                        }
                        MemberCodeGen.badLvalue();
                    }
                    boolean bl4 = Modifier.isStatic(ctField.getModifiers());
                    if (bl4) {
                        this.bytecode.addOpcode(87);
                    }
                    this.resultStatic = bl4;
                    return ctField;
                }
                catch (NoFieldException noFieldException) {
                    if (noFieldException.getExpr() != expr.oprand1()) {
                        throw noFieldException;
                    }
                    Symbol symbol = (Symbol)expr.oprand2();
                    String string = noFieldException.getField();
                    ctField = this.resolver.lookupFieldByJvmName2(string, symbol, aSTree);
                    this.resultStatic = true;
                    return ctField;
                }
            }
            MemberCodeGen.badLvalue();
        } else {
            MemberCodeGen.badLvalue();
        }
        this.resultStatic = false;
        return null;
    }

    private static void badLvalue() throws CompileError {
        throw new CompileError("bad l-value");
    }

    public CtClass[] makeParamList(MethodDecl methodDecl) throws CompileError {
        CtClass[] ctClassArray;
        ASTList aSTList = methodDecl.getParams();
        if (aSTList == null) {
            ctClassArray = new CtClass[]{};
        } else {
            int n2 = 0;
            ctClassArray = new CtClass[aSTList.length()];
            while (aSTList != null) {
                ctClassArray[n2++] = this.resolver.lookupClass((Declarator)aSTList.head());
                aSTList = aSTList.tail();
            }
        }
        return ctClassArray;
    }

    public CtClass[] makeThrowsList(MethodDecl methodDecl) throws CompileError {
        ASTList aSTList = methodDecl.getThrows();
        if (aSTList == null) {
            return null;
        }
        int n2 = 0;
        CtClass[] ctClassArray = new CtClass[aSTList.length()];
        while (aSTList != null) {
            ctClassArray[n2++] = this.resolver.lookupClassByName((ASTList)aSTList.head());
            aSTList = aSTList.tail();
        }
        return ctClassArray;
    }

    protected String resolveClassName(ASTList aSTList) throws CompileError {
        return this.resolver.resolveClassName(aSTList);
    }

    protected String resolveClassName(String string) throws CompileError {
        return this.resolver.resolveJvmClassName(string);
    }
}

