/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.convert;

import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.Bytecode;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;
import org.zeroturnaround.bundled.javassist.convert.TransformCall;
import org.zeroturnaround.bundled.javassist.convert.Transformer;

public class TransformBefore
extends TransformCall {
    protected CtClass[] parameterTypes;
    protected int locals;
    protected int maxLocals;
    protected byte[] saveCode;
    protected byte[] loadCode;

    public TransformBefore(Transformer transformer, CtMethod ctMethod, CtMethod ctMethod2) throws NotFoundException {
        super(transformer, ctMethod, ctMethod2);
        this.methodDescriptor = ctMethod.getMethodInfo2().getDescriptor();
        this.parameterTypes = ctMethod.getParameterTypes();
        this.locals = 0;
        this.maxLocals = 0;
        this.loadCode = null;
        this.saveCode = null;
    }

    public void initialize(ConstPool constPool, CodeAttribute codeAttribute) {
        super.initialize(constPool, codeAttribute);
        this.locals = 0;
        this.maxLocals = codeAttribute.getMaxLocals();
        this.loadCode = null;
        this.saveCode = null;
    }

    protected int match(int n2, int n3, CodeIterator codeIterator, int n4, ConstPool constPool) throws BadBytecode {
        if (this.newIndex == 0) {
            String string = Descriptor.ofParameters(this.parameterTypes) + 'V';
            string = Descriptor.insertParameter(this.classname, string);
            int n5 = constPool.addNameAndTypeInfo(this.newMethodname, string);
            int n6 = constPool.addClassInfo(this.newClassname);
            this.newIndex = constPool.addMethodrefInfo(n6, n5);
            this.constPool = constPool;
        }
        if (this.saveCode == null) {
            this.makeCode(this.parameterTypes, constPool);
        }
        return this.match2(n3, codeIterator);
    }

    protected int match2(int n2, CodeIterator codeIterator) throws BadBytecode {
        codeIterator.move(n2);
        codeIterator.insert(this.saveCode);
        codeIterator.insert(this.loadCode);
        int n3 = codeIterator.insertGap(3);
        codeIterator.writeByte(184, n3);
        codeIterator.write16bit(this.newIndex, n3 + 1);
        codeIterator.insert(this.loadCode);
        return codeIterator.next();
    }

    public int extraLocals() {
        return this.locals;
    }

    protected void makeCode(CtClass[] ctClassArray, ConstPool constPool) {
        Bytecode bytecode = new Bytecode(constPool, 0, 0);
        Bytecode bytecode2 = new Bytecode(constPool, 0, 0);
        int n2 = this.maxLocals;
        int n3 = ctClassArray == null ? 0 : ctClassArray.length;
        bytecode2.addAload(n2);
        this.makeCode2(bytecode, bytecode2, 0, n3, ctClassArray, n2 + 1);
        bytecode.addAstore(n2);
        this.saveCode = bytecode.get();
        this.loadCode = bytecode2.get();
    }

    private void makeCode2(Bytecode bytecode, Bytecode bytecode2, int n2, int n3, CtClass[] ctClassArray, int n4) {
        if (n2 < n3) {
            int n5 = bytecode2.addLoad(n4, ctClassArray[n2]);
            this.makeCode2(bytecode, bytecode2, n2 + 1, n3, ctClassArray, n4 + n5);
            bytecode.addStore(n4, ctClassArray[n2]);
        } else {
            this.locals = n4 - this.maxLocals;
        }
    }
}

