/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.convert;

import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.Modifier;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.convert.Transformer;

public class TransformCall
extends Transformer {
    protected String classname;
    protected String methodname;
    protected String methodDescriptor;
    protected String newClassname;
    protected String newMethodname;
    protected boolean newMethodIsPrivate;
    protected int newIndex;
    protected ConstPool constPool;

    public TransformCall(Transformer transformer, CtMethod ctMethod, CtMethod ctMethod2) {
        this(transformer, ctMethod.getName(), ctMethod2);
        this.classname = ctMethod.getDeclaringClass().getName();
    }

    public TransformCall(Transformer transformer, String string, CtMethod ctMethod) {
        super(transformer);
        this.methodname = string;
        this.methodDescriptor = ctMethod.getMethodInfo2().getDescriptor();
        this.classname = this.newClassname = ctMethod.getDeclaringClass().getName();
        this.newMethodname = ctMethod.getName();
        this.constPool = null;
        this.newMethodIsPrivate = Modifier.isPrivate(ctMethod.getModifiers());
    }

    public void initialize(ConstPool constPool, CodeAttribute codeAttribute) {
        if (this.constPool != constPool) {
            this.newIndex = 0;
        }
    }

    public int transform(CtClass ctClass, int n2, CodeIterator codeIterator, ConstPool constPool) throws BadBytecode {
        int n3;
        String string;
        int n4 = codeIterator.byteAt(n2);
        if ((n4 == 185 || n4 == 183 || n4 == 184 || n4 == 182) && (string = constPool.eqMember(this.methodname, this.methodDescriptor, n3 = codeIterator.u16bitAt(n2 + 1))) != null && this.matchClass(string, ctClass.getClassPool())) {
            int n5 = constPool.getMemberNameAndType(n3);
            n2 = this.match(n4, n2, codeIterator, constPool.getNameAndTypeDescriptor(n5), constPool);
        }
        return n2;
    }

    private boolean matchClass(String string, ClassPool classPool) {
        if (this.classname.equals(string)) {
            return true;
        }
        try {
            CtClass ctClass = classPool.get(string);
            CtClass ctClass2 = classPool.get(this.classname);
            if (ctClass.subtypeOf(ctClass2)) {
                try {
                    CtMethod ctMethod = ctClass.getMethod(this.methodname, this.methodDescriptor);
                    return ctMethod.getDeclaringClass().getName().equals(this.classname);
                }
                catch (NotFoundException notFoundException) {
                    return true;
                }
            }
        }
        catch (NotFoundException notFoundException) {
            return false;
        }
        return false;
    }

    protected int match(int n2, int n3, CodeIterator codeIterator, int n4, ConstPool constPool) throws BadBytecode {
        if (this.newIndex == 0) {
            int n5 = constPool.addNameAndTypeInfo(constPool.addUtf8Info(this.newMethodname), n4);
            int n6 = constPool.addClassInfo(this.newClassname);
            if (n2 == 185) {
                this.newIndex = constPool.addInterfaceMethodrefInfo(n6, n5);
            } else {
                if (this.newMethodIsPrivate && n2 == 182) {
                    codeIterator.writeByte(183, n3);
                }
                this.newIndex = constPool.addMethodrefInfo(n6, n5);
            }
            this.constPool = constPool;
        }
        codeIterator.write16bit(this.newIndex, n3 + 1);
        return n3;
    }
}

