/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.expr;

import java.util.Iterator;
import java.util.LinkedList;
import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtBehavior;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtConstructor;
import org.zeroturnaround.bundled.javassist.CtPrimitiveType;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.AttributeInfo;
import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.Bytecode;
import org.zeroturnaround.bundled.javassist.bytecode.ClassFile;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.ExceptionsAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.MethodInfo;
import org.zeroturnaround.bundled.javassist.bytecode.Opcode;
import org.zeroturnaround.bundled.javassist.expr.ExprEditor;
import org.zeroturnaround.bundled.javassist.expr.ExprEditor$LoopContext;

public abstract class Expr
implements Opcode {
    int currentPos;
    CodeIterator iterator;
    CtClass thisClass;
    MethodInfo thisMethod;
    boolean edited;
    int maxLocals;
    int maxStack;
    static final String javaLangObject = "java.lang.Object";

    protected Expr(int n2, CodeIterator codeIterator, CtClass ctClass, MethodInfo methodInfo) {
        this.currentPos = n2;
        this.iterator = codeIterator;
        this.thisClass = ctClass;
        this.thisMethod = methodInfo;
    }

    public CtClass getEnclosingClass() {
        return this.thisClass;
    }

    protected final ConstPool getConstPool() {
        return this.thisMethod.getConstPool();
    }

    protected final boolean edited() {
        return this.edited;
    }

    protected final int locals() {
        return this.maxLocals;
    }

    protected final int stack() {
        return this.maxStack;
    }

    protected final boolean withinStatic() {
        return (this.thisMethod.getAccessFlags() & 8) != 0;
    }

    public CtBehavior where() {
        MethodInfo methodInfo = this.thisMethod;
        CtBehavior[] ctBehaviorArray = this.thisClass.getDeclaredBehaviors();
        for (int i2 = ctBehaviorArray.length - 1; i2 >= 0; --i2) {
            if (ctBehaviorArray[i2].getMethodInfo2() != methodInfo) continue;
            return ctBehaviorArray[i2];
        }
        CtConstructor ctConstructor = this.thisClass.getClassInitializer();
        if (ctConstructor != null && ctConstructor.getMethodInfo2() == methodInfo) {
            return ctConstructor;
        }
        for (int i3 = ctBehaviorArray.length - 1; i3 >= 0; --i3) {
            if (!this.thisMethod.getName().equals(ctBehaviorArray[i3].getMethodInfo2().getName()) || !this.thisMethod.getDescriptor().equals(ctBehaviorArray[i3].getMethodInfo2().getDescriptor())) continue;
            return ctBehaviorArray[i3];
        }
        throw new RuntimeException("fatal: not found");
    }

    public CtClass[] mayThrow() {
        int n2;
        int n3;
        String[] stringArray;
        AttributeInfo attributeInfo;
        ClassPool classPool = this.thisClass.getClassPool();
        ConstPool constPool = this.thisMethod.getConstPool();
        LinkedList linkedList = new LinkedList();
        try {
            attributeInfo = this.thisMethod.getCodeAttribute();
            stringArray = ((CodeAttribute)attributeInfo).getExceptionTable();
            n3 = this.currentPos;
            n2 = stringArray.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                int n4;
                if (stringArray.startPc(i2) > n3 || n3 >= stringArray.endPc(i2) || (n4 = stringArray.catchType(i2)) <= 0) continue;
                try {
                    Expr.addClass(linkedList, classPool.get(constPool.getClassInfo(n4)));
                    continue;
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if ((attributeInfo = this.thisMethod.getExceptionsAttribute()) != null && (stringArray = ((ExceptionsAttribute)attributeInfo).getExceptions()) != null) {
            n3 = stringArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                try {
                    Expr.addClass(linkedList, classPool.get(stringArray[n2]));
                    continue;
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
            }
        }
        return linkedList.toArray(new CtClass[linkedList.size()]);
    }

    private static void addClass(LinkedList linkedList, CtClass ctClass) {
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != ctClass) continue;
            return;
        }
        linkedList.add(ctClass);
    }

    public int indexOfBytecode() {
        return this.currentPos;
    }

    public int getLineNumber() {
        return this.thisMethod.getLineNumber(this.currentPos);
    }

    public String getFileName() {
        ClassFile classFile = this.thisClass.getClassFile2();
        if (classFile == null) {
            return null;
        }
        return classFile.getSourceFile();
    }

    static final boolean checkResultValue(CtClass ctClass, String string) throws CannotCompileException {
        boolean bl2;
        boolean bl3 = bl2 = string.indexOf("$_") >= 0;
        if (!bl2 && ctClass != CtClass.voidType) {
            throw new CannotCompileException("the resulting value is not stored in $_");
        }
        return bl2;
    }

    static final void storeStack(CtClass[] ctClassArray, boolean bl2, int n2, Bytecode bytecode) {
        Expr.storeStack0(0, ctClassArray.length, ctClassArray, n2 + 1, bytecode);
        if (bl2) {
            bytecode.addOpcode(1);
        }
        bytecode.addAstore(n2);
    }

    private static void storeStack0(int n2, int n3, CtClass[] ctClassArray, int n4, Bytecode bytecode) {
        if (n2 >= n3) {
            return;
        }
        CtClass ctClass = ctClassArray[n2];
        int n5 = ctClass instanceof CtPrimitiveType ? ((CtPrimitiveType)ctClass).getDataSize() : 1;
        Expr.storeStack0(n2 + 1, n3, ctClassArray, n4 + n5, bytecode);
        bytecode.addStore(n4, ctClass);
    }

    public abstract void replace(String var1) throws CannotCompileException;

    public void replace(String string, ExprEditor exprEditor) throws CannotCompileException {
        this.replace(string);
        if (exprEditor != null) {
            this.runEditor(exprEditor, this.iterator);
        }
    }

    protected void replace0(int n2, Bytecode bytecode, int n3) throws BadBytecode {
        byte[] byArray = bytecode.get();
        this.edited = true;
        int n4 = byArray.length - n3;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.iterator.writeByte(0, n2 + i2);
        }
        if (n4 > 0) {
            n2 = this.iterator.insertGapAt((int)n2, (int)n4, (boolean)false).position;
        }
        this.iterator.write(byArray, n2);
        this.iterator.insert(bytecode.getExceptionTable(), n2);
        this.maxLocals = bytecode.getMaxLocals();
        this.maxStack = bytecode.getMaxStack();
    }

    protected void runEditor(ExprEditor exprEditor, CodeIterator codeIterator) throws CannotCompileException {
        CodeAttribute codeAttribute = codeIterator.get();
        int n2 = codeAttribute.getMaxLocals();
        int n3 = codeAttribute.getMaxStack();
        int n4 = this.locals();
        codeAttribute.setMaxStack(this.stack());
        codeAttribute.setMaxLocals(n4);
        ExprEditor$LoopContext exprEditor$LoopContext = new ExprEditor$LoopContext(n4);
        int n5 = codeIterator.getCodeLength();
        int n6 = codeIterator.lookAhead();
        codeIterator.move(this.currentPos);
        if (exprEditor.doit(this.thisClass, this.thisMethod, exprEditor$LoopContext, codeIterator, n6)) {
            this.edited = true;
        }
        codeIterator.move(n6 + codeIterator.getCodeLength() - n5);
        codeAttribute.setMaxLocals(n2);
        codeAttribute.setMaxStack(n3);
        this.maxLocals = exprEditor$LoopContext.maxLocals;
        this.maxStack += exprEditor$LoopContext.maxStack;
    }
}

