/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.expr;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.CtBehavior;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtPrimitiveType;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.Bytecode;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;
import org.zeroturnaround.bundled.javassist.bytecode.MethodInfo;
import org.zeroturnaround.bundled.javassist.compiler.CompileError;
import org.zeroturnaround.bundled.javassist.compiler.Javac;
import org.zeroturnaround.bundled.javassist.expr.Expr;
import org.zeroturnaround.bundled.javassist.expr.NewArray$ProceedForArray;

public class NewArray
extends Expr {
    int opcode;

    protected NewArray(int n2, CodeIterator codeIterator, CtClass ctClass, MethodInfo methodInfo, int n3) {
        super(n2, codeIterator, ctClass, methodInfo);
        this.opcode = n3;
    }

    public CtBehavior where() {
        return super.where();
    }

    public int getLineNumber() {
        return super.getLineNumber();
    }

    public String getFileName() {
        return super.getFileName();
    }

    public CtClass[] mayThrow() {
        return super.mayThrow();
    }

    public CtClass getComponentType() throws NotFoundException {
        if (this.opcode == 188) {
            int n2 = this.iterator.byteAt(this.currentPos + 1);
            return this.getPrimitiveType(n2);
        }
        if (this.opcode == 189 || this.opcode == 197) {
            int n3 = this.iterator.u16bitAt(this.currentPos + 1);
            String string = this.getConstPool().getClassInfo(n3);
            int n4 = Descriptor.arrayDimension(string);
            string = Descriptor.toArrayComponent(string, n4);
            return Descriptor.toCtClass(string, this.thisClass.getClassPool());
        }
        throw new RuntimeException("bad opcode: " + this.opcode);
    }

    CtClass getPrimitiveType(int n2) {
        switch (n2) {
            case 4: {
                return CtClass.booleanType;
            }
            case 5: {
                return CtClass.charType;
            }
            case 6: {
                return CtClass.floatType;
            }
            case 7: {
                return CtClass.doubleType;
            }
            case 8: {
                return CtClass.byteType;
            }
            case 9: {
                return CtClass.shortType;
            }
            case 10: {
                return CtClass.intType;
            }
            case 11: {
                return CtClass.longType;
            }
        }
        throw new RuntimeException("bad atype: " + n2);
    }

    public int getDimension() {
        if (this.opcode == 188) {
            return 1;
        }
        if (this.opcode == 189 || this.opcode == 197) {
            int n2 = this.iterator.u16bitAt(this.currentPos + 1);
            String string = this.getConstPool().getClassInfo(n2);
            return Descriptor.arrayDimension(string) + (this.opcode == 189 ? 1 : 0);
        }
        throw new RuntimeException("bad opcode: " + this.opcode);
    }

    public int getCreatedDimensions() {
        if (this.opcode == 197) {
            return this.iterator.byteAt(this.currentPos + 3);
        }
        return 1;
    }

    public void replace(String string) throws CannotCompileException {
        try {
            this.replace2(string);
        }
        catch (CompileError compileError) {
            throw new CannotCompileException(compileError);
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
        catch (BadBytecode badBytecode) {
            throw new CannotCompileException("broken method");
        }
    }

    private void replace2(String string) throws CompileError, NotFoundException, BadBytecode, CannotCompileException {
        int n2;
        int n3;
        String string2;
        Object object;
        this.thisClass.getClassFile();
        ConstPool constPool = this.getConstPool();
        int n4 = this.currentPos;
        int n5 = 0;
        int n6 = 1;
        if (this.opcode == 188) {
            n5 = this.iterator.byteAt(this.currentPos + 1);
            object = (CtPrimitiveType)this.getPrimitiveType(n5);
            string2 = "[" + ((CtPrimitiveType)object).getDescriptor();
            n3 = 2;
        } else if (this.opcode == 189) {
            n5 = this.iterator.u16bitAt(n4 + 1);
            string2 = constPool.getClassInfo(n5);
            string2 = string2.startsWith("[") ? "[" + string2 : "[L" + string2 + ";";
            n3 = 3;
        } else if (this.opcode == 197) {
            n5 = this.iterator.u16bitAt(this.currentPos + 1);
            string2 = constPool.getClassInfo(n5);
            n6 = this.iterator.byteAt(this.currentPos + 3);
            n3 = 4;
        } else {
            throw new RuntimeException("bad opcode: " + this.opcode);
        }
        CtClass ctClass = Descriptor.toCtClass(string2, this.thisClass.getClassPool());
        object = new Javac(this.thisClass);
        CodeAttribute codeAttribute = this.iterator.get();
        CtClass[] ctClassArray = new CtClass[n6];
        for (n2 = 0; n2 < n6; ++n2) {
            ctClassArray[n2] = CtClass.intType;
        }
        n2 = codeAttribute.getMaxLocals();
        ((Javac)object).recordParams("java.lang.Object", ctClassArray, true, n2, this.withinStatic());
        NewArray.checkResultValue(ctClass, string);
        int n7 = ((Javac)object).recordReturnType(ctClass, true);
        ((Javac)object).recordProceed(new NewArray$ProceedForArray(ctClass, this.opcode, n5, n6));
        Bytecode bytecode = ((Javac)object).getBytecode();
        NewArray.storeStack(ctClassArray, true, n2, bytecode);
        ((Javac)object).recordLocalVariables(codeAttribute, n4);
        bytecode.addOpcode(1);
        bytecode.addAstore(n7);
        ((Javac)object).compileStmnt(string);
        bytecode.addAload(n7);
        this.replace0(n4, bytecode, n3);
    }
}

