/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.scopedpool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.LoaderClassPath;
import org.zeroturnaround.bundled.javassist.scopedpool.ScopedClassPool;
import org.zeroturnaround.bundled.javassist.scopedpool.ScopedClassPoolFactory;
import org.zeroturnaround.bundled.javassist.scopedpool.ScopedClassPoolFactoryImpl;
import org.zeroturnaround.bundled.javassist.scopedpool.ScopedClassPoolRepository;

public class ScopedClassPoolRepositoryImpl
implements ScopedClassPoolRepository {
    private static final ScopedClassPoolRepositoryImpl instance = new ScopedClassPoolRepositoryImpl();
    private boolean prune = true;
    boolean pruneWhenCached;
    protected Map registeredCLs = Collections.synchronizedMap(new WeakHashMap());
    protected ClassPool classpool;
    protected ScopedClassPoolFactory factory = new ScopedClassPoolFactoryImpl();

    public static ScopedClassPoolRepository getInstance() {
        return instance;
    }

    private ScopedClassPoolRepositoryImpl() {
        this.classpool = ClassPool.getDefault();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.classpool.insertClassPath(new LoaderClassPath(classLoader));
    }

    public boolean isPrune() {
        return this.prune;
    }

    public void setPrune(boolean bl2) {
        this.prune = bl2;
    }

    public ScopedClassPool createScopedClassPool(ClassLoader classLoader, ClassPool classPool) {
        return this.factory.create(classLoader, classPool, this);
    }

    public ClassPool findClassPool(ClassLoader classLoader) {
        if (classLoader == null) {
            return this.registerClassLoader(ClassLoader.getSystemClassLoader());
        }
        return this.registerClassLoader(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPool registerClassLoader(ClassLoader classLoader) {
        Map map = this.registeredCLs;
        synchronized (map) {
            if (this.registeredCLs.containsKey(classLoader)) {
                return (ClassPool)this.registeredCLs.get(classLoader);
            }
            ScopedClassPool scopedClassPool = this.createScopedClassPool(classLoader, this.classpool);
            this.registeredCLs.put(classLoader, scopedClassPool);
            return scopedClassPool;
        }
    }

    public Map getRegisteredCLs() {
        this.clearUnregisteredClassLoaders();
        return this.registeredCLs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearUnregisteredClassLoaders() {
        ArrayList<ClassLoader> arrayList = null;
        Map map = this.registeredCLs;
        synchronized (map) {
            Iterator iterator = this.registeredCLs.values().iterator();
            while (iterator.hasNext()) {
                ScopedClassPool scopedClassPool = (ScopedClassPool)iterator.next();
                if (!scopedClassPool.isUnloadedClassLoader()) continue;
                iterator.remove();
                ClassLoader classLoader = scopedClassPool.getClassLoader();
                if (classLoader == null) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<ClassLoader>();
                }
                arrayList.add(classLoader);
            }
            if (arrayList != null) {
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    this.unregisterClassLoader((ClassLoader)arrayList.get(i2));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterClassLoader(ClassLoader classLoader) {
        Map map = this.registeredCLs;
        synchronized (map) {
            ScopedClassPool scopedClassPool = (ScopedClassPool)this.registeredCLs.remove(classLoader);
            if (scopedClassPool != null) {
                scopedClassPool.close();
            }
        }
    }

    public void insertDelegate(ScopedClassPoolRepository scopedClassPoolRepository) {
    }

    public void setClassPoolFactory(ScopedClassPoolFactory scopedClassPoolFactory) {
        this.factory = scopedClassPoolFactory;
    }

    public ScopedClassPoolFactory getClassPoolFactory() {
        return this.factory;
    }
}

