/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.equinox;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtField;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.CtNewConstructor;
import org.zeroturnaround.bundled.javassist.CtNewMethod;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.integration.equinox.EquinoxClassPathManagerClassBytecodeProcessor$1;
import org.zeroturnaround.javarebel.integration.support.JavassistClassBytecodeProcessor;

public class EquinoxClassPathManagerClassBytecodeProcessor
extends JavassistClassBytecodeProcessor {
    static Class class$java$lang$String;
    static Class array$B;
    static Class class$java$io$File;
    static Class class$org$zeroturnaround$javarebel$ClassResourceSource;

    public void process(ClassPool classPool, ClassLoader classLoader, CtClass ctClass) throws Exception {
        classPool.importPackage("java.util");
        classPool.importPackage("java.io");
        classPool.importPackage("org.eclipse.osgi.baseadaptor.bundlefile");
        classPool.importPackage("org.eclipse.osgi.baseadaptor.loader");
        classPool.importPackage("org.zeroturnaround.javarebel");
        classPool.importPackage("org.zeroturnaround.javarebel.integration.util");
        classPool.importPackage("org.zeroturnaround.javarebel.support");
        ctClass.addField(CtField.make("private static final Logger jrLogger = LoggerFactory.getLogger(\"Equinox\");", ctClass));
        this.addStubs(classPool);
        this.processClassResourceSource(classPool, ctClass);
        try {
            ctClass.getDeclaredMethod("findLoadedClass");
        }
        catch (NotFoundException notFoundException) {
            ctClass.addMethod(CtNewMethod.make("private Class findLoadedClass(String name) {  synchronized (classloader) {    return classloader.publicFindLoaded(name);  }}", ctClass));
        }
        boolean bl2 = false;
        try {
            ctClass.getDeclaredMethod("defineClassHoldingLock");
            bl2 = true;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        CtMethod ctMethod = ctClass.getMethod("findLocalClassImpl", "(Ljava/lang/String;[Lorg/eclipse/osgi/baseadaptor/hooks/ClassLoadingStatsHook;)Ljava/lang/Class;");
        String string = "Class result = findLoadedClass($1);if (result != null) return result;result = IntegrationFactory.getInstance().findReloadableClass((ClassLoader) classloader, $1);if (result != null) return result;";
        if (bl2) {
            string = "if ((LOCK_CLASSNAME) || (this.isParallelClassLoader)) {  boolean initialLock = lockClassName($1);  try {" + string + "  } finally {" + "    if (initialLock)" + "      unlockClassName($1);" + "  }" + "} else {" + "  synchronized (this.classloader) {" + string + "  }" + "}";
        }
        ctMethod.insertBefore(string);
        ctClass.getDeclaredMethod("findLocalResource", classPool.get(new String[]{(class$java$lang$String == null ? (class$java$lang$String = EquinoxClassPathManagerClassBytecodeProcessor.class$("java.lang.String")) : class$java$lang$String).getName()})).insertBefore("{  org.zeroturnaround.javarebel.Integration integration = org.zeroturnaround.javarebel.IntegrationFactory.getInstance();  if (integration.isResourceReplaced((ClassLoader) classloader, $1))    return integration.findResource((ClassLoader) classloader, $1);}");
        ctClass.getDeclaredMethod("findLocalResources", classPool.get(new String[]{(class$java$lang$String == null ? (class$java$lang$String = EquinoxClassPathManagerClassBytecodeProcessor.class$("java.lang.String")) : class$java$lang$String).getName()})).insertBefore("{  org.zeroturnaround.javarebel.Integration integration = org.zeroturnaround.javarebel.IntegrationFactory.getInstance();  if (integration.isResourceReplaced((ClassLoader) classloader, $1))    return integration.findResources((ClassLoader) classloader, $1);}");
        CtMethod ctMethod2 = null;
        try {
            ctMethod2 = ctClass.getDeclaredMethod("defineClass", classPool.get(new String[]{(class$java$lang$String == null ? (class$java$lang$String = EquinoxClassPathManagerClassBytecodeProcessor.class$("java.lang.String")) : class$java$lang$String).getName(), (array$B == null ? (array$B = EquinoxClassPathManagerClassBytecodeProcessor.class$("[B")) : array$B).getName(), "org.eclipse.osgi.baseadaptor.loader.ClasspathEntry", "org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry", "org.eclipse.osgi.baseadaptor.hooks.ClassLoadingStatsHook[]"}));
        }
        catch (NotFoundException notFoundException) {
            ctMethod2 = ctClass.getDeclaredMethod("defineClass", classPool.get(new String[]{(class$java$lang$String == null ? (class$java$lang$String = EquinoxClassPathManagerClassBytecodeProcessor.class$("java.lang.String")) : class$java$lang$String).getName(), (array$B == null ? (array$B = EquinoxClassPathManagerClassBytecodeProcessor.class$("[B")) : array$B).getName(), "org.eclipse.osgi.baseadaptor.loader.ClasspathEntry", "org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry"}));
        }
        ctMethod2.insertBefore("IntegrationFactory.getInstance().recordClassResource((ClassLoader)classloader, $1, $4.getLocalURL());");
    }

    private void addStubs(ClassPool classPool) throws CannotCompileException, NotFoundException {
        CtClass ctClass = classPool.get("org.eclipse.osgi.baseadaptor.bundlefile.DirBundleFile");
        try {
            ctClass.getDeclaredConstructor(classPool.get(new String[]{(class$java$io$File == null ? (class$java$io$File = EquinoxClassPathManagerClassBytecodeProcessor.class$("java.io.File")) : class$java$io$File).getName()}));
        }
        catch (NotFoundException notFoundException) {
            ctClass.addConstructor(CtNewConstructor.make(" public DirBundleFile(File basefile) throws IOException {     }", ctClass));
        }
    }

    private void processClassResourceSource(ClassPool classPool, CtClass ctClass) throws NotFoundException, CannotCompileException {
        ctClass.addInterface(classPool.get((class$org$zeroturnaround$javarebel$ClassResourceSource == null ? (class$org$zeroturnaround$javarebel$ClassResourceSource = EquinoxClassPathManagerClassBytecodeProcessor.class$("org.zeroturnaround.javarebel.ClassResourceSource")) : class$org$zeroturnaround$javarebel$ClassResourceSource).getName()));
        try {
            classPool.importPackage("org.eclipse.core.runtime.internal.adaptor");
            ctClass.addField(CtField.make("private static final URLConverterImpl converter = new URLConverterImpl();", ctClass));
            CtMethod ctMethod = ctClass.getDeclaredMethod("findResourceImpl", classPool.get(new String[]{(class$java$lang$String == null ? (class$java$lang$String = EquinoxClassPathManagerClassBytecodeProcessor.class$("java.lang.String")) : class$java$lang$String).getName(), "org.eclipse.osgi.baseadaptor.bundlefile.BundleFile", Integer.TYPE.getName()}));
            ctMethod.insertAfter("if ($_ != null) {  java.net.URL u = converter.resolve($_);  if (u != null && ResourceUtils.isFileURL(u))    $_ = u;}");
        }
        catch (Exception exception) {
            LoggerFactory.getLogger("Equinox").info("Could not find URLConverterImpl, reverting to old version");
            boolean bl2 = false;
            try {
                ctClass.getDeclaredMethod("findLocalEntry", classPool.get(new String[]{(class$java$lang$String == null ? (class$java$lang$String = EquinoxClassPathManagerClassBytecodeProcessor.class$("java.lang.String")) : class$java$lang$String).getName(), Integer.TYPE.getName()}));
                bl2 = true;
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            CtMethod ctMethod = ctClass.getDeclaredMethod("findResourceImpl", classPool.get(new String[]{(class$java$lang$String == null ? (class$java$lang$String = EquinoxClassPathManagerClassBytecodeProcessor.class$("java.lang.String")) : class$java$lang$String).getName(), "org.eclipse.osgi.baseadaptor.bundlefile.BundleFile", Integer.TYPE.getName()}));
            CtMethod ctMethod2 = CtNewMethod.copy(ctMethod, "__findResourceImpl", ctClass, null);
            ctClass.addMethod(ctMethod2);
            ctMethod.setBody("{" + (bl2 ? "" : "if  ($3 < 1)") + "  {" + "    StopWatch sw = jrLogger.createStopWatch(\"Equinox#findResourceImpl\");" + "    try {" + "      org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry be = findLocalEntry($1" + (bl2 ? ", $3" : "") + ");" + "      if (be != null) {" + "        try {" + "          java.net.URL u = be.getLocalURL();" + "          if (u != null && ResourceUtils.isFileURL(u))" + "            return u;" + "        } catch (Exception e) {}" + "      }" + "    } finally {" + "      if (sw != null) sw.stop();" + "    }" + "  }" + "  return __findResourceImpl($$);" + "}");
        }
        ctClass.addMethod(CtNewMethod.make("public Resource getLocalResource(String name) {  return ResourceUtil.asResource(findLocalResource(name));}", ctClass));
        ctClass.addMethod(CtNewMethod.make("public Resource[] getLocalResources(String name) {  return ResourceUtil.asResources(findLocalResources(name));}", ctClass));
        ctClass.addMethod(CtNewMethod.make("public Resource getClassResource(String className) {  return getLocalResource(className.replace('.', '/') + \".class\");}", ctClass));
        ctClass.getDeclaredMethod("initialize").instrument(new EquinoxClassPathManagerClassBytecodeProcessor$1(this));
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

