/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.monitor;

import com.zeroturnaround.javarebel.bl;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.zeroturnaround.javarebel.ConfigurationFactory;
import org.zeroturnaround.javarebel.FileEventListener;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.ResourceIntegrationFactory;
import org.zeroturnaround.javarebel.StopWatch;
import org.zeroturnaround.javarebel.integration.monitor.FileMonitorAdapter$DirtyListener;
import org.zeroturnaround.javarebel.integration.util.MiscUtil;
import org.zeroturnaround.javarebel.integration.util.WeakUtil;

public class FileMonitorAdapter {
    private static final int CHECK_INTERVAL = ConfigurationFactory.getInstance().getCheckInterval();
    private final Map files = Collections.synchronizedMap(new HashMap());
    private final FileEventListener innerListener = new FileMonitorAdapter$DirtyListener(this, false);
    private final FileEventListener listener = WeakUtil.weak(this.innerListener);
    private final FileEventListener innerRecursiveListener = new FileMonitorAdapter$DirtyListener(this, true);
    private final FileEventListener listenerRecursive = WeakUtil.weak(this.innerRecursiveListener);
    private final boolean onlyAdd;
    private volatile long lastScan = System.currentTimeMillis();
    private volatile boolean dirty = false;
    private volatile boolean failed = false;
    private volatile boolean directories = false;

    public FileMonitorAdapter() {
        this(false);
    }

    public FileMonitorAdapter(boolean bl2) {
        this.onlyAdd = bl2;
        LoggerFactory.getInstance().info("Created " + MiscUtil.identityToString(this) + " with " + MiscUtil.identityToString(this.listener) + " and " + MiscUtil.identityToString(this.listenerRecursive));
    }

    public void addFile(File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            file = file.getAbsoluteFile();
        }
        if (!file.isDirectory()) {
            this.files.put(file, bl.a(file.lastModified()));
            ResourceIntegrationFactory.getInstance().addFileListener(file.getParentFile(), this.listener);
        } else {
            this.directories = true;
            ResourceIntegrationFactory.getInstance().addFileListener(file, this.listener);
        }
    }

    public void addRecursiveDir(File file) {
        this.directories = true;
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            file = file.getAbsoluteFile();
        }
        if (file.isDirectory()) {
            ResourceIntegrationFactory.getInstance().addFileListener(file, this.listenerRecursive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty() {
        Map map = this.files;
        synchronized (map) {
            if (this.lastScan + (long)CHECK_INTERVAL < System.currentTimeMillis() && (this.failed || this.dirty || !ResourceIntegrationFactory.getInstance().isEnabled())) {
                boolean bl2 = false;
                if (this.directories || this.files.size() == 0) {
                    bl2 = true;
                } else {
                    StopWatch stopWatch = LoggerFactory.getLogger("Util").createStopWatch("DirtyCheck");
                    try {
                        bl2 = false;
                        Iterator iterator = this.files.keySet().iterator();
                        while (iterator.hasNext()) {
                            File file = (File)iterator.next();
                            long l2 = file.lastModified();
                            if (l2 == (Long)this.files.get(file)) continue;
                            this.files.put(file, bl.a(l2));
                            bl2 = true;
                        }
                    }
                    finally {
                        if (stopWatch != null) {
                            stopWatch.stop();
                        }
                    }
                }
                this.dirty = false;
                this.lastScan = System.currentTimeMillis();
                return bl2;
            }
        }
        return false;
    }

    public void reset() {
        this.dirty = false;
        this.lastScan = System.currentTimeMillis();
    }

    public String toString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.ENGLISH);
        return MiscUtil.identityToString(this) + " scanned at " + simpleDateFormat.format(new Date(this.lastScan)) + (this.dirty ? " dirty" : "") + (this.failed ? " failed" : "") + (this.directories ? " directories" : "") + (this.files.size() > 0 ? " files:" + this.files.size() : "");
    }

    public void destroy() {
        ResourceIntegrationFactory.getInstance().removeFileListener(this.listener);
        this.files.clear();
    }

    static boolean access$002(FileMonitorAdapter fileMonitorAdapter, boolean bl2) {
        fileMonitorAdapter.dirty = bl2;
        return fileMonitorAdapter.dirty;
    }

    static boolean access$100(FileMonitorAdapter fileMonitorAdapter) {
        return fileMonitorAdapter.onlyAdd;
    }

    static boolean access$202(FileMonitorAdapter fileMonitorAdapter, boolean bl2) {
        fileMonitorAdapter.failed = bl2;
        return fileMonitorAdapter.failed;
    }
}

