/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.monitor;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.zeroturnaround.javarebel.ConfigurationFactory;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.integration.monitor.MonitoredResource;
import org.zeroturnaround.javarebel.integration.util.ResourceUtil;
import org.zeroturnaround.javarebel.integration.util.WeakIdentityHashMap;
import org.zeroturnaround.javarebel.support.ResourceUtils;

public class MonitoredResourceManager {
    private static final Logger log = LoggerFactory.getLogger("Util");
    private static final ThreadLocal builderLocal = new ThreadLocal();
    private static final Map managersPerBuilder = Collections.synchronizedMap(new WeakIdentityHashMap());
    private static final long MODIFIED_CHECK_MIN_INTERVAL = ConfigurationFactory.getInstance().getCheckInterval();
    private final Map monitoredConfs = Collections.synchronizedMap(new HashMap());
    private long lastCheck = System.currentTimeMillis();

    public static void beginConf(Object object) {
        builderLocal.set(object);
    }

    public static void endConf() {
        builderLocal.set(null);
    }

    public static Object getConf() {
        return builderLocal.get();
    }

    private static synchronized MonitoredResourceManager get(Object object) {
        return (MonitoredResourceManager)managersPerBuilder.get(object);
    }

    private static synchronized MonitoredResourceManager getOrCreate(Object object) {
        MonitoredResourceManager monitoredResourceManager = (MonitoredResourceManager)managersPerBuilder.get(object);
        if (monitoredResourceManager == null) {
            monitoredResourceManager = new MonitoredResourceManager();
            managersPerBuilder.put(object, monitoredResourceManager);
        }
        return monitoredResourceManager;
    }

    public static Set modified(Object object) {
        MonitoredResourceManager monitoredResourceManager = MonitoredResourceManager.get(object);
        return monitoredResourceManager == null ? Collections.EMPTY_SET : monitoredResourceManager.modified();
    }

    private synchronized Set modified() {
        if (System.currentTimeMillis() < this.lastCheck + MODIFIED_CHECK_MIN_INTERVAL) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.monitoredConfs.values().iterator();
        while (iterator.hasNext()) {
            MonitoredResource monitoredResource = (MonitoredResource)iterator.next();
            if (!monitoredResource.modified()) continue;
            hashSet.add(monitoredResource.toString());
        }
        this.lastCheck = System.currentTimeMillis();
        return hashSet;
    }

    public static void registerConf(Class clazz) {
        MonitoredResourceManager.registerConf(clazz, MonitoredResourceManager.getConf());
    }

    public static void registerConf(ClassLoader classLoader, String string) {
        MonitoredResourceManager.registerConf(classLoader, string, MonitoredResourceManager.getConf());
    }

    public static void registerConf(URL uRL) {
        MonitoredResourceManager.registerConf(uRL, MonitoredResourceManager.getConf());
    }

    public static void registerConf(String string) {
        MonitoredResourceManager.registerConf(string, MonitoredResourceManager.getConf());
    }

    public static void registerConf(Class clazz, Object object) {
        if (clazz != null) {
            MonitoredResourceManager.registerConf(clazz.getClassLoader(), clazz.getName(), object);
        }
    }

    public static void registerConf(ClassLoader classLoader, String string, Object object) {
        if (classLoader != null) {
            MonitoredResourceManager.registerConf(classLoader.getResource(string.replace('.', '/') + ".class"), object);
        }
    }

    public static void registerConf(String string, Object object) {
        URL uRL;
        if (string == null) {
            return;
        }
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            log.echoPrefix("Warning! Could not monitor configuration in '" + string + "'.");
            log.error(malformedURLException);
            return;
        }
        MonitoredResourceManager.registerConf(uRL, object);
    }

    public static void registerConf(URL uRL, Object object) {
        if (uRL == null) {
            return;
        }
        if (object == null) {
            log.log("Warning! Could not monitor configuration in '" + uRL + "'.");
            log.error(new IllegalArgumentException("No builder provided"));
            return;
        }
        MonitoredResourceManager.getOrCreate(object).register(uRL);
    }

    public static boolean confRegistered(String string, Object object) {
        URL uRL;
        if (string == null) {
            return false;
        }
        MonitoredResourceManager monitoredResourceManager = MonitoredResourceManager.get(object);
        if (monitoredResourceManager == null) {
            return false;
        }
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            log.echoPrefix("Warning! Could not create url in '" + string + "'.");
            log.error(malformedURLException);
            return false;
        }
        return monitoredResourceManager.monitoredConfs.containsKey(uRL);
    }

    private synchronized void register(URL uRL) {
        if (!this.monitoredConfs.containsKey(uRL)) {
            if (ResourceUtils.isFileURL(uRL)) {
                File file = ResourceUtils.getFile(uRL);
                log.log("Monitoring configuration in '" + file + "'.");
            } else {
                log.log("Monitoring configuration in '" + uRL + "'.");
            }
        }
        this.monitoredConfs.put(uRL, new MonitoredResource(ResourceUtil.asResource(uRL)));
    }
}

