/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.resin;

import java.util.List;
import java.util.ListIterator;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.integration.util.AgentUtil;

public class ResinArgsHelper {
    private static final Logger log = LoggerFactory.getInstance().productPrefix("Resin");
    private static final String NO_VERIFY = "-noverify";
    private static final String JAVA_AGENT = "-javaagent:" + AgentUtil.getRebelJarPath();
    private static final String REBEL_LOG_FILE = "rebel.log.file";
    private static final String REBEL_LOG_FILE_PREFIX = "-Drebel.log.file=";
    private static final String REBEL_LOG_FILE_SUFFIX = "-fork";

    public static void processArguments(List list) {
        try {
            list.add(1, NO_VERIFY);
            list.add(1, JAVA_AGENT);
            String string = System.getProperty(REBEL_LOG_FILE);
            if (string != null) {
                ListIterator<String> listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    String string2 = (String)listIterator.next();
                    if (!string2.startsWith(REBEL_LOG_FILE_PREFIX)) continue;
                    int n2 = string2.lastIndexOf(46);
                    string2 = n2 < REBEL_LOG_FILE_PREFIX.length() ? string2 + REBEL_LOG_FILE_SUFFIX : string2.substring(0, n2) + REBEL_LOG_FILE_SUFFIX + string2.substring(n2);
                    listIterator.set(string2);
                }
            }
            if (log.isEnabled()) {
                log.log("Exec args:" + list);
            }
        }
        catch (Throwable throwable) {
            log.error(throwable);
        }
    }

    public static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\"' || c2 == '\\') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }
}

