/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.support;

import com.zeroturnaround.javarebel.bn;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.zeroturnaround.bundled.javassist.ByteArrayClassPath;
import org.zeroturnaround.bundled.javassist.ClassPath;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.javarebel.AgentIntegration;
import org.zeroturnaround.javarebel.AgentIntegrationFactory;
import org.zeroturnaround.javarebel.ClassBytecodeProcessor;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.StopWatch;
import org.zeroturnaround.javarebel.integration.support.JavassistClassBytecodeProcessor$1;
import org.zeroturnaround.javarebel.integration.support.JavassistClassBytecodeProcessor$2;
import org.zeroturnaround.javarebel.integration.support.JavassistClassBytecodeProcessor$3;
import org.zeroturnaround.javarebel.integration.support.JavassistClassBytecodeProcessor$ClassFilter;
import org.zeroturnaround.javarebel.integration.support.JavassistClassBytecodeProcessor$FilterClassPathWrapper;
import org.zeroturnaround.javarebel.integration.support.JavassistClassBytecodeProcessor$RebelClassPath;
import org.zeroturnaround.javarebel.integration.support.PublicAgentClassPath;
import org.zeroturnaround.javarebel.integration.support.RestrictedClassClassPath;
import org.zeroturnaround.javarebel.integration.support.RestrictedLoaderClassPath;
import org.zeroturnaround.javarebel.integration.util.MiscUtil;

public abstract class JavassistClassBytecodeProcessor
implements ClassBytecodeProcessor {
    private static final AgentIntegration agent = AgentIntegrationFactory.getInstance();
    static final Logger log = LoggerFactory.getLogger("SDK-CBP");
    private static final JavassistClassBytecodeProcessor$ClassFilter ignoreDefault = new JavassistClassBytecodeProcessor$1();
    private static final JavassistClassBytecodeProcessor$ClassFilter ignoreJava = new JavassistClassBytecodeProcessor$2();
    static Class class$java$lang$ClassLoader;
    static Class class$java$lang$String;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] process(ClassLoader classLoader, String string, byte[] byArray) {
        StopWatch stopWatch = LoggerFactory.getInstance().createStopWatch("JavassistClassBytecodeProcessor");
        CtClass ctClass = null;
        try {
            string = string.replace('/', '.');
            ClassPool classPool = new ClassPool();
            if (log.isTraceEnabled()) {
                classPool.appendClassPath(new JavassistClassBytecodeProcessor$RebelClassPath(null));
            }
            classPool.appendClassPath(new ByteArrayClassPath(string, byArray));
            if (agent.arePublicClassBytesCached()) {
                classPool.appendClassPath(PublicAgentClassPath.getInstance());
            }
            if (classLoader != null) {
                classPool.appendClassPath(JavassistClassBytecodeProcessor.ignoreJava(JavassistClassBytecodeProcessor.ignoreDefaultPackage(new RestrictedLoaderClassPath(classLoader))));
            }
            classPool.appendClassPath(JavassistClassBytecodeProcessor.ignoreDefaultPackage(new RestrictedClassClassPath()));
            ctClass = classPool.get(string);
            ctClass.defrost();
            this.process(classPool, classLoader, ctClass);
            byte[] byArray2 = ctClass.toBytecode();
            return byArray2;
        }
        catch (Throwable throwable) {
            if (throwable instanceof LinkageError && throwable.getClass().getName().startsWith("com.zeroturnaround.") || throwable instanceof ClassCircularityError) {
                throw (Error)throwable;
            }
            log.echoPrefix("Class '" + string + "' could not be processed by " + MiscUtil.identityToString(this.getClass()));
            log.errorEcho(throwable);
            JavassistClassBytecodeProcessor.reportCBPFailure(throwable, ctClass, classLoader, string);
            byte[] byArray3 = byArray;
            return byArray3;
        }
        finally {
            if (stopWatch != null) {
                stopWatch.stop();
            }
        }
    }

    public abstract void process(ClassPool var1, ClassLoader var2, CtClass var3) throws Exception;

    private static ClassPath ignoreDefaultPackage(ClassPath classPath) {
        return new JavassistClassBytecodeProcessor$FilterClassPathWrapper(classPath, ignoreDefault);
    }

    private static ClassPath ignoreJava(ClassPath classPath) {
        return new JavassistClassBytecodeProcessor$FilterClassPathWrapper(classPath, ignoreJava);
    }

    private static void reportCBPFailure(Throwable throwable, CtClass ctClass, ClassLoader classLoader, String string) {
        Object object;
        Object object2;
        Object object3;
        if (classLoader == null) {
            return;
        }
        Object object4 = null;
        String string2 = null;
        URL uRL = classLoader.getResource(bn.a(string, ".", "/").concat(".class"));
        if (uRL != null && "jar".equals(uRL.getProtocol())) {
            object3 = uRL.getFile().substring(0, uRL.getFile().lastIndexOf(".jar"));
            string2 = ((String)object3).substring(((String)object3).lastIndexOf(47) + 1);
            try {
                object2 = uRL.openConnection();
                object = ((JarURLConnection)object2).getManifest();
                if (object != null) {
                    Attributes attributes = ((Manifest)object).getMainAttributes();
                    object4 = String.valueOf(attributes.get(Attributes.Name.IMPLEMENTATION_VERSION)) == null ? String.valueOf(attributes.get(Attributes.Name.SPECIFICATION_VERSION)) : String.valueOf(attributes.get(Attributes.Name.IMPLEMENTATION_VERSION));
                }
            }
            catch (IOException iOException) {
                log.warn("Got error while trying to determine package/filename via jar for '" + string + "'", iOException);
            }
        }
        if (string2 == null || object4 == null) {
            try {
                Class<?> clazz = class$java$lang$ClassLoader;
                if (clazz == null) {
                    clazz = class$java$lang$ClassLoader = new ClassLoader[0].getClass().getComponentType();
                }
                Class[] classArray = new Class[1];
                Class<?> clazz2 = class$java$lang$String;
                if (clazz2 == null) {
                    clazz2 = class$java$lang$String = new String[0].getClass().getComponentType();
                }
                classArray[0] = clazz2;
                object3 = clazz.getDeclaredMethod("getPackage", classArray);
                ((Method)object3).setAccessible(true);
                object2 = (Package)((Method)object3).invoke((Object)classLoader, ctClass.getPackageName());
                if (object4 == null) {
                    Object object5 = object4 = ((Package)object2).getImplementationVersion() != null ? ((Package)object2).getImplementationVersion() : ((Package)object2).getSpecificationVersion();
                }
                if (string2 == null) {
                    string2 = ((Package)object2).getImplementationTitle() != null ? ((Package)object2).getImplementationTitle() : ((Package)object2).getSpecificationTitle();
                }
            }
            catch (Exception exception) {
                log.warn("Got error while trying to determine package/filename via classloader for '" + string + "'", exception);
            }
        }
        object3 = string2;
        object2 = object4;
        object = new Thread(new JavassistClassBytecodeProcessor$3(throwable, (String)object2, (String)object3));
        ((Thread)object).setDaemon(true);
        ((Thread)object).start();
    }
}

