/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public abstract class ClassReflectionUtil {
    public static Set getClassHierarchy(Class clazz) {
        return ClassReflectionUtil.getClassHierarchies(Collections.singleton(clazz));
    }

    public static Set getClassHierarchies(Class[] classArray) {
        return ClassReflectionUtil.getClassHierarchies(Arrays.asList(classArray));
    }

    public static Set getClassHierarchies(Collection collection) {
        LinkedList linkedList = new LinkedList(collection);
        HashSet<Class> hashSet = new HashSet<Class>();
        while (!linkedList.isEmpty()) {
            Class<?>[] classArray;
            Class clazz = (Class)linkedList.remove(0);
            if (clazz == null) continue;
            hashSet.add(clazz);
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 != null && !hashSet.contains(clazz2)) {
                linkedList.add(clazz2);
            }
            if ((classArray = clazz.getInterfaces()) == null) continue;
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                Class<?> clazz3 = classArray[i2];
                if (hashSet.contains(clazz3)) continue;
                linkedList.add(clazz3);
            }
        }
        return hashSet;
    }

    public static Set getInterfaces(Collection collection) {
        if (collection == null) {
            return null;
        }
        HashSet hashSet = new HashSet();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            if (clazz == null) continue;
            hashSet.addAll(Arrays.asList(clazz.getInterfaces()));
        }
        return hashSet;
    }
}

