/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.integration.util.DeployUtil$DeployDescriptorInfo;
import org.zeroturnaround.javarebel.integration.util.FileUtil;
import org.zeroturnaround.javarebel.support.ResourceUtils;
import org.zeroturnaround.zip.ZipUtil;

public class DeployUtil {
    private static final Logger log = LoggerFactory.getInstance();
    public static final Object LIVEREBEL_DEPLOY_LOCK = new Object();
    private static final Collection deployments = Collections.synchronizedCollection(new HashSet());

    public static File copyFileToDirectory(File file, File file2, String string) throws IOException {
        File file3 = DeployUtil.getDeploymentFile(file, file2, string);
        FileUtil.copyFile(file, file3);
        return file3;
    }

    public static File getDeploymentFile(File file, File file2, String string) {
        return DeployUtil.getDeploymentFile(file, file2, string, null);
    }

    public static File getDeploymentFile(File file, File file2, String string, String string2) {
        String string3;
        if (file == null) {
            throw new IllegalArgumentException("Source file must be provided.");
        }
        if (file2 == null) {
            throw new IllegalArgumentException("Destination directory must be provided.");
        }
        if (string == null && string2 == null) {
            string3 = file.getName();
        } else {
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            String string4 = FileUtil.getExtension(file);
            String string5 = string2 == null ? "" : DeployUtil.sanitizeFilename(string2);
            string3 = string4 == null ? string : string + string5 + "." + string4;
        }
        return new File(file2, string3);
    }

    private static String sanitizeFilename(String string) {
        return string.replaceAll("[:\\\\/*?|<>]", "_");
    }

    public static void markDeployment(File file) {
        DeployUtil.markDeployment(file.getPath());
    }

    public static void markDeployment(String string) {
        deployments.add(string);
        if (log.isEnabled()) {
            log.log("Marked " + string);
        }
    }

    public static boolean unmarkDeploymentURL(String string) {
        try {
            return DeployUtil.unmarkDeployment(ResourceUtils.getFile(new URL(string)).getPath());
        }
        catch (Exception exception) {
            log.error(exception);
            return false;
        }
    }

    public static boolean unmarkDeploymentURL(URL uRL) {
        try {
            return DeployUtil.unmarkDeployment(ResourceUtils.getFile(uRL).getPath());
        }
        catch (Exception exception) {
            log.error(exception);
            return false;
        }
    }

    public static boolean unmarkDeployment(File file) {
        return DeployUtil.unmarkDeployment(file.getPath());
    }

    public static boolean unmarkDeployment(String string) {
        boolean bl2 = deployments.remove(string);
        if (log.isEnabled()) {
            log.log("Unmarked " + string + " (" + bl2 + ")");
        }
        return bl2;
    }

    public static boolean isMarkedDeployment(String string) {
        boolean bl2 = deployments.contains(string);
        if (log.isEnabled()) {
            log.log("Is marked " + string + " (" + bl2 + ")");
        }
        return bl2;
    }

    public static File prepareAndMoveDeployment(File file, File file2, String string, String string2, String string3, DeployUtil$DeployDescriptorInfo deployUtil$DeployDescriptorInfo) throws IOException {
        if (file2 == null) {
            throw new IllegalStateException("Default directory not set.");
        }
        String string4 = string;
        if ("".equals(string4) || "/".equals(string4)) {
            string4 = string3;
        }
        String string5 = string2 == null || "ear".equalsIgnoreCase(FileUtil.getExtension(file)) ? "" : "." + string2;
        File file3 = DeployUtil.getDeploymentFile(file, file2, string4, string5);
        File file4 = File.createTempFile(file.getName() + "-wDeployDescriptor", null);
        file4.deleteOnExit();
        FileUtil.copyFile(file, file4);
        log.log("Prepearing file " + file4 + " based on " + file + " for deploying to context path " + string + (string2 != null ? " on virtual host " + string2 : "") + " - adding deploy descriptor");
        DeployUtil.addDeployDescriptor(file4, string, string2, deployUtil$DeployDescriptorInfo);
        DeployUtil.markDeployment(file3);
        log.log("Moving prepeared file " + file4 + " to " + file3);
        FileUtil.copyFile(file4, file3);
        file4.delete();
        return file3;
    }

    private static String getNormalizedContextPath(String string) {
        if (string != null && !string.startsWith("/")) {
            string = "/" + string.trim();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeStringToFile(File file, String string) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        try {
            fileWriter.write(string);
            fileWriter.flush();
            fileWriter.close();
        }
        finally {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
    }

    private static void addDeployDescriptor(File file, String string, String string2, DeployUtil$DeployDescriptorInfo deployUtil$DeployDescriptorInfo) {
        File file2;
        String string3 = deployUtil$DeployDescriptorInfo.getDescriptorContent(string2, DeployUtil.getNormalizedContextPath(string));
        String string4 = deployUtil$DeployDescriptorInfo.getDeployDescriptorPath();
        try {
            file2 = File.createTempFile(file.getName() + "-DeployDescriptor.xml", null);
            file2.deleteOnExit();
            DeployUtil.writeStringToFile(file2, string3);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to write JBoss deployment description to temp file " + string4, iOException);
        }
        File file3 = new File(file.getPath() + ".tmp");
        if (!file.renameTo(file3)) {
            throw new RuntimeException("Failed to rename " + file + " to " + file3 + " to add " + string4 + " to it");
        }
        if (ZipUtil.containsEntry(file3, string4)) {
            ZipUtil.replaceEntry(file3, string4, file2, file);
        } else {
            ZipUtil.addEntry(file3, string4, string3.getBytes(), file);
        }
        file2.delete();
        file3.delete();
    }
}

