/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.integration.util.AgentUtil;

public class JavaForkUtil {
    private static final Logger log = LoggerFactory.getInstance();
    private static final int NEW_ARG_INDEX = 1;
    private static final String NO_VERIFY = "-noverify";
    private static final String JAVA_AGENT = "-javaagent:" + AgentUtil.getRebelJarPath();
    private static final String REBEL_LOG = "rebel.log";
    private static final String REBEL_LOG_PREFIX = "-Drebel.log=";
    private static final String REBEL_LOG_FILE = "rebel.log.file";
    private static final String REBEL_LOG_FILE_PREFIX = "-Drebel.log.file=";
    private static final String REBEL_LOG_FILE_SUFFIX = "-fork";

    public static void processArguments(List list) {
        try {
            HashSet hashSet = new HashSet(list);
            if (!hashSet.contains(NO_VERIFY)) {
                list.add(1, NO_VERIFY);
            }
            if (!hashSet.contains(JAVA_AGENT)) {
                list.add(1, JAVA_AGENT);
            }
            JavaForkUtil.processRebelLogValue(list);
            JavaForkUtil.processRebelLogFile(list);
            if (log.isEnabled()) {
                log.log("Forked JVM arguments: " + list);
            }
        }
        catch (Throwable throwable) {
            log.echoPrefix("Failed to process arguments of the forked JVM");
            log.errorEcho(throwable);
        }
    }

    private static void processRebelLogValue(List list) {
        String string = System.getProperty(REBEL_LOG);
        if (string == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.startsWith(REBEL_LOG_PREFIX)) continue;
            return;
        }
        list.add(1, REBEL_LOG_PREFIX + string);
    }

    private static void processRebelLogFile(List list) {
        String string = System.getProperty(REBEL_LOG_FILE);
        if (string == null) {
            return;
        }
        String string2 = REBEL_LOG_FILE_PREFIX + JavaForkUtil.getRebelLogFileForked(string);
        ListIterator<String> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            String string3 = (String)listIterator.next();
            if (!string3.startsWith(REBEL_LOG_FILE_PREFIX)) continue;
            String string4 = string3.substring(REBEL_LOG_FILE_PREFIX.length());
            if (string.equals(string4)) {
                listIterator.set(string2);
            }
            return;
        }
        list.add(1, string2);
    }

    private static String getRebelLogFileForked(String string) {
        int n2 = string.lastIndexOf(46);
        string = n2 != -1 ? string.substring(0, n2) + REBEL_LOG_FILE_SUFFIX + string.substring(n2) : string + REBEL_LOG_FILE_SUFFIX;
        return string;
    }
}

