/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.zeroturnaround.javarebel.integration.util.WeakIdentityHashMap$Entry;
import org.zeroturnaround.javarebel.integration.util.WeakIdentityHashMap$EntrySet;
import org.zeroturnaround.javarebel.integration.util.WeakIdentityHashMap$KeySet;
import org.zeroturnaround.javarebel.integration.util.WeakIdentityHashMap$Values;

public class WeakIdentityHashMap
implements Map {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private WeakIdentityHashMap$Entry[] table;
    private int size;
    private int threshold;
    private final float loadFactor;
    private final ReferenceQueue queue = new ReferenceQueue();
    private volatile int modCount;
    volatile transient Set keySet = null;
    volatile transient Collection values = null;
    private static final Object NULL_KEY = new Object();
    private transient Set entrySet = null;

    public WeakIdentityHashMap(int n2, float f2) {
        int n3;
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + n2);
        }
        if (n2 > 0x40000000) {
            n2 = 0x40000000;
        }
        if (f2 <= 0.0f || Float.isNaN(f2)) {
            throw new IllegalArgumentException("Illegal Load factor: " + f2);
        }
        for (n3 = 1; n3 < n2; n3 <<= 1) {
        }
        this.table = new WeakIdentityHashMap$Entry[n3];
        this.loadFactor = f2;
        this.threshold = (int)((float)n3 * f2);
    }

    public WeakIdentityHashMap(int n2) {
        this(n2, 0.75f);
    }

    public WeakIdentityHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 16;
        this.table = new WeakIdentityHashMap$Entry[16];
    }

    public WeakIdentityHashMap(Map map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f);
        this.putAll(map);
    }

    private static Object maskNull(Object object) {
        return object == null ? NULL_KEY : object;
    }

    private static Object unmaskNull(Object object) {
        return object == NULL_KEY ? null : object;
    }

    int hash(Object object) {
        int n2 = System.identityHashCode(object);
        return n2 - (n2 << 7);
    }

    static int indexFor(int n2, int n3) {
        return n2 & n3 - 1;
    }

    private void expungeStaleEntries() {
        Reference reference;
        block0: while ((reference = this.queue.poll()) != null) {
            WeakIdentityHashMap$Entry weakIdentityHashMap$Entry;
            WeakIdentityHashMap$Entry weakIdentityHashMap$Entry2 = (WeakIdentityHashMap$Entry)reference;
            int n2 = WeakIdentityHashMap$Entry.access$000(weakIdentityHashMap$Entry2);
            int n3 = WeakIdentityHashMap.indexFor(n2, this.table.length);
            WeakIdentityHashMap$Entry weakIdentityHashMap$Entry3 = weakIdentityHashMap$Entry = this.table[n3];
            while (weakIdentityHashMap$Entry3 != null) {
                WeakIdentityHashMap$Entry weakIdentityHashMap$Entry4 = WeakIdentityHashMap$Entry.access$100(weakIdentityHashMap$Entry3);
                if (weakIdentityHashMap$Entry3 == weakIdentityHashMap$Entry2) {
                    if (weakIdentityHashMap$Entry == weakIdentityHashMap$Entry2) {
                        this.table[n3] = weakIdentityHashMap$Entry4;
                    } else {
                        WeakIdentityHashMap$Entry.access$102(weakIdentityHashMap$Entry, weakIdentityHashMap$Entry4);
                    }
                    WeakIdentityHashMap$Entry.access$102(weakIdentityHashMap$Entry2, null);
                    WeakIdentityHashMap$Entry.access$202(weakIdentityHashMap$Entry2, null);
                    --this.size;
                    continue block0;
                }
                weakIdentityHashMap$Entry = weakIdentityHashMap$Entry3;
                weakIdentityHashMap$Entry3 = weakIdentityHashMap$Entry4;
            }
        }
    }

    private WeakIdentityHashMap$Entry[] getTable() {
        this.expungeStaleEntries();
        return this.table;
    }

    public int size() {
        if (this.size == 0) {
            return 0;
        }
        this.expungeStaleEntries();
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object get(Object object) {
        Object object2 = WeakIdentityHashMap.maskNull(object);
        int n2 = this.hash(object2);
        WeakIdentityHashMap$Entry[] weakIdentityHashMap$EntryArray = this.getTable();
        int n3 = WeakIdentityHashMap.indexFor(n2, weakIdentityHashMap$EntryArray.length);
        WeakIdentityHashMap$Entry weakIdentityHashMap$Entry = weakIdentityHashMap$EntryArray[n3];
        while (weakIdentityHashMap$Entry != null) {
            if (WeakIdentityHashMap$Entry.access$000(weakIdentityHashMap$Entry) == n2 && object2 == weakIdentityHashMap$Entry.get()) {
                return WeakIdentityHashMap$Entry.access$200(weakIdentityHashMap$Entry);
            }
            weakIdentityHashMap$Entry = WeakIdentityHashMap$Entry.access$100(weakIdentityHashMap$Entry);
        }
        return null;
    }

    public boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    WeakIdentityHashMap$Entry getEntry(Object object) {
        Object object2 = WeakIdentityHashMap.maskNull(object);
        int n2 = this.hash(object2);
        WeakIdentityHashMap$Entry[] weakIdentityHashMap$EntryArray = this.getTable();
        int n3 = WeakIdentityHashMap.indexFor(n2, weakIdentityHashMap$EntryArray.length);
        WeakIdentityHashMap$Entry weakIdentityHashMap$Entry = weakIdentityHashMap$EntryArray[n3];
        while (weakIdentityHashMap$Entry != null && (WeakIdentityHashMap$Entry.access$000(weakIdentityHashMap$Entry) != n2 || object2 != weakIdentityHashMap$Entry.get())) {
            weakIdentityHashMap$Entry = WeakIdentityHashMap$Entry.access$100(weakIdentityHashMap$Entry);
        }
        return weakIdentityHashMap$Entry;
    }

    public Object put(Object object, Object object2) {
        Object object3 = WeakIdentityHashMap.maskNull(object);
        int n2 = this.hash(object3);
        WeakIdentityHashMap$Entry[] weakIdentityHashMap$EntryArray = this.getTable();
        int n3 = WeakIdentityHashMap.indexFor(n2, weakIdentityHashMap$EntryArray.length);
        WeakIdentityHashMap$Entry weakIdentityHashMap$Entry = weakIdentityHashMap$EntryArray[n3];
        while (weakIdentityHashMap$Entry != null) {
            if (n2 == WeakIdentityHashMap$Entry.access$000(weakIdentityHashMap$Entry) && object3 == weakIdentityHashMap$Entry.get()) {
                Object object4 = WeakIdentityHashMap$Entry.access$200(weakIdentityHashMap$Entry);
                if (object2 != object4) {
                    WeakIdentityHashMap$Entry.access$202(weakIdentityHashMap$Entry, object2);
                }
                return object4;
            }
            weakIdentityHashMap$Entry = WeakIdentityHashMap$Entry.access$100(weakIdentityHashMap$Entry);
        }
        ++this.modCount;
        weakIdentityHashMap$EntryArray[n3] = new WeakIdentityHashMap$Entry(object3, object2, this.queue, n2, weakIdentityHashMap$EntryArray[n3]);
        if (++this.size >= this.threshold) {
            this.resize(weakIdentityHashMap$EntryArray.length * 2);
        }
        return null;
    }

    void resize(int n2) {
        WeakIdentityHashMap$Entry[] weakIdentityHashMap$EntryArray = this.getTable();
        int n3 = weakIdentityHashMap$EntryArray.length;
        if (this.size < this.threshold || n3 > n2) {
            return;
        }
        WeakIdentityHashMap$Entry[] weakIdentityHashMap$EntryArray2 = new WeakIdentityHashMap$Entry[n2];
        this.transfer(weakIdentityHashMap$EntryArray, weakIdentityHashMap$EntryArray2);
        this.table = weakIdentityHashMap$EntryArray2;
        if (this.size >= this.threshold / 2) {
            this.threshold = (int)((float)n2 * this.loadFactor);
        } else {
            this.expungeStaleEntries();
            this.transfer(weakIdentityHashMap$EntryArray2, weakIdentityHashMap$EntryArray);
            this.table = weakIdentityHashMap$EntryArray;
        }
    }

    private void transfer(WeakIdentityHashMap$Entry[] weakIdentityHashMap$EntryArray, WeakIdentityHashMap$Entry[] weakIdentityHashMap$EntryArray2) {
        for (int i2 = 0; i2 < weakIdentityHashMap$EntryArray.length; ++i2) {
            WeakIdentityHashMap$Entry weakIdentityHashMap$Entry = weakIdentityHashMap$EntryArray[i2];
            weakIdentityHashMap$EntryArray[i2] = null;
            while (weakIdentityHashMap$Entry != null) {
                WeakIdentityHashMap$Entry weakIdentityHashMap$Entry2 = WeakIdentityHashMap$Entry.access$100(weakIdentityHashMap$Entry);
                Object t2 = weakIdentityHashMap$Entry.get();
                if (t2 == null) {
                    WeakIdentityHashMap$Entry.access$102(weakIdentityHashMap$Entry, null);
                    WeakIdentityHashMap$Entry.access$202(weakIdentityHashMap$Entry, null);
                    --this.size;
                } else {
                    int n2 = WeakIdentityHashMap.indexFor(WeakIdentityHashMap$Entry.access$000(weakIdentityHashMap$Entry), weakIdentityHashMap$EntryArray2.length);
                    WeakIdentityHashMap$Entry.access$102(weakIdentityHashMap$Entry, weakIdentityHashMap$EntryArray2[n2]);
                    weakIdentityHashMap$EntryArray2[n2] = weakIdentityHashMap$Entry;
                }
                weakIdentityHashMap$Entry = weakIdentityHashMap$Entry2;
            }
        }
    }

    public void putAll(Map map) {
        int n2 = map.size();
        if (n2 == 0) {
            return;
        }
        if (n2 >= this.threshold) {
            int n3;
            if ((n2 = (int)((float)n2 / this.loadFactor + 1.0f)) > 0x40000000) {
                n2 = 0x40000000;
            }
            for (n3 = this.table.length; n3 < n2; n3 <<= 1) {
            }
            this.resize(n3);
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object object) {
        WeakIdentityHashMap$Entry weakIdentityHashMap$Entry;
        Object object2 = WeakIdentityHashMap.maskNull(object);
        int n2 = this.hash(object2);
        WeakIdentityHashMap$Entry[] weakIdentityHashMap$EntryArray = this.getTable();
        int n3 = WeakIdentityHashMap.indexFor(n2, weakIdentityHashMap$EntryArray.length);
        WeakIdentityHashMap$Entry weakIdentityHashMap$Entry2 = weakIdentityHashMap$Entry = weakIdentityHashMap$EntryArray[n3];
        while (weakIdentityHashMap$Entry2 != null) {
            WeakIdentityHashMap$Entry weakIdentityHashMap$Entry3 = WeakIdentityHashMap$Entry.access$100(weakIdentityHashMap$Entry2);
            if (n2 == WeakIdentityHashMap$Entry.access$000(weakIdentityHashMap$Entry2) && object2 == weakIdentityHashMap$Entry2.get()) {
                ++this.modCount;
                --this.size;
                if (weakIdentityHashMap$Entry == weakIdentityHashMap$Entry2) {
                    weakIdentityHashMap$EntryArray[n3] = weakIdentityHashMap$Entry3;
                } else {
                    WeakIdentityHashMap$Entry.access$102(weakIdentityHashMap$Entry, weakIdentityHashMap$Entry3);
                }
                return WeakIdentityHashMap$Entry.access$200(weakIdentityHashMap$Entry2);
            }
            weakIdentityHashMap$Entry = weakIdentityHashMap$Entry2;
            weakIdentityHashMap$Entry2 = weakIdentityHashMap$Entry3;
        }
        return null;
    }

    WeakIdentityHashMap$Entry removeMapping(Object object) {
        WeakIdentityHashMap$Entry weakIdentityHashMap$Entry;
        if (!(object instanceof Map.Entry)) {
            return null;
        }
        WeakIdentityHashMap$Entry[] weakIdentityHashMap$EntryArray = this.getTable();
        Map.Entry entry = (Map.Entry)object;
        Object object2 = WeakIdentityHashMap.maskNull(entry.getKey());
        int n2 = this.hash(object2);
        int n3 = WeakIdentityHashMap.indexFor(n2, weakIdentityHashMap$EntryArray.length);
        WeakIdentityHashMap$Entry weakIdentityHashMap$Entry2 = weakIdentityHashMap$Entry = weakIdentityHashMap$EntryArray[n3];
        while (weakIdentityHashMap$Entry2 != null) {
            WeakIdentityHashMap$Entry weakIdentityHashMap$Entry3 = WeakIdentityHashMap$Entry.access$100(weakIdentityHashMap$Entry2);
            if (n2 == WeakIdentityHashMap$Entry.access$000(weakIdentityHashMap$Entry2) && weakIdentityHashMap$Entry2.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (weakIdentityHashMap$Entry == weakIdentityHashMap$Entry2) {
                    weakIdentityHashMap$EntryArray[n3] = weakIdentityHashMap$Entry3;
                } else {
                    WeakIdentityHashMap$Entry.access$102(weakIdentityHashMap$Entry, weakIdentityHashMap$Entry3);
                }
                return weakIdentityHashMap$Entry2;
            }
            weakIdentityHashMap$Entry = weakIdentityHashMap$Entry2;
            weakIdentityHashMap$Entry2 = weakIdentityHashMap$Entry3;
        }
        return null;
    }

    public void clear() {
        while (this.queue.poll() != null) {
        }
        ++this.modCount;
        WeakIdentityHashMap$Entry[] weakIdentityHashMap$EntryArray = this.table;
        for (int i2 = 0; i2 < weakIdentityHashMap$EntryArray.length; ++i2) {
            weakIdentityHashMap$EntryArray[i2] = null;
        }
        this.size = 0;
        while (this.queue.poll() != null) {
        }
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            return this.containsNullValue();
        }
        WeakIdentityHashMap$Entry[] weakIdentityHashMap$EntryArray = this.getTable();
        int n2 = weakIdentityHashMap$EntryArray.length;
        while (n2-- > 0) {
            WeakIdentityHashMap$Entry weakIdentityHashMap$Entry = weakIdentityHashMap$EntryArray[n2];
            while (weakIdentityHashMap$Entry != null) {
                if (object.equals(WeakIdentityHashMap$Entry.access$200(weakIdentityHashMap$Entry))) {
                    return true;
                }
                weakIdentityHashMap$Entry = WeakIdentityHashMap$Entry.access$100(weakIdentityHashMap$Entry);
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        WeakIdentityHashMap$Entry[] weakIdentityHashMap$EntryArray = this.getTable();
        int n2 = weakIdentityHashMap$EntryArray.length;
        while (n2-- > 0) {
            WeakIdentityHashMap$Entry weakIdentityHashMap$Entry = weakIdentityHashMap$EntryArray[n2];
            while (weakIdentityHashMap$Entry != null) {
                if (WeakIdentityHashMap$Entry.access$200(weakIdentityHashMap$Entry) == null) {
                    return true;
                }
                weakIdentityHashMap$Entry = WeakIdentityHashMap$Entry.access$100(weakIdentityHashMap$Entry);
            }
        }
        return false;
    }

    public Set keySet() {
        Set set = this.keySet;
        return set != null ? set : (this.keySet = new WeakIdentityHashMap$KeySet(this, null));
    }

    public Collection values() {
        Collection collection = this.values;
        return collection != null ? collection : (this.values = new WeakIdentityHashMap$Values(this, null));
    }

    public Set entrySet() {
        Set set = this.entrySet;
        return set != null ? set : (this.entrySet = new WeakIdentityHashMap$EntrySet(this, null));
    }

    static Object access$300(Object object) {
        return WeakIdentityHashMap.unmaskNull(object);
    }

    static int access$400(WeakIdentityHashMap weakIdentityHashMap) {
        return weakIdentityHashMap.modCount;
    }

    static WeakIdentityHashMap$Entry[] access$500(WeakIdentityHashMap weakIdentityHashMap) {
        return weakIdentityHashMap.table;
    }
}

