/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.support;

import java.io.File;
import org.zeroturnaround.javarebel.FileEventListener;

public class FileNameAwareListener
implements FileEventListener {
    private final FileEventListener target;
    private final String fileName;

    public FileNameAwareListener(FileEventListener fileEventListener, String string) {
        this.target = fileEventListener;
        this.fileName = string;
    }

    public FileEventListener getParent() {
        return this.target;
    }

    public boolean isRecursive() {
        return false;
    }

    public void onFileAdd(File file) {
        if (this.accept(file)) {
            this.target.onFileAdd(file);
        }
    }

    public void onFileRemove(File file) {
        if (this.accept(file)) {
            this.target.onFileRemove(file);
        }
    }

    public void onFileChange(File file) {
        if (this.accept(file)) {
            this.target.onFileChange(file);
        }
    }

    private boolean accept(File file) {
        return this.fileName == null || this.fileName.equals(file.getName());
    }

    public void onFileDirty(File file) {
        this.target.onFileDirty(file);
    }

    public void onFailure() {
        this.target.onFailure();
    }
}

