/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.support;

import java.util.Map;
import java.util.Properties;

public class JVMUtils {
    public static final String JAVA_FULLVERSION = "java.fullversion";
    public static final String JAVA_RUNTIME_VERSION = "java.runtime.version";
    public static final String JAVA_VERSION = "java.version";
    public static final String OS_ARCH = "os.arch";

    public static String getDetailedJavaVersion(String string, String string2, String string3, String string4) {
        if (string != null) {
            string = string.replaceAll("enabled", "").replaceAll("disabled", "");
            string = string.replaceAll("Compressed References ", "");
            string = string.replaceAll("\nGC.*(\n|$)", "\n");
            return string + "_" + string4;
        }
        if (string2 != null) {
            return string2 + "_" + string4;
        }
        if (string3 != null) {
            return string3 + "_" + string4;
        }
        return null;
    }

    public static String getDetailedJavaVersion(Map map) {
        String string = (String)map.get(JAVA_FULLVERSION);
        String string2 = (String)map.get(JAVA_RUNTIME_VERSION);
        String string3 = (String)map.get(JAVA_VERSION);
        String string4 = (String)map.get(OS_ARCH);
        return JVMUtils.getDetailedJavaVersion(string, string2, string3, string4);
    }

    public static Properties copySystemPropertiesForDetailedVersion() {
        Properties properties = new Properties();
        JVMUtils.putIfNonNull(properties, JAVA_FULLVERSION, System.getProperty(JAVA_FULLVERSION));
        JVMUtils.putIfNonNull(properties, JAVA_RUNTIME_VERSION, System.getProperty(JAVA_RUNTIME_VERSION));
        JVMUtils.putIfNonNull(properties, JAVA_VERSION, System.getProperty(JAVA_VERSION));
        JVMUtils.putIfNonNull(properties, OS_ARCH, System.getProperty(OS_ARCH));
        return properties;
    }

    private static void putIfNonNull(Map map, String string, String string2) {
        if (string2 != null) {
            map.put(string, string2);
        }
    }
}

