/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.jrebel.conf.bus.plugin;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import org.apache.commons.io.IOUtils;
import org.zeroturnaround.zip.ZipEntryCallback;
import org.zeroturnaround.zip.ZipUtil;

class ZipClassLoader
extends ClassLoader {
    private static int counter = 0;
    private final String id;
    private final Map<String, byte[]> entries = new LinkedHashMap<String, byte[]>();

    private static synchronized int nextCounter() {
        return counter++;
    }

    public ZipClassLoader(InputStream in, ClassLoader parent) {
        super(parent);
        this.id = String.valueOf(ZipClassLoader.nextCounter());
        ZipUtil.iterate(in, new ZipEntryCallback(){

            public void process(InputStream in, ZipEntry zipEntry) throws IOException {
                ZipClassLoader.this.entries.put(zipEntry.getName(), IOUtils.toByteArray(in));
            }
        });
    }

    public Class findClass(String name) throws ClassNotFoundException {
        byte[] bytes = this.findResourceBytes(name.replace('.', '/') + ".class");
        if (bytes == null) {
            throw new ClassNotFoundException(name);
        }
        return this.defineClass(name, bytes, 0, bytes.length);
    }

    public URL findResource(String name) {
        byte[] bytes = this.findResourceBytes(name);
        if (bytes == null) {
            return null;
        }
        return this.makeURL(name);
    }

    public InputStream findResourceAsStream(String name) {
        byte[] bytes = this.findResourceBytes(name);
        return bytes == null ? null : new ByteArrayInputStream(bytes);
    }

    private byte[] findResourceBytes(String name) {
        return this.entries.get(name);
    }

    private URL makeURL(final String name) {
        try {
            return new URL(null, "zipcl:" + this.id + "/" + name, new URLStreamHandler(){

                protected URLConnection openConnection(URL u) throws IOException {
                    return new URLConnection(u){

                        public void connect() throws IOException {
                        }

                        public InputStream getInputStream() throws IOException {
                            return ZipClassLoader.this.findResourceAsStream(name);
                        }

                        public int getContentLength() {
                            byte[] bytes = ZipClassLoader.this.findResourceBytes(name);
                            return bytes == null ? -1 : bytes.length;
                        }
                    };
                }
            });
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

